<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>常见问题详情</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$(".grandParentCategory").change(function () {
				var id = $(this).val();
				$.ajax({
					type: "POST",
					url:"${ctx}/faqApi/findByParentId",
					data:{"parent.id":id},// 你的formid
					dataType:"json",
					async: false,
					error: function(request) {
						alert("Connection error");
					},
					success: function(data) {
						var list = data.categoryEntities;
						console.log(list);
						var code = "<option value=''>请选择</option>";
						for (i = 0; i< list.length; i++) {
							code = code + "<option value='"+ list[i].id + "'>" + list[i].name+"</option>";
						}
						console.log(code);
						console.log($("#aaa"));
						$("#aaa").empty();
						$("#aaa").append(code);
						$("#s2id_aaa .select2-chosen").text("请选择");
					}
				});
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/faq/list/">常见问题列表</a></li>
		<li class="active"><a href="${ctx}/faq/form?faqId=${entity.faqId}">常见问题${not empty entity.faqId?'修改':'添加'}</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="entity" action="${ctx}/faq/saveOrUpdateFag" method="post" class="form-horizontal">
		<form:hidden path="faqId"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">一级分类:</label>
			<div class="controls">
				<form:select path="categoryEntity.parent.id" htmlEscape="false" class="input-medium required grandParentCategory">
					<form:option value="">请选择</form:option>
					<c:forEach items="${grandParent}" var="grandParent">
						<form:option value="${grandParent.id}">${grandParent.name}</form:option>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">二级分类:</label>
			<div class="controls">
				<form:select path="categoryEntity.id" id="aaa" htmlEscape="false" class="input-medium required">
					<form:option value="">请选择</form:option>
					<c:forEach items="${parent}" var="parent">
						<form:option value="${parent.id}">${parent.name}</form:option>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">问题标题:</label>
			<div class="controls">
				<form:input path="title" htmlEscape="false" maxlength="50" class="required" style="width:670px;"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">问题链接:</label>
			<div class="controls">
				<form:input path="href" htmlEscape="false" class="required" style="width:670px;"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="faq:faq:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>