package com.ejweb.modules.workbench.service;

import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.sys.utils.UserUtils;
import com.ejweb.modules.workbench.dao.ReportNoticeDao;
import com.ejweb.modules.workbench.dao.ReportNoticeMapper;
import com.ejweb.modules.workbench.entity.ReportNotice;
import com.ejweb.modules.workbench.entity.ReportNoticeEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by mengxy on 2017/9/15.
 */
@Service
public class NoticeService extends CrudService<ReportNoticeDao, ReportNoticeEntity>{

    @Autowired
    private ReportNoticeMapper noticeMapper;
    @Autowired
    private ReportNoticeDao reportNoticeDao;

    /**
     * 获取列表
     */
    public Page<ReportNotice> selectBySendToId(Page<ReportNotice> page, ReportNotice reportNotice, String sendToId) throws Exception{
        List<ReportNotice> noticeList = noticeMapper.selectBySendToId(sendToId);
        for(ReportNotice notice:noticeList){
            User user = UserUtils.get(notice.getSendFromId());
            notice.setSendFromId(user.getName());
        }
        page.setList(noticeList);
        page.setCount(noticeList.size());
        return page;
    }

    @Transactional(readOnly = false)
    public void updateByPrimaryKeySelective(ReportNotice record) throws Exception{
        record.setStatus("1");
        noticeMapper.updateByPrimaryKeySelective(record);
    }

    public int getMessageCount(String id) {
        return noticeMapper.getMessageCount(id);
    }
}
