/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.service;

import java.util.List;

import com.ejweb.modules.report.entity.CtBbtcRegion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.modules.report.entity.CtBbtcBusCategory;
import com.ejweb.modules.report.dao.CtBbtcBusCategoryDao;

/**
 * 业务类别Service
 * @author haoqm
 * @version 2019-07-12
 */
@Service
@Transactional(readOnly = true)
public class CtBbtcBusCategoryService extends CrudService<CtBbtcBusCategoryDao, CtBbtcBusCategory> {

	@Autowired
	private  CtBbtcBusCategoryDao  ctBbtcBusCategoryDao;

	public CtBbtcBusCategory get(String id) {
		return super.get(id);
	}
	
	public List<CtBbtcBusCategory> findList(CtBbtcBusCategory ctBbtcBusCategory) {
		return super.findList(ctBbtcBusCategory);
	}
	
	public Page<CtBbtcBusCategory> findPage(Page<CtBbtcBusCategory> page, CtBbtcBusCategory ctBbtcBusCategory) {
		return super.findPage(page, ctBbtcBusCategory);
	}
	
	@Transactional(readOnly = false)
	public void save(CtBbtcBusCategory ctBbtcBusCategory) {
		try{
			super.save(ctBbtcBusCategory);
		}catch (RuntimeException e){
			throw new RuntimeException(e.getMessage());
		}

	}
	
	@Transactional(readOnly = false)
	public void delete(CtBbtcBusCategory ctBbtcBusCategory) {
		super.delete(ctBbtcBusCategory);
	}

	public List<CtBbtcBusCategory> getByTpyeId(String typeId){
		return this.ctBbtcBusCategoryDao.getByTypeId(typeId);
	}
	
}