/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.entity;

import org.hibernate.validator.constraints.Length;

import com.ejweb.core.persistence.DataEntity;
import com.ejweb.modules.sys.entity.Dict;
/**
 * 业务类型Entity
 * @author haoqm
 * @version 2019-07-12
 */
public class CtBbtcBusType extends DataEntity<CtBbtcBusType> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 业务类型编码
	private String name;		// 业务类型名称
	private String group;		// 所属集团
	private String groupName;		// 所属集团名称
	private  String  area;    //区域

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public CtBbtcBusType() {
		super();
	}

	public CtBbtcBusType(String id){
		super(id);
	}

	@Length(min=0, max=64, message="业务类型编码长度必须介于 0 和 64 之间")
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@Length(min=0, max=64, message="业务类型名称长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=1000, message="所属集团长度必须介于 0 和 1000之间")
	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
}