package com.ejweb.core.push;

import java.net.URLEncoder;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class MessagePayload {

    private final JSONObject _data = new JSONObject();
    
    private To toPeople;// 默认通过设备号推送
    // 发送对象 ALL 发送给所有用户， BY_TOKEN 发送给指定TOKEN的用户，BY_ALIAS 发给也指定别名的用户，PRE_MESSAGE 预存数据，不发送
    public enum To{
        ALL,BY_TOKEN,BY_ALIAS,PRE_MESSAGE
    }
    public MessagePayload() {
        _data.put("appkey",   "");
        _data.put("topeople", 3);
        _data.put("token",    "");
        _data.put("production", 1);
        _data.put("devices",  new JSONArray());
        //数据信息部分
        _data.put("message",  new JSONObject());
        _data.getJSONObject("message").put("title", "");
        _data.getJSONObject("message").put("user_id", "");
        _data.getJSONObject("message").put("content", "");
        _data.getJSONObject("message").put("begin_time", 0L);
        _data.getJSONObject("message").put("expire_time", 0L);
        _data.getJSONObject("message").put("extras", new JSONObject());
    }
    public MessagePayload(String appkey, To toPeople, String secret) {
        
        _data.put("appkey",   appkey);
        switch (toPeople) {
            case ALL:
                _data.put("topeople", 0);
                break;
            case BY_TOKEN:
                _data.put("topeople", 1);
                break;
            case BY_ALIAS:
                _data.put("topeople", 2);
                break;
            default:
                _data.put("topeople", 3);
                break;
        }
        this.toPeople = toPeople;
        _data.put("token",    secret);
        _data.put("production", 1);
        _data.put("devices",  new JSONArray());
        //数据信息部分
        _data.put("message",  new JSONObject());
        _data.getJSONObject("message").put("title", "");
        _data.getJSONObject("message").put("user_id", "");
        _data.getJSONObject("message").put("content", "");
        _data.getJSONObject("message").put("begin_time", 0L);
        _data.getJSONObject("message").put("expire_time", 0L);
        _data.getJSONObject("message").put("extras", new JSONObject());
    }
    /**
     * 
     * @param appkey     APPKEY
     * @param toPeople   推送人群
     * @param secret      推送接口密码
     * @param production 是否线上
     */
    public MessagePayload(String appkey, To toPeople, String secret, boolean production) {
        
        _data.put("appkey",   appkey);
        switch (toPeople) {
            case ALL:
                _data.put("topeople", 0);
                break;
            case BY_TOKEN:
                _data.put("topeople", 1);
                break;
            case BY_ALIAS:
                _data.put("topeople", 2);
                break;
            default:
                _data.put("topeople", 3);
                break;
        }
        this.toPeople = toPeople;
        _data.put("token",    secret);
        if (production) {
            _data.put("production", 1);
        } else {
            _data.put("production", 0);
        }
        _data.put("devices",  new JSONArray());
        //数据信息部分
        _data.put("message",  new JSONObject());
        _data.getJSONObject("message").put("title", "");
        _data.getJSONObject("message").put("user_id", "");
        _data.getJSONObject("message").put("content", "");
        _data.getJSONObject("message").put("begin_time", 0L);
        _data.getJSONObject("message").put("expire_time", 0L);
        _data.getJSONObject("message").put("extras", new JSONObject());
    }
    /**
     * 默认根据用户TOKEN进行推送
     * 
     * @author renmb
     * @time  2016年8月15日
     * @return
     */
    public final static MessagePayload newPayload(){
        final MessagePayload payload = new MessagePayload();
        payload.setToPeople(MessagePayload.To.BY_TOKEN);
        return payload;
    }
    /**
     * 发送已经生成的信息
     * @param appkey
     * @param toPeople
     * @param token
     * @param mkey
     */
    public MessagePayload(String appkey, To toPeople, String secret, long mkey) {
        
        _data.put("mkey", mkey);
        _data.put("appkey",   appkey);
        switch (toPeople) {
            case ALL:
                _data.put("topeople", 0);
                break;
            case BY_TOKEN:
                _data.put("topeople", 1);
                break;
            case BY_ALIAS:
                _data.put("topeople", 2);
                break;
            default:
                _data.put("topeople", 3);
                break;
        }
        this.toPeople = toPeople;
        _data.put("token",    secret);
        _data.put("devices",  new JSONArray());
    }
    public MessagePayload setAppkey(String appkey) {
        
        _data.put("appkey",   appkey);
        return this;
    }
    public MessagePayload setPushToken(String secret) {
        
        _data.put("token",    secret);
        return this;
    }
    public MessagePayload setProduction(boolean production) {
        
        if (production) {
            _data.put("production", 1);
        } else {
            _data.put("production", 0);
        }
        return this;
    }
    public MessagePayload setToPeople(To toPeople) {
        
        switch (toPeople) {
            case ALL:
                _data.put("topeople", 0);
                break;
            case BY_TOKEN:
                _data.put("topeople", 1);
                break;
            case BY_ALIAS:
                _data.put("topeople", 2);
                break;
            default:
                _data.put("topeople", 3);
                break;
        }
        this.toPeople = toPeople;
        return this;
    }
    public To getToPeople() {
        
        return this.toPeople;
    }
    public MessagePayload addMessageTitle(String title) {
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return this;
        message.put("title", title);
        
        return this;
    }
    
    public MessagePayload addMessageContent(String content){
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return this;
        message.put("content", content);
        
        return this;
    }
    
    public MessagePayload addMessageBeginTime(long beginTime){
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return this;
        message.put("begin_time", beginTime);
        
        return this;
    }
    public MessagePayload addMessageExpireTime(long expireTime){
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return this;
        message.put("expire_time", expireTime);
        
        return this;
    }
    
    public MessagePayload addMessageExtra(String key, Object value){
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return this;
        message.getJSONObject("extras").put(key, value);
        
        return this;
    }
    
    public MessagePayload addDevices(String... devices){
        
        if(devices == null || devices.length == 0)
            return this;
        
        JSONArray d = _data.getJSONArray("devices");
        for(String device:devices){
            
            d.add(device);
        }
        return this;
    }
    public JSONObject getJSONMessage(String userId) {
        
        JSONObject message = _data.getJSONObject("message");
        if(message == null)
            return null;
        if(StringUtils.isBlank(userId)){
            
            message.put("user_id",  "");
        } else {
            
            message.put("user_id",  userId);
        }
        return message;
    }
    public byte[] getMessagePayload(){
        
        try {
            
            String c = "content="+URLEncoder.encode(_data.toJSONString(), "UTF-8");
            return c.getBytes("UTF-8");
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String toString() {
        // TODO Auto-generated method stub
        try {
            
            return JSON.toJSONString(_data);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
}
