/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.util.Arrays;

public class StringUtil {
    private static final char DY = '\'';
    private static final char DH = ',';
    private static int[] filter = new int[128];
    private static int[] filterEnd = new int[128];

    static {
        StringUtil.filter[60] = 0x3FFFFFFF;
        StringUtil.filterEnd[60] = 62;
        StringUtil.filter[38] = 10;
        StringUtil.filterEnd[38] = 59;
        StringUtil.filter[59] = -1;
        StringUtil.filter[10] = -1;
        StringUtil.filter[13] = -1;
        StringUtil.filter[9] = -1;
        StringUtil.filter[32] = 1;
        StringUtil.filter[42] = 1;
        StringUtil.filter[45] = 1;
        StringUtil.filter[46] = 1;
        StringUtil.filter[35] = 1;
    }

    public static String rmHtmlTag(String input) {
        if (StringUtil.isBlank(input)) {
            return "";
        }
        int length = input.length();
        int tl = 0;
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < length) {
            c = input.charAt(i);
            if (c > '\u007f') {
                sb.append(c);
            } else {
                switch (filter[c]) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        sb.append(c);
                        break;
                    }
                    case 1: {
                        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != c) {
                            sb.append(c);
                        }
                        while (++i < length && input.charAt(i) == c) {
                        }
                        if (i >= length && input.charAt(length - 1) == c) break;
                        --i;
                        break;
                    }
                    default: {
                        tl = filter[c] + i;
                        int tempOff = i++;
                        boolean flag = false;
                        char end = (char)filterEnd[c];
                        while (i < length && i < tl) {
                            c = input.charAt(i);
                            if (c <= '\u007f' && c == end) {
                                flag = true;
                                break;
                            }
                            ++i;
                        }
                        if (flag) break;
                        i = tempOff;
                        sb.append(input.charAt(i));
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static String makeSqlInString(String str) {
        String[] strs = str.split(",");
        StringBuilder sb = new StringBuilder();
        String field = null;
        int i = 0;
        while (i < strs.length) {
            field = strs[i].trim();
            if (StringUtil.isNotBlank(field)) {
                sb.append('\'');
                sb.append(field);
                sb.append('\'');
                if (i < strs.length - 1) {
                    sb.append(',');
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static char[] sortCharArray(String str) {
        char[] chars = str.toCharArray();
        Arrays.sort(chars);
        return chars;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.rmHtmlTag("c+++++++++"));
    }

    public static boolean isBlank(char[] chars) {
        int strLen;
        if (chars == null || (strLen = chars.length) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

