/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.modules.report.entity.CtBbtcRegion;
import com.ejweb.modules.report.dao.CtBbtcRegionDao;


/**
 * 区域基础资料Service
 * @author haoqm
 * @version 2019-07-12
 */
@Service
@Transactional(readOnly = true)
public class CtBbtcRegionService extends CrudService<CtBbtcRegionDao, CtBbtcRegion> {
	@Autowired
	private CtBbtcRegionDao ctBbtcRegionDao;


	public CtBbtcRegion get(String id) {
		return super.get(id);
	}
	
	public List<CtBbtcRegion> findList(CtBbtcRegion ctBbtcRegion) {
		return super.findList(ctBbtcRegion);
	}
	
	public Page<CtBbtcRegion> findPage(Page<CtBbtcRegion> page, CtBbtcRegion ctBbtcRegion) {
		return super.findPage(page, ctBbtcRegion);
	}
	public List<CtBbtcRegion> getByGroupId(String groupId){
		return this.ctBbtcRegionDao.getByGroupId(groupId);
	}

	@Transactional(readOnly = false)
	public void save(CtBbtcRegion ctBbtcRegion) {
		try{
			super.save(ctBbtcRegion);
		}catch (RuntimeException e){
			throw new RuntimeException(e.getMessage());
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(CtBbtcRegion ctBbtcRegion) {
		super.delete(ctBbtcRegion);
	}


	
}