package com.ejweb.modules.report.entity;


import com.ejweb.core.persistence.DataEntity;
import com.ejweb.core.utils.excel.annotation.ExcelField;
import com.ejweb.modules.sys.entity.User;

import java.util.Date;
import java.util.List;

/**
 * 举报Entity
 *
 * @author lixy
 * @version 2017-09-06
 */
public class ReportEntity extends DataEntity<ReportEntity> {
    private static final long serialVersionUID = 1L;

    private User user;//用户
    private String reportProject;   //被举报项目
    private String reportCity;    //所在城市
    private String reportTime;    //举报时间
    private String reportContent;    //举报内容
    private String reportPersonName;    //举报人姓名
    private String reportPersonTel;    //举报人电话
    private String reportPersonEmail;    //举报人邮箱
    private String reportSource;    //举报途径 web:官网 oa:融创OA系统 supplier:供应商系统 wechat:微信公众号 sunacE:融E offline:线下扫码 tel:电话 email:邮件 visit:来访
    private String reportStatus;   //举报状态 0 未处理 1 处理中 2 已处理 3已关闭
    private String supplementCompany;    //被举报公司
    private String supplementDepartment;    //被举报部门
    private String supplementInformant;    //被举报人
    private String supplementTitle;    //标题
    private String supplementType;    //业务类型地产 物业 酒店 商业
    private String transferGroup;   //移交部门所属集团
    private String transferArea;   //移交区域

    public String getTransferArea() {
        return transferArea;
    }

    public void setTransferArea(String transferArea) {
        this.transferArea = transferArea;
    }

    private String transferDepartment;//移交部门 1 营销 2 工程 3 成本 4 招采 5人力 6物业 7投诉
    private String supplementArea;    //被举报区域
    private String supplementProject;    //被举报项目
    private String supplementContent;    //
    private String dealPersonName;    //处理人
    private String dealResult;    //处理结论 1 投诉 2 举报无效 3 举报受理 4 举报属实
    private String exchangeBeforeUser;    //移交/转交前用户
    private String exchangeAfterUser;    //移交/转交后用户（只记录最新的移交用户，此处不记录历史）
    private String exchangeType;    //举报改变类型 1移交 2转交
    private String reportTimeFrom;    //举报时间起
    private String reportTimeTo;    //举报时间止
    private String reportAttachment;    //举报提交文件
    private String supplementAttachment;    //补充提交文件
    private String dealAttachment;    //处理成果文件
    private String oaname;//当前用户名
    private String reportIp;    //记录ip地址
    private String ipCity;    //ip地址对应城市
    private String isSendEmail;    //是否已经发送过邮件 0未发送 1已发送
    private String transferName;    //移交给
    private String dealPerson;
    private String lStatus; //关闭修改状态
    private String isAdmin; //是否管理员
    private String isFzAdmin; //是否輔助管理员
    private String isFzAdmin02; //是否輔助管理员2  反舞弊负责人岗

    public String getIsFzAdmin02() {
        return isFzAdmin02;
    }

    public void setIsFzAdmin02(String isFzAdmin02) {
        this.isFzAdmin02 = isFzAdmin02;
    }

    private String oaarea; //账号区域
    private String participants; //参与人
    private String insider; //知情人
    private String suggestion; //调查建议
    private String reportDate; //事件时间
    private String site; //发生地点
    private String qq; //qq
    private String weixin; //微信号
    private String ifClue; //联系人是否可见
    private String supplementGroup; //被举报集团
    private String supplementCategory; //业务类别
    private CtBbtcRegion supplementAreaNew; //被举报区域
    private CtBbtcBusType supplementTypeNew;//业务类型
    private Date  transTime;    //转为线索的时间
    private String  cuurentTime;    //转为线索的时间

    public String getCuurentTime() {
        return cuurentTime;
    }

    public void setCuurentTime(String cuurentTime) {
        this.cuurentTime = cuurentTime;
    }

    private  List  regionList;   //区域列表

    public List getRegionList() {
        return regionList;
    }

    public void setRegionList(List regionList) {
        this.regionList = regionList;
    }

    public Date getTransTime() {
        return transTime;
    }

    public void setTransTime(Date transTime) {
        this.transTime = transTime;
    }

    public String getTransferGroup() {
        return transferGroup;
    }

    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    public String getFlage() {
        return flage;
    }

    public void setFlage(String flage) {
        this.flage = flage;
    }

    private String flage; //頁簽

    public String getIfClue() {
        return ifClue;
    }

    public void setIfClue(String ifClue) {
        this.ifClue = ifClue;
    }


    public String getSelectExchangeAfterUser() {
        return selectExchangeAfterUser;
    }

    public void setSelectExchangeAfterUser(String selectExchangeAfterUser) {
        this.selectExchangeAfterUser = selectExchangeAfterUser;
    }

    private String selectExchangeAfterUser; //查询移交人

    public String getIsFzAdmin() {
        return isFzAdmin;
    }

    public void setIsFzAdmin(String isFzAdmin) {
        this.isFzAdmin = isFzAdmin;
    }

    public String getParticipants() {
        return participants;
    }

    public void setParticipants(String participants) {
        this.participants = participants;
    }

    public String getInsider() {
        return insider;
    }

    public void setInsider(String insider) {
        this.insider = insider;
    }

    public String getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getReportDate() {
        return reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getWeixin() {
        return weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }


    public String getOaarea() {
        return oaarea;
    }

    public void setOaarea(String oaarea) {
        this.oaarea = oaarea;
    }


    public String getIsAdmin() {
        return isAdmin;
    }

    public void setIsAdmin(String isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getlStatus() {
        return lStatus;
    }

    public void setlStatus(String lStatus) {
        this.lStatus = lStatus;
    }


    //    private String ifDone;            //是否完成
//
//
//    public String getIfDone() {
//        return ifDone;
//    }
//
//    public void setIfDone(String ifDone) {
//        this.ifDone = ifDone;
//    }
    private List<ReportAttachmentEntity> reportAttachmentEntityList;

    private String[] types;//新业务类型

    @ExcelField(title = "被举报项目/部门", align = 2, sort = 24)
    public String getReportProject() {
        return reportProject;
    }

    @ExcelField(title = "OA账号", align = 2, sort = 26)
    public String getOaname() {
        return oaname;
    }

    public void setOaname(String oaname) {
        this.oaname = oaname;
    }

    public void setReportProject(String reportProject) {
        this.reportProject = reportProject;
    }

    public String getReportCity() {
        return reportCity;
    }

    public void setReportCity(String reportCity) {
        this.reportCity = reportCity;
    }

    @ExcelField(title = "举报时间", align = 2, sort = 38)
    public String getReportTime() {
        return reportTime;
    }

    public void setReportTime(String reportTime) {
        this.reportTime = reportTime;
    }

    @ExcelField(title = "举报内容", align = 2, sort = 50)
    public String getReportContent() {
        return reportContent;
    }

    public void setReportContent(String reportContent) {
        this.reportContent = reportContent;
    }

    @ExcelField(title = "举报人", align = 2, sort = 28)
    public String getReportPersonName() {
        return reportPersonName;
    }

    public void setReportPersonName(String reportPersonName) {
        this.reportPersonName = reportPersonName;
    }

    @ExcelField(title = "举报人电话", align = 2, sort = 30)
    public String getReportPersonTel() {
        return reportPersonTel;
    }

    @ExcelField(title = "举报途径", align = 2, sort = 36)
    public String getReportSource() {
        return reportSource;
    }

    public void setReportSource(String reportSource) {
        this.reportSource = reportSource;
    }


    public void setReportPersonTel(String reportPersonTel) {
        this.reportPersonTel = reportPersonTel;
    }

    public String getReportPersonEmail() {
        return reportPersonEmail;
    }

    public void setReportPersonEmail(String reportPersonEmail) {
        this.reportPersonEmail = reportPersonEmail;
    }


    @ExcelField(title = "状态", align = 2, sort = 40)
    public String getReportStatus() {
        return reportStatus;
    }

    public void setReportStatus(String reportStatus) {
        this.reportStatus = reportStatus;
    }

    public String getSupplementCompany() {
        return supplementCompany;
    }

    public void setSupplementCompany(String supplementCompany) {
        this.supplementCompany = supplementCompany;
    }

    public String getSupplementDepartment() {
        return supplementDepartment;
    }

    public void setSupplementDepartment(String supplementDepartment) {
        this.supplementDepartment = supplementDepartment;
    }

    @ExcelField(title = "被举报人", align = 2, sort = 34)
    public String getSupplementInformant() {
        return supplementInformant;
    }

    public void setSupplementInformant(String supplementInformant) {
        this.supplementInformant = supplementInformant;
    }

    @ExcelField(title = "标题", align = 2, sort = 19)
    public String getSupplementTitle() {
        return supplementTitle;
    }

    public void setSupplementTitle(String supplementTitle) {
        this.supplementTitle = supplementTitle;
    }

    @ExcelField(title = "业务类型", align = 2, sort = 22)
    public String getSupplementType() {
        return supplementType;
    }

    public void setSupplementType(String supplementType) {
        this.supplementType = supplementType;
    }

    @ExcelField(title = "区域", align = 2, sort = 21)
    public String getSupplementArea() {
        return supplementArea;
    }

    public void setSupplementArea(String supplementArea) {
        this.supplementArea = supplementArea;
    }

    public String getSupplementProject() {
        return supplementProject;
    }

    public void setSupplementProject(String supplementProject) {
        this.supplementProject = supplementProject;
    }

    @ExcelField(title = "举报信息补充内容", align = 2, sort = 52)
    public String getSupplementContent() {
        return supplementContent;
    }

    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    @ExcelField(title = "处理结论", align = 2, sort = 42)
    public String getDealResult() {
        return dealResult;
    }

    public void setDealResult(String dealResult) {
        this.dealResult = dealResult;
    }

    @ExcelField(title = "移交部门", align = 2, sort = 44)
    public String getTransferDepartment() {
        return transferDepartment;
    }

    @ExcelField(title = "处理人", align = 2, sort = 46)
    public String getDealPersonName() {
        return dealPersonName;
    }

    public void setDealPersonName(String dealPersonName) {
        this.dealPersonName = dealPersonName;
    }


    public String getExchangeAfterUser() {
        return exchangeAfterUser;
    }

    public void setExchangeAfterUser(String exchangeAfterUser) {
        this.exchangeAfterUser = exchangeAfterUser;
    }

    public void setTransferDepartment(String transferDepartment) {
        this.transferDepartment = transferDepartment;
    }

    public String getExchangeBeforeUser() {
        return exchangeBeforeUser;
    }

    public void setExchangeBeforeUser(String exchangeBeforeUser) {
        this.exchangeBeforeUser = exchangeBeforeUser;
    }

    public String getExchangeType() {
        return exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getReportTimeFrom() {
        return reportTimeFrom;
    }

    public void setReportTimeFrom(String reportTimeFrom) {
        this.reportTimeFrom = reportTimeFrom;
    }

    public String getReportTimeTo() {
        return reportTimeTo;
    }

    public void setReportTimeTo(String reportTimeTo) {
        this.reportTimeTo = reportTimeTo;
    }

    public List<ReportAttachmentEntity> getReportAttachmentEntityList() {
        return reportAttachmentEntityList;
    }

    public void setReportAttachmentEntityList(List<ReportAttachmentEntity> reportAttachmentEntityList) {
        this.reportAttachmentEntityList = reportAttachmentEntityList;
    }

    public String getReportAttachment() {
        return reportAttachment;
    }

    public void setReportAttachment(String reportAttachment) {
        this.reportAttachment = reportAttachment;
    }

    public String getSupplementAttachment() {
        return supplementAttachment;
    }

    public void setSupplementAttachment(String supplementAttachment) {
        this.supplementAttachment = supplementAttachment;
    }

    public String getDealAttachment() {
        return dealAttachment;
    }

    public void setDealAttachment(String dealAttachment) {
        this.dealAttachment = dealAttachment;
    }

    public String[] getTypes() {
        return types;
    }

    public void setTypes(String[] types) {
        this.types = types;
    }

    @ExcelField(title = "移交给", align = 2, sort = 48)
    public String getTransferName() {
        return transferName;
    }

    public void setTransferName(String transferName) {
        this.transferName = transferName;
    }

    @ExcelField(title = "IP来源", align = 2, sort = 54)
    public String getReportIp() {
        return reportIp;
    }

    public void setReportIp(String reportIp) {
        this.reportIp = reportIp;
    }

    @ExcelField(title = "IP所属城市", align = 2, sort = 56)
    public String getIpCity() {
        return ipCity;
    }

    public void setIpCity(String ipCity) {
        this.ipCity = ipCity;
    }

    public String getIsSendEmail() {
        return isSendEmail;
    }

    public void setIsSendEmail(String isSendEmail) {
        this.isSendEmail = isSendEmail;
    }

    public String getDealPerson() {
        return dealPerson;
    }

    public void setDealPerson(String dealPerson) {
        this.dealPerson = dealPerson;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @ExcelField(title = "所属集团", align = 2, sort = 20)
    public String getSupplementGroup() {
        return supplementGroup;
    }

    public void setSupplementGroup(String supplementGroup) {
        this.supplementGroup = supplementGroup;
    }

    @ExcelField(title = "业务类别", align = 2, sort = 23)
    public String getSupplementCategory() {
        return supplementCategory;
    }

    public void setSupplementCategory(String supplementCategory) {
        this.supplementCategory = supplementCategory;
    }
    public CtBbtcRegion getSupplementAreaNew() {
        return supplementAreaNew;
    }

    public void setSupplementAreaNew(CtBbtcRegion supplementAreaNew) {
        this.supplementAreaNew = supplementAreaNew;
    }
    public CtBbtcBusType getSupplementTypeNew() {
        return supplementTypeNew;
    }

    public void setSupplementTypeNew(CtBbtcBusType supplementTypeNew) {
        this.supplementTypeNew = supplementTypeNew;
    }
}
