package com.ejweb.modules.front.report.api;

import com.ejweb.conf.ErrorCode;
import com.ejweb.core.api.ResponseBean;
import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.front.report.bean.FrontReportBean;
import com.ejweb.modules.front.report.entity.Captcha;
import com.ejweb.modules.front.report.service.FrontReportService;
import com.ejweb.modules.front.report.utils.CaptchaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by zhangzn on 2017/9/7.
 */

@RestController
@RequestMapping("/api/front/report")
public class FrontReportController {

     @Autowired
     private FrontReportService frontReportService;


     /**
      * 获取验证码的code值
     * @return
     */
    @RequestMapping("captchaCode")
    public ResponseBean captchaCode() {
        ResponseBean response = new ResponseBean();
        Captcha captcha = new Captcha();
        captcha.setCode(CaptchaUtil.getCaptchaCode());
        response.setData(captcha);
        return response;
    }

    /**
     * 举报
     * @param bean
     * @return
     */
    @RequestMapping("addReport")
    public ResponseBean addReport(FrontReportBean bean,String token,HttpServletRequest request){
        ResponseBean responseBean = new ResponseBean();
        if(bean!=null){
            if(!CaptchaUtil.validate(bean.getCaptcha(),bean.getCode())){
                    responseBean.setStatus(ErrorCode.CAPTCHA_ERROR);
                    responseBean.setMessage("captcha is incorrect");
                    return responseBean;
            }
            if (StringUtils.isBlank(bean.getReportSource())){
                responseBean.setStatus(ErrorCode.STATUS_CODE_4002);
                responseBean.setMessage("report_source为空");
                return responseBean;
            }else {
                return frontReportService.addReport(bean,token,request);
            }
        }
        responseBean.setStatus(ErrorCode.STATUS_CODE_4001);
        responseBean.setMessage("接收参数失败");
        return responseBean;
    }
}
