/**
 *
 */
package com.ejweb.core.security;

import java.util.Enumeration;
import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

import com.ejweb.conf.GConstants;

/**
 * 配置文件加密解密
 *
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年11月2日
 */
public class SecurityPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {
//    private static final String key = "";

    private static final String  CONF_DESC_KEY      = GConstants.getValue("cong.desc.key", "2012PinganVitality075522628888ForShenZhenBelter075561869839");
    
    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props)
            throws BeansException {
        // TODO Auto-generated method stub
        try {
            Enumeration<?> enu = props.propertyNames();  
            while (enu.hasMoreElements()) {
                try {
                    String key = (String) enu.nextElement();
                    String val = (String) props.get(key);
                    String decorded = DES3Utils.decrypt(val, CONF_DESC_KEY);
                    if(decorded != null){
                        props.put(key, decorded);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.processProperties(beanFactory, props);
    }
}
