<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务类别管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/report/ctBbtcBusCategory/">业务类别列表</a></li>
		<shiro:hasPermission name="report:ctBbtcBusCategory:edit"><li><a href="${ctx}/report/ctBbtcBusCategory/form">业务类别添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="ctBbtcBusCategory" action="${ctx}/report/ctBbtcBusCategory/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label style="width: auto;">业务类别名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>业务类别编码</th>
				<th>业务类别名称</th>
				<th>所属集团</th>
				<th>所属区域</th>
				<th>所属业务类型</th>
				<shiro:hasPermission name="report:ctBbtcBusCategory:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ctBbtcBusCategory">
			<tr>
				<td><a href="${ctx}/report/ctBbtcBusCategory/form?id=${ctBbtcBusCategory.id}">
					${ctBbtcBusCategory.number}
				</a></td>
				<td>
					${ctBbtcBusCategory.name}
				</td>
				<td align="center">
						${ctBbtcBusCategory.ctBbtcGroup}
				<%--	<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq '3437402691677202102'}">集团本部</c:if>
					<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq '3510129313047280678'}">区域集团</c:if>
					<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq '3565898923067676254'}">服务集团</c:if>
					<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq '3806696792996264972'}">文化集团</c:if>
					<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq '3770618512934949260'}">文旅集团</c:if>--%>
					<c:if test="${ctBbtcBusCategory.ctBbtcGroup eq null}">--</c:if>
				</td>
				<td>
						${ctBbtcBusCategory.supplementArea}
				</td>
				<td>
					${ctBbtcBusCategory.typeName}
				</td>
				<shiro:hasPermission name="report:ctBbtcBusCategory:edit"><td>
    				<a href="${ctx}/report/ctBbtcBusCategory/form?id=${ctBbtcBusCategory.id}">修改</a>
					<a href="${ctx}/report/ctBbtcBusCategory/delete?id=${ctBbtcBusCategory.id}" onclick="return confirmx('确认要删除该业务类别吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>