<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务类别管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			getRegion();

			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});


		function getRegion(){
			var selectNode = $("#supplementArea");
			selectNode.empty();//每次需要将上一次的数据进行清空
			selectNode.append("<option value=''>请选择</option>");

			var  ts_describe=  $("#ctBbtcGroup").val();
			if(ts_describe != null && ts_describe != ''){
				$.ajax({
					type: "POST",
					url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
					dataType: "json",
					success: function(returnedData) {
						var data2 = returnedData.ctBbtcRegionList;

						if (data2 != '') {
							var slsb=document.getElementById("supplementArea");
							for (var i = 0;i < data2.length;i++){
									slsb.append(new Option(data2[i].name,data2[i].id));
							}
						}
					},error:function(data){
						alert("系统错误");
					}
				});
			}else{
				/*top.$.jBox.tip('请选择所属集团', 'warning');*/
			}

		}

		function getType(){
			var selectNode = $("#supplementType");
			selectNode.empty();//每次需要将上一次的数据进行清空
			selectNode.append("<option value=''>请选择</option>");

			var  ts_describe1=  $("#ctBbtcGroup").val();
			var  ts_describe2=  $("#supplementArea").val();
			if(ts_describe1 != null && ts_describe1 != '' && ts_describe2 != null && ts_describe2 != '' ){
				$.ajax({
					type: "POST",
					url: "${ctx}/report/ctBbtcBusType/getTypeList?groupId="+ts_describe1+"&area="+ts_describe2,
					dataType: "json",
					success: function(returnedData) {
						var data2 = returnedData.ctBbtcTypeList;

						if (data2 != '') {
							var slsb=document.getElementById("supplementType");
							for (var i = 0;i < data2.length;i++){
								slsb.append(new Option(data2[i].typeName,data2[i].parentId));
							}
						}
					},error:function(data){
						alert("系统错误");
					}
				});
			}else{
				/*top.$.jBox.tip('请选择所属集团', 'warning');*/
			}

		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/report/ctBbtcBusCategory/">业务类别列表</a></li>
		<li class="active"><a href="${ctx}/report/ctBbtcBusCategory/form?id=${ctBbtcBusCategory.id}">业务类别<shiro:hasPermission name="report:ctBbtcBusCategory:edit">${not empty ctBbtcBusCategory.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="report:ctBbtcBusCategory:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="ctBbtcBusCategory" action="${ctx}/report/ctBbtcBusCategory/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">业务类别编码：</label>
			<div class="controls">
				<form:input path="number" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">业务类别名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属集团：</label>
			<div class="controls">
				<form:select onchange="getRegion()" path="ctBbtcGroup" class="input-xlarge required"  id="ctBbtcGroup" cssStyle="width: 285px">
					<form:option value="">请选择</form:option>
					<form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
								  htmlEscape="false"/>
				</form:select>
					<%--<form:input path="type" htmlEscape="false" maxlength="64" class="input-xlarge "/>--%>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">所属区域:</label>
			<div class="controls">
				<form:select id="supplementArea" path="supplementArea" class="input-small required" onchange="getType();"   cssStyle="width: 285px">
					<form:option value="">请选择</form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属业务类型:</label>
			<div class="controls">
				<form:select onchange="resetPageNo();" path="type.id" class="input-xlarge required" id="supplementType" cssStyle="width: 285px" >
					<%--<form:option value="">请选择</form:option>--%>
				</form:select>
				<%--<form:input path="type" htmlEscape="false" maxlength="64" class="input-xlarge "/>--%>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="report:ctBbtcBusCategory:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>