/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.service;

import java.util.List;
import java.util.UUID;

import com.ejweb.modules.report.dao.CtBbtcRegionDao;
import com.ejweb.modules.report.dao.CtBbtcTypeAreaDao;
import com.ejweb.modules.report.entity.CtBbtcRegion;
import com.ejweb.modules.report.entity.CtBbtcTypeArea;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.dao.CtBbtcBusTypeDao;


/**
 * 业务类型Service
 * @author haoqm
 * @version 2019-07-12
 */
@Service
@Transactional(readOnly = true)
public class CtBbtcBusTypeService extends CrudService<CtBbtcBusTypeDao, CtBbtcBusType> {

	@Autowired
	private CtBbtcBusTypeDao ctBbtcBusTypeDao;

	@Autowired
	private CtBbtcTypeAreaDao ctBbtcTypeAreaDao;

	public CtBbtcBusType get(String id) {
		return super.get(id);
	}
	
	public List<CtBbtcBusType> findList(CtBbtcBusType ctBbtcBusType) {
		return super.findList(ctBbtcBusType);
	}
	
	public Page<CtBbtcBusType> findPage(Page<CtBbtcBusType> page, CtBbtcBusType ctBbtcBusType) {
		return super.findPage(page, ctBbtcBusType);
	}
	
	@Transactional(readOnly = false)
	public void save(CtBbtcBusType ctBbtcBusType) {
		super.save(ctBbtcBusType);

		/*将可用范围存到  typearea表中*/

		System.out.println(ctBbtcBusType.getGroup()+"==========================");
		System.out.println(ctBbtcBusType.getArea()+"=========================");

		String[] groups = ctBbtcBusType.getGroup().split(",");
		String[] areas = ctBbtcBusType.getArea().split(",");
		int i=0;
		for (String typeArea:groups) {
			CtBbtcTypeArea ctBbtcTypeArea =new CtBbtcTypeArea();
			ctBbtcTypeArea.setId(UUID.randomUUID().toString());
			ctBbtcTypeArea.setGroup(typeArea);
			ctBbtcTypeArea.setArea(areas[i]);
			ctBbtcTypeArea.setParentId(ctBbtcBusType.getId());
			ctBbtcTypeAreaDao.insert(ctBbtcTypeArea);
			i++;
		}

	}

	public List<CtBbtcTypeArea> getByArea(String groupId,String areaId){
		CtBbtcTypeArea area=new CtBbtcTypeArea();
		area.setGroup(groupId);
		area.setArea(areaId);
		return this.ctBbtcTypeAreaDao.getByAreaId(area);
	}
	
	@Transactional(readOnly = false)
	public void delete(CtBbtcBusType ctBbtcBusType) {
		super.delete(ctBbtcBusType);
	}

}