package com.ejweb.modules.front.sso.api;

import com.ejweb.conf.ErrorCode;
import com.ejweb.conf.GConstants;
import com.ejweb.core.api.ResponseBean;
import com.ejweb.core.base.BaseController;
import com.ejweb.modules.front.sso.service.SsoService;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangzn on 2017/09/13.
 */

@RestController
@RequestMapping("/api/front/sso")
public class SsoController extends BaseController {

    @Autowired
    private SsoService ssoService;

    @RequestMapping(value = "/checkSso")
    public ResponseBean checkSso(String token) {
        ResponseBean response = new ResponseBean();
        try {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            Resource resource = resourceLoader.getResource("LtpaToken.properties");
            String filePath = resource.getURL().getPath();
            String returnToken = token;
            LtpaTokenManager.loadConfig(URLDecoder.decode(URLDecoder.decode(filePath)));
            logger.debug(".................原始token：\t\t" + token);
            token = URLDecoder.decode(token);
            logger.debug(".................解码一次token：\t\t" + token);
            token = URLDecoder.decode(token);
            logger.debug(".................解码两次token：\t\t" + token);
//            token = URLDecoder.decode(token);
            String username = "";
            boolean result = LtpaTokenManager.isValid(token);
            if (result) {//验证Token是否合法有效
                logger.debug(".................合法token：\t\t" + token);
                LtpaToken ltpaToken = new LtpaToken(token);
                username = ltpaToken.getUsername();
                response.setStatus(ErrorCode.STATUS_CODE_2000);
                response.setMessage("解析用户名正常");
            }else {
                response.setStatus(ErrorCode.STATUS_CODE_4105);
                response.setMessage("token已过期");
            }
            Map<String,String> map = new HashMap<String,String>();
            if (ssoService.checkSso(username) == 1) {
                map.put("token",returnToken);
                map.put("result",GConstants.YES);
                response.setData(map);
            } else {
                map.put("token",returnToken);
                map.put("result",GConstants.NO);
                response.setData(map);
            }
        } catch (Exception e) {
            logger.error("解析用户名出错：\n" + e.getMessage());
            response.setStatus(ErrorCode.STATUS_CODE_4001);
            response.setMessage("解析用户名出错");
            response.setData(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value = "/test")
    public ResponseBean test(String username) {
        ResponseBean response = new ResponseBean();
        try {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            Resource resource = resourceLoader.getResource("LtpaToken.properties");
            String filePath = resource.getURL().getPath();

            LtpaTokenManager.loadConfig(URLDecoder.decode(URLDecoder.decode(filePath)));
            response.setStatus(ErrorCode.STATUS_CODE_2000);
            response.setMessage("ok");
            response.setData(LtpaTokenManager.generate(username, URLDecoder.decode(URLDecoder.decode(filePath))));
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        return response;
    }
}
