<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>

<html>
<head>
    <title>举报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        window.onload = function () {
            var ifClue = "${report.ifClue}";
            if (ifClue == '1') {
                $("#ifClue").prop("checked", true);

            } else {
                $("#ifClue").prop("checked", false);

            }


            var dealResult = $("#dealResult").val();
            if (dealResult != null && dealResult != ' ') {
                if (dealResult == "6") {
                    $("#selectType").show();
                    $("#transferGroup").show();
                } else {
                    $("#selectType").hide();
                    $("#transferGroup").hide();
                }
                $("#selectDone").show();
            } else {
                $("#selectDone").hide();
            }
        }
        var submitCount = 0;

        $(document).ready(function () {
//            ctBbtcRegionList = [];
            $("#inputForm").validate({
                submitHandler: function (form) {
                    messages: {
                        supplementContent: {
                            maxlength: "最多输入{0}个字符"
                        }
                    }
                    if ($("#supplementType").val() == " ") {
                        top.$.jBox.tip('请选择业务类型', 'warning');
                    } else if ($("#supplementGroup").val() == " ") {
                        top.$.jBox.tip('请选择被举报集团', 'warning');
                    }else if ($("#supplementArea").val() == " ") {
                        top.$.jBox.tip('请选择被举报区域', 'warning');
                    }else if ($("#supplementCategory").val() == " ") {
                        top.$.jBox.tip('请选择业务类别', 'warning');
                    } else {
                        submitCount += 1;
                        if (submitCount == 1) {
                            loading('正在提交，请稍等...');
                            form.submit();
                        } else {
                            return false;
                        }
                    }
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            //弹出隐藏层
            $("#chooseUser").click(function () {
                $("#chooseDiv").show();
                $("#fade").show();
                $("#fade").style.width = document.body.scrollWidth;
                $("#fade").height($(document).height());
            });
            //关闭隐藏层
            $("#btnClose").click(function () {
                $("#chooseDiv").hide();
                $("#fade").hide();
            });
            //选中用户并关闭
            $("#btnConfirm").click(function () {
                $("#chooseUser").val($("input:radio:checked").parent().next().next().next().html());
                $("#userId").val($("input:radio:checked").val());
                $("#chooseDiv").hide();
                $("#fade").hide();
            });
            var checkedNumber = "${report.supplementType}";
            if (checkedNumber != null && checkedNumber.length != 0) {
                var number = checkedNumber.split(",");
                var ck = document.getElementsByName("supplementType");
                for (var i = 0; i < number.length; i++) {
                    ck[number[i] - 1].checked = true;
                }
            }
            <%--//管理员权限可选择处理结论--%>
            <%--var isAdmin = ${isAdmin};--%>
            <%--if (isAdmin == false) {--%>
            <%--$("#dealResult").attr("disabled", true);--%>
            <%--}--%>
            <%--var source = "${report.reportSource}";--%>
            <%--$(":radio[name='reportSource'][value='" + source + "']").prop("checked", "checked");--%>
            var supplementType = $("#supplementType").find("option:selected").text();
            var supplementInformant = "${report.supplementInformant}";
            if (supplementType == "请选择") {
                supplementType = "${report.reportProject}";
            }
            //判断是否显示是否完成选择框
            var dealResult = $("#dealResult").val();
            if (dealResult != null && dealResult != ' ') {
                $("#selectDone").show();
            }
        });

        /**
         * 获取浏览器类型以及版本号
         * 支持国产浏览器:猎豹浏览器、搜狗浏览器、傲游浏览器、360极速浏览器、360安全浏览器、
         * QQ浏览器、百度浏览器等.
         * 支持国外浏览器:IE,Firefox,Chrome,safari,Opera等.
         * 使用方法:
         * 获取浏览器版本:Browser.client.version
         * 获取浏览器名称(外壳):Browser.client.name
         * @author:xuzengqiang
         * @since :2015-1-27 10:26:11
         **/
        var Browser = Browser || (function (window) {
            var document = window.document,
                navigator = window.navigator,
                agent = navigator.userAgent.toLowerCase(),
                //IE8+支持.返回浏览器渲染当前文档所用的模式
                //IE6,IE7:undefined.IE8:8(兼容模式返回7).IE9:9(兼容模式返回7||8)
                //IE10:10(兼容模式7||8||9)
                IEMode = document.documentMode,
                //chorme
                chrome = window.chrome || false,
                System = {
                    //user-agent
                    agent: agent,
                    //是否为IE
                    isIE: /msie/.test(agent),
                    //Gecko内核
                    isGecko: agent.indexOf("gecko") > 0 && agent.indexOf("like gecko") < 0,
                    //webkit内核
                    isWebkit: agent.indexOf("webkit") > 0,
                    //是否为标准模式
                    isStrict: document.compatMode === "CSS1Compat",
                    //是否支持subtitle
                    supportSubTitle: function () {
                        return "track" in document.createElement("track");
                    },
                    //是否支持scoped
                    supportScope: function () {
                        return "scoped" in document.createElement("style");
                    },
                    //获取IE的版本号
                    ieVersion: function () {
                        try {
                            return agent.match(/msie ([\d.]+)/)[1] || 0;
                        } catch (e) {
                            console.log("error");
                            return IEMode;
                        }
                    },
                    //Opera版本号
                    operaVersion: function () {
                        try {
                            if (window.opera) {
                                return agent.match(/opera.([\d.]+)/)[1];
                            } else if (agent.indexOf("opr") > 0) {
                                return agent.match(/opr\/([\d.]+)/)[1];
                            }
                        } catch (e) {
                            console.log("error");
                            return 0;
                        }
                    },
                    //描述:version过滤.如31.0.252.152 只保留31.0
                    versionFilter: function () {
                        if (arguments.length === 1 && typeof arguments[0] === "string") {
                            var version = arguments[0];
                            start = version.indexOf(".");
                            if (start > 0) {
                                end = version.indexOf(".", start + 1);
                                if (end !== -1) {
                                    return version.substr(0, end);
                                }
                            }
                            return version;
                        } else if (arguments.length === 1) {
                            return arguments[0];
                        }
                        return 0;
                    }
                };

            try {
                //浏览器类型(IE、Opera、Chrome、Safari、Firefox)
                System.type = System.isIE ? "IE" :
                    window.opera || (agent.indexOf("opr") > 0) ? "Opera" :
                        (agent.indexOf("chrome") > 0) ? "Chrome" :
                            //safari也提供了专门的判定方式
                            window.openDatabase ? "Safari" :
                                (agent.indexOf("firefox") > 0) ? "Firefox" :
                                    'unknow';

                //版本号
                System.version = (System.type === "IE") ? System.ieVersion() :
                    (System.type === "Firefox") ? agent.match(/firefox\/([\d.]+)/)[1] :
                        (System.type === "Chrome") ? agent.match(/chrome\/([\d.]+)/)[1] :
                            (System.type === "Opera") ? System.operaVersion() :
                                (System.type === "Safari") ? agent.match(/version\/([\d.]+)/)[1] :
                                    "0";

                //浏览器外壳
                System.shell = function () {
                    //遨游浏览器
                    if (agent.indexOf("maxthon") > 0) {
                        System.version = agent.match(/maxthon\/([\d.]+)/)[1] || System.version;
                        return "傲游浏览器";
                    }
                    //QQ浏览器
                    if (agent.indexOf("qqbrowser") > 0) {
                        System.version = agent.match(/qqbrowser\/([\d.]+)/)[1] || System.version;
                        return "QQ浏览器";
                    }

                    //搜狗浏览器
                    if (agent.indexOf("se 2.x") > 0) {
                        return '搜狗浏览器';
                    }

                    //Chrome:也可以使用window.chrome && window.chrome.webstore判断
                    if (chrome && System.type !== "Opera") {
                        var external = window.external,
                            clientInfo = window.clientInformation,
                            //客户端语言:zh-cn,zh.360下面会返回undefined
                            clientLanguage = clientInfo.languages;

                        //猎豹浏览器:或者agent.indexOf("lbbrowser")>0
                        if (external && 'LiebaoGetVersion' in external) {
                            return '猎豹浏览器';
                        }
                        //百度浏览器
                        if (agent.indexOf("bidubrowser") > 0) {
                            System.version = agent.match(/bidubrowser\/([\d.]+)/)[1] ||
                                agent.match(/chrome\/([\d.]+)/)[1];
                            return "百度浏览器";
                        }
                        //360极速浏览器和360安全浏览器
                        if (System.supportSubTitle() && typeof clientLanguage === "undefined") {
                            //object.key()返回一个数组.包含可枚举属性和方法名称
                            var storeKeyLen = Object.keys(chrome.webstore).length,
                                v8Locale = "v8Locale" in window;
                            return storeKeyLen > 1 ? '360极速浏览器' : '360安全浏览器';
                        }
                        return "Chrome";
                    }
                    return System.type;
                };

                //浏览器名称(如果是壳浏览器,则返回壳名称)
                System.name = System.shell();
                //对版本号进行过滤过处理
                System.version = System.versionFilter(System.version);

            } catch (e) {
                console.log("error");
            }
            return {
                client: System
            };

        })(window);
        var userBrowser = Browser.client.name;
        console.log(userBrowser);

        function recordEmail() {
            //记录已发送邮件
            var reportId = $("#reportId").val();
            $.ajax({
                url: "${ctx}/report/recordEmail?reportId=" + reportId,
                dataType: "text",
                success: function (result) { //登录成功后返回的数据
                    console.log(result);
                }
            });
            send();
        }

        //发邮件
        function send() {
            var supplementType = $("#supplementType").find("option:selected").text();
            var supplementInformant = "${report.supplementInformant}";
            if (supplementType == "请选择") {
                supplementType = "${report.reportProject}";
            }
            var supplementContent = "";
            var path1 = "mailto:?subject=举报核查-" + supplementType + "-" + supplementInformant + "违规操作";

            path1 += "&body=Dear,%0D%0A附件是举报核查-" + supplementType + "-" + supplementInformant + "违规操作，请核实是否属实。%0D%0A谢谢！";
            path1 += "%0D%0A%0D%0A举报内容%0D%0A";
            path1 += "被举报项目/部门:${report.reportProject}%0D%0A";
            path1 += "标题:${report.supplementTitle}%0D%0A";
            path1 += "被举报人:${report.supplementInformant}%0D%0A";
            path1 += "举报时间:${report.reportTime}%0D%0A";
            path1 += "所在城市:${report.reportCity}%0D%0A";
            path1 += "IP来源:${report.reportIp}%0D%0A";
            path1 += "IP所属城市:${report.ipCity}%0D%0A";
            var isSendEmail = "${report.isSendEmail}";
            if (isSendEmail == '1') {
                isSendEmail = "是";
            } else {
                isSendEmail = "否";
            }
            path1 += "是否已发送邮件:" + isSendEmail + "%0D%0A";
            var reportContent = $("#reportContent").val();
            path1 += "内容:";
            var path2 = "%0D%0A附件:%0D%0A";
            $("#attachment1").find("[class='attachmentClass']").each(function () {
                var url = $(this).text();
                path2 += url;
            });
            path2 += "%0D%0A举报人信息%0D%0A";
            path2 += "姓名:${report.reportPersonName}%0D%0A";
            path2 += "手机号:${report.reportPersonTel}%0D%0A";
            path2 += "Email:${report.reportPersonEmail}%0D%0A";
            var reportSource = "${report.reportSource}";
            if (reportSource == "web") {
                reportSource = "官网";
            } else if (reportSource == "oa") {
                reportSource = "融创OA系统";
            } else if (reportSource == "supplier") {
                reportSource = "供应商系统";
            } else if (reportSource == "wechat") {
                reportSource = "微信公众号";
            } else if (reportSource == "sunacE") {
                reportSource = "融E";
            } else if (reportSource == "offline") {
                reportSource = "线下扫码";
            } else if (reportSource == "tel") {
                reportSource = "电话";
            } else if (reportSource == "email") {
                reportSource = "邮件";
            } else if (reportSource == "visit") {
                reportSource = "来访";
            }
            path2 += "举报途径:" + reportSource + "%0D%0A";
            var reportStatus = "${report.reportStatus}";
            if (reportStatus != "0") {
                path2 += "举报信息补充%0D%0A";

                var supplementTypeStr = "${report.supplementType}";
                path2 += "业务类型:" + supplementTypeStr + "%0D%0A";


               var supplementArea = "${report.supplementArea}";
              /*  if (supplementArea == "North China") {
                    supplementArea = "华北区域公司";
                } else if (supplementArea == "BeiJing") {
                    supplementArea = "北京区域公司";
                } else if (supplementArea == "ShangHai") {
                    supplementArea = "上海区域公司";
                } else if (supplementArea == "SouthWest") {
                    supplementArea = "西南区域公司";
                } else if (supplementArea == "SouthEast") {
                    supplementArea = "东南区域公司";
                } else if (supplementArea == "Central China") {
                    supplementArea = "华中区域公司";
                } else if (supplementArea == "GuangShen") {
                    supplementArea = "广深区域公司";
                } else if (supplementArea == "Hainan") {
                    supplementArea = "海南区域公司";
                } else if (supplementArea == "Group") {
                    supplementArea = "集团本部";
                } else if (supplementArea == "PropertyGroup") {
                    supplementArea = "物业集团";
                }*/
                path2 += "被举报区域:" + supplementArea + "%0D%0A";

                supplementContent = $("#supplementContent").val();
                path2 += "内容:";
                var path3 = "%0D%0A附件:%0D%0A";
                $("#attachment2").find("[class='attachmentClass']").each(function () {
                    var url = $(this).text();
                    path3 += url;

                });
            }
            if (path3 == null) {
                path3 = "";
            }
            var path = path1 + reportContent + path2 + supplementContent + path3;
            console.log(path);
            var pathLength = "";
            if (userBrowser == "Chrome" || userBrowser == "QQ浏览器"
                || userBrowser == "猎豹浏览器" || userBrowser == "搜狗浏览器"
                || userBrowser == "Opera") {
                pathLength = path.replace(/[^\x00-\xff]/g, "*********").length;
                if (pathLength > 2000) {
                    path = path1 + path2 + path3;
                    pathLength = path.replace(/[^\x00-\xff]/g, "*********").length;
                    alert("填写信息过长,请手动补充缺少的举报内容。推荐使用IE浏览器");
                    if (pathLength > 1000) {
                        path = path1 + path2;
                    }
                }
            } else if (userBrowser == "IE") {
                pathLength = path.replace(/[^\x00-\xff]/g, "*").length;
                if (pathLength > 1000) {
                    path = path1 + reportContent + path2 + path3;
                    pathLength = path.replace(/[^\x00-\xff]/g, "*").length;
                    alert("填写信息过长,请手动补充缺少的举报内容");
                    if (pathLength > 1000) {
                        path = path1 + path2 + path3;
                    }
                }
            }
//            }else if (userBrowser == "Opera"){
//                pathLength = path.replace(/[^\x00-\xff]/g, "*********").length
////                if (pathLength > 1000){
////                    alert("内容过长,请补充缺少内容");
////                    path = path1+path2+path3;
////                }
//            }
            console.log(path);
            console.log(pathLength);
//            window.location.href = path;
            $("#sendE").attr("href", path);
        }

        //显示是否完成选择框
        function showDone() {
            var dealResult = $("#dealResult").val();
            if (dealResult != null && dealResult != ' ') {
                if (dealResult == "6") {
                    $("#selectType").show();
                    $("#transferGroup").show();
                } else {
                    $("#selectType").hide();
                    $("#transferGroup").hide();
                }
                $("#selectDone").show();
            } else {
                $("#selectDone").hide();
            }
        }


        function getPersonName() {
            var dealPersonName = $("#dealPerson").val();
            $("#dealPersonName").val(dealPersonName);
        }

        /*跟据集团  获取对应的业务类型  和业务类别 */
        function getRegion(ts_describe){

            if(ts_describe != null && ts_describe != ''){
                    $.ajax({
                        type: "POST",
                        url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                        dataType: "json",
                        success: function(returnedData) {
                            console.log(returnedData);
                            var data1 = returnedData.ctBbtcRegionList;
                            var data2 = returnedData.ctBbtcBusTypeList;
//                            console.log(data1[0].name);
//                            console.log(data2[0].name);
                            var selectNode = $("#supplementArea");
                            selectNode.empty();//每次需要将上一次的数据进行清空
                            selectNode.append("<option value=''>请选择</option>");

                            if (data1 != '') {
                                var slsb=document.getElementById("supplementArea");
                                for (var i = 0;i < data1.length;i++){
                                 /*   if(i==0){
                                        slsb.options[i] = new Option("请选择","");
                                    }*/
                                    slsb.append(new Option(data1[i].name,data1[i].id));
                                }
                            }

                            /*重置选中项==================================================*/
                            /*$("#supplementArea").val("");*/
                          /*  $('#supplementArea').find("option").attr("selected", false);*/
                           /*    $("#supplementArea option[text='请选择']").attr("selected", true);*/
                           /* $("#supplementArea option:first").prop("selected", 'selected');*/
                          /*  $("#supplementArea").find("option").first().attr("selected", true);*/
                          /*  $("#supplementArea").val("").trigger('chosen:updated');*/
                          /*  $("#supplementArea").val('').trigger('liszt:updated');*/
                         /*   $('#supplementArea')
                                .find('option:first-child').prop('selected', true)
                                .end().trigger('chosen:updated');*/

                          /*  $('#supplementArea').options[0].selected = true;*/
                          /*  $("#supplementArea").find("option:selected").text("请选择");*/
                           /* $("#supplementArea option[text='请选择']").attr("selected", true);*/
                            $('#supplementArea option:first').prop("selected","selected");

                            /*每次选中新的菜单  需要清除上一次的菜单栏*/
                            var selectNode = $("#supplementType");
                            selectNode.empty();//每次需要将上一次的数据进行清空
                            selectNode.append("<option value=''>请选择</option>");

                            if (data2 != '') {
                                console.log(data2[0].name);
                                var slsb=document.getElementById("supplementType");
                                for (var i = 0;i < data2.length;i++){
                                  /*  if(i==0){
                                        slsb.options[i] = new Option("请选择","");
                                    }*/
                                    slsb.append(new Option(data2[i].name,data2[i].id));
                                }
                            }
                        },error:function(data){
                            alert("系统错误");
                        }
                    });
                }else{
                    top.$.jBox.tip('请选择被举报集团', 'warning');
                }

        }
        /*跟据集团  获取对应的业务类型  和业务类别 */
        function getDepartment(ts_describe){

            if(ts_describe != null && ts_describe != ''){
                    $.ajax({
                        type: "POST",
                        url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                        dataType: "json",
                        success: function(returnedData) {
                            console.log(returnedData);
                            var data1 = returnedData.ctBbtcBusTypeList;
//                            console.log(data1[0].name);
//                            console.log(data2[0].name);
                            var selectNode = $("#transferDepartment");
                            selectNode.empty();//每次需要将上一次的数据进行清空
                            selectNode.append("<option value=''>请选择</option>");

                            if (data1 != '') {
                                var slsb=document.getElementById("transferDepartment");
                                for (var i = 0;i < data1.length;i++){
                                 /*   if(i==0){
                                        slsb.options[i] = new Option("请选择","");
                                    }*/
                                    slsb.append(new Option(data1[i].name,data1[i].id));
                                }
                            }
                            $("#transferDepartment").val("");
                        },error:function(data){
                            alert("系统错误");
                        }
                    });
                }else{
                    top.$.jBox.tip('请选择被举报集团', 'warning');
                }

        }

        /*
   *联动查询类型下的类别
   */
        function getBusCategory(){

            /*获取类型选项框中的多个值  逗号分隔*/
           var  ts_describe=  $("#supplementType").val();
            /*alert(ts_describe);*/
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcBusCategory/getBusCategoryList?typeId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        console.log(returnedData);
                        var data = returnedData.ctBbtcBusCategoryList;
                        console.log(data[0].name);

                        var selectNode = $("#supplementCategory");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        selectNode.append("<option value=''>请选择</option>");


                        if (data != '') {
                            var slsb=document.getElementById("supplementCategory");
                            for (var i = 0;i < data.length;i++){
                              /*  if(i==0){
                                    slsb.options[i] = new Option("请选择","");
                                }*/
                                slsb.append(new Option(data[i].name,data[i].id));
                            }
                        }
                    },error:function(data){
                        alert("系统错误");
                    }
                });
            }else{
                top.$.jBox.tip('请选择业务类型', 'warning');
            }

        }

        function resetPageNo() {
            $("#pageNo").val(0);
        }


    </script>
    <style type="text/css">
        .title {
            font-size: 16px;
            font-weight: bold;
        }

        .black_overlay {
            display: none;
            position: absolute;
            top: 0%;
            left: 0%;
            width: 100%;
            height: 100%;
            z-index: 1001;
            -moz-opacity: 0.8;
            opacity: .80;
            filter: alpha(opacity=80);
        }

        .white_content {
            display: none;
            position: absolute;
            top: 150%;
            left: 10%;
            width: 80%;
            height: 80%;
            border: 1px solid;
            background-color: white;
            z-index: 1002;
            overflow: auto;
        }

        #chooseContent {
            margin: 20px 20px 20px 20px;
        }
    </style>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/report/track">跟踪举报信息</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="report" action="${ctx}/report/addTrack" method="post" class="form-horizontal">

<form:hidden id="reportId" path="id"/>
<sys:message content="${message}"/>
<div id="attachment1" style="display: none">
    <c:if test="${supplementAttachmentList ne null}">
        <c:forEach items="${reportAttachmentList}" var="reportAttachment" varStatus="vs">
            &nbsp;&nbsp;<a href="${reportAttachment.attachmentPath}" class="attachmentClass" target="_blank">${reportAttachment.attachmentName}</a><br>
        </c:forEach>
    </c:if>
</div>
<div id="reportDetail">
    <span class="title">举报内容</span>
    <div class="control-group">
        <label class="control-label">被举报项目/部门:</label>
        <div class="controls">
            <form:input path="reportProject" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">标题:</label>
        <div class="controls">
            <form:input path="supplementTitle" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">被举报人:</label>
        <div class="controls">
            <form:input path="supplementInformant" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">举报时间:</label>
        <div class="controls">
            <form:input path="reportTime" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">所在城市:</label>
        <div class="controls">
            <form:input path="reportCity" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">IP来源:</label>
        <div class="controls">
            <form:input path="reportIp" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">IP所属城市:</label>
        <div class="controls">
            <form:input path="ipCity" htmlEscape="false" maxlength="200" disabled="true" class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否已发送邮件:</label>
        <div class="controls">
            <form:input path="isSendEmail" htmlEscape="false" maxlength="200" disabled="true"
                        class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">内容:</label>
        <div class="controls">
            <form:textarea id="reportContent" htmlEscape="true" style="width:90%" path="reportContent" rows="6"
                           maxlength="500" class="input-xxlarge" disabled="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">附件:</label>
        <div class="controls">
            <c:forEach items="${reportAttachmentList}" var="reportAttachment" varStatus="vs">
                ${vs.count}.<a href="${reportAttachment.attachmentPath}" target="_blank">${reportAttachment.attachmentName}</a><br>
            </c:forEach>
        </div>
    </div>
    <span class="title">举报人信息</span>
    <c:if test="${ifClue eq true}">
        <div class="control-group">
            <label class="control-label">姓名:</label>
            <div class="controls">
                <form:input path="reportPersonName" htmlEscape="false" maxlength="200" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">手机号:</label>
            <div class="controls">
                <form:input path="reportPersonTel" htmlEscape="false" maxlength="200" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">Email:</label>
            <div class="controls">
                <form:input path="reportPersonEmail" htmlEscape="false" maxlength="200" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">QQ号:</label>
            <div class="controls">
                <form:input path="qq" htmlEscape="false" maxlength="200" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">微信号:</label>
            <div class="controls">
                <form:input path="weixin" htmlEscape="false" maxlength="200" class="input-xlarge "/>
            </div>
        </div>
    </c:if>
    <c:if test="${isAdmin eq '1'|| isAdmin eq '2'}">
        <div class="control-group">
            <label class="control-label">是否显示信息:</label>
            <div class="controls" >
                <input type="checkbox" id="ifClue" name="ifClue" Value="ifClue" />
            </div>
        </div>
    </c:if>
    <div class="control-group">
        <label class="control-label">举报途径:</label>
        <div class="controls">
            <form:radiobuttons path="reportSource" items="${fns:getDictList('report_source')}" itemLabel="label"
                               itemValue="value"
                               htmlEscape="false" disabled="true" style="margin-right: -23px\9;"/>
        </div>
    </div>
</div>
<span class="title">举报信息补充</span>
<%--<div class="control-group">
    <label class="control-label">业务类型:</label>
    <div class="controls">
                    <span class="supplementType">
                          <form:checkboxes path="supplementType" items="${fns:getDictList('supplement_type')}"
                                           itemLabel="label" itemValue="value" class="required"/>
                    </span>
    </div>
</div>--%>

<%--<div class="control-group">
    <label class="control-label">被举报区域:</label>
    <div class="controls">
        <form:select id="supplementArea" path="supplementArea" class="input-small required">
            <form:option value=" ">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_area')}" itemLabel="label" itemValue="value"
                          htmlEscape="false"/></form:select>
        <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>--%>
<div class="control-group">
    <label class="control-label">被举报集团:</label>
    <div class="controls">
        <form:select id="supplementGroup" path="supplementGroup" class="input-small required" onchange="getRegion(value)">
            <form:option value="">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                          htmlEscape="false"/>
        </form:select>

        <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>
<div class="control-group" >
    <label class="control-label">被举报区域:</label>
    <div class="controls">
       <%-- <select id="supplementArea" path="supplementArea" class="input-small required" onchange="resetPageNo();">
            <option value="">请选择</option>
            &lt;%&ndash;<options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"&ndash;%&gt;
                          &lt;%&ndash;htmlEscape="false"/></select>&ndash;%&gt;
        </select>--%>
        <form:select id="supplementArea" path="supplementArea" class="input-small required" onchange="resetPageNo();">
            <form:option value="">请选择</form:option>
        </form:select>
        <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>
<div class="control-group">
    <label class="control-label">业务类型:</label>
    <div class="controls">
        <%--<form:select id="supplementType" path="supplementType" class="input-small required" onchange="getBusCategory();" multiple="true">
            <form:option value="">请选择</form:option>
            <form:option value="">请选择02</form:option>
        </form:select>--%>
        <form:select id="supplementType" path="supplementType" class="input-small required" onchange="getBusCategory();" multiple="true">
            <form:option value="">请选择</form:option>
        </form:select>
                <%--<options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"--%>
                <%--htmlEscape="false"/></select>--%>
            <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>

<div class="control-group">
    <label class="control-label">业务类别:</label>
    <div class="controls">
        <form:select id="supplementCategory" path="supplementCategory" class="input-small required" onchange="resetPageNo();" multiple="true">
            <form:option value="">请选择</form:option>
        </form:select>
            <%--<options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"--%>
            <%--htmlEscape="false"/></select>--%>
        <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>

<div class="control-group">
    <label class="control-label">内容:</label>
    <div class="controls">
        <form:textarea id="supplementContent" htmlEscape="true" path="supplementContent" rows="6"
                       style="width:90%"
                       maxlength="3000" class="input-xxlarge" placeholder="最多输入3000个字符"/>
    </div>
</div>
<div class="control-group">
    <label class="control-label">附件:</label>
    <div id="attachment2" class="controls">
        <c:if test="${supplementAttachmentList ne null}">
            <c:forEach items="${supplementAttachmentList}" var="supplementAttachment" varStatus="vs">
                &nbsp;&nbsp;<a href="${supplementAttachment.attachmentPath}" class="attachmentClass" target="_blank">${supplementAttachment.attachmentName}</a><br>
            </c:forEach>
        </c:if>
        <form:hidden id="nameFile" path="supplementAttachment" htmlEscape="false"
                     maxlength="255" class="input-xlarge"/>
        <sys:ckfinder input="nameFile" type="files" uploadPath="/file"
                      selectMultiple="true" maxWidth="100" maxHeight="100"/>
    </div>
</div>
<span class="title">处理结果</span>
<div class="control-group">
    <label class="control-label">处理人:</label>
    <div class="controls">
        <input type="text" id="dealPersonName" name="dealPersonName" value="" style="display:none;"/>
        <form:input path="dealPerson" id="dealPerson" htmlEscape="false" maxlength="200" class="input-xlarge required"
                    onchange="getPersonName();"/>
        <span class="help-inline"><font color="red">*</font> </span>
    </div>
</div>
<div class="control-group">
    <label class="control-label">处理成果文件:</label>
    <div id="attachment3" class="controls">
        <c:if test="${dealAttachmentList ne null}">
            <c:forEach items="${dealAttachmentList}" var="dealAttachment" varStatus="vs">
                &nbsp;&nbsp;<a href="${dealAttachment.attachmentPath}" class="attachmentClass" target="_blank">${dealAttachment.attachmentName}</a><br>
            </c:forEach>
        </c:if>
        <form:hidden id="dealFile" path="dealAttachment" htmlEscape="false"
                     maxlength="255" class="input-xlarge"/>
        <sys:ckfinder input="dealFile" type="files" uploadPath="/file"
                      selectMultiple="true" maxWidth="100" maxHeight="100"/>
        <label id="checkFile" class="error" style="display: none;">必填信息</label>
    </div>
    <br>
    <label class="control-label">处理结论:</label>
    <div class="controls">
        <form:select path="dealResult" id="dealResult"  class="input-small required" onchange="showDone();">
            <form:option value=" ">请选择</form:option>
            <form:options items="${fns:getDictList('deal_result')}" itemLabel="label" itemValue="value"
                          htmlEscape="false"/>
        </form:select>
    </div>
    <br>
    <div id="transferGroup" class="control-group"  style="display:none">
        <label class="control-label">移交集团:</label>
        <div class="controls">
            <form:select id="" path="transferGroup" class="input-small required" onchange="getDepartment(value)">
                <form:option value="">请选择</form:option>
                <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                              htmlEscape="false"/></form:select>

            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div id="selectType" class="control-group" style="display:none">
        <label class="control-label">移交部门:</label>
        <div class="controls">
            <form:select id="transferDepartment" path="transferDepartment" class="input-small required">
                <form:option value="">请选择</form:option>
              <%--  <form:options items="${fns:getDictList('supplement_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>--%>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>

    </div>
    <br>
    <div class="controls" id="selectDone" style="display:none">
        <input type="checkbox" id="ifDone" name="ifDone" value="ifDone"/>是否完成
    </div>
    <span class="title">移交他人处理</span>
    <div class="control-group">
        <label class="control-label">移交:</label>
        <div class="controls">
            <input type="text" id="userId" name="exchangeAfterUser" value="" style="display:none;"/>
            <input id="chooseUser" type="text"
                   <c:if test="${report.exchangeType eq null}">value="选择移交人员" </c:if>
                   <c:if test="${report.exchangeAfterUser ne null && report.exchangeType ne null}">value="${report.transferName}" </c:if>
                   <c:if test="${isAdmin ne '1' && isAdmin ne '2'}">disabled="true" style="color:#888"</c:if>
                   htmlEscape="false"
                   maxlength="200" class="input-xlarge"/>
        </div>
    </div>
    <div class="form-actions">
        <input id="btnSubmit" class="btn btn-primary" type="submit" value="提交"/>&nbsp;
            <%--<input id="btnMail" class="btn btn-primary" type="button" value="发邮件" onclick="recordEmail()"/>--%>
        <a href="#" id="sendE" class="btn btn-primary" onclick="recordEmail()">发邮件</a>
    </div>
    </form:form>
    <div id="fade" class="black_overlay"></div>
    <div id="chooseDiv" class="white_content">
        <div id="chooseContent">
            <script type="text/javascript">
                $(document).ready(function () {
                    $("#btnSearch").click(function () {
                        $.ajax({
                            url: "${ctx}/report/viewTransfer?flag=1",
                            dataType: "html",
                            data: $('#searchForm').serialize(),
                            cache: false,
                            beforeSend: function () {
                                // 禁用按钮防止重复提交
                                $("#btnSearch").attr({disabled: "disabled"});
                            },
                            success: function (data) { //登录成功后返回的数据
                                $("#userList").empty();
                                $("#userList").html($(data));
                            },
                            error: function () {
                                alert("数据错误！");
                            },
                            complete: function () {
                                $("#btnSearch").removeAttr("disabled");
                            }
                        });
                    });

                    $("input:radio").click(function () {
                        $("input:radio").attr("checked", false);
                        $("#chooseItem").empty();
                        $(this).attr("checked", true);
                        $("#chooseItem").html("已选择 " + b.parent().next().next().next().html() + "<span onclick='remove();'><font size='5'> ×</font></span>");
                    });

                });

                function chooseRen(obj) {
                    $("input:radio").attr("checked", false);
                    $("#chooseItem").empty();
                    obj.checked = true;
                    $("#chooseItem").html("已选择 " + $("input:radio:checked").parent().next().next().next().html() + "<span onclick='remove();'><font size='5'> ×</font></span>");
                }

                function remove() {
                    $("input:radio").attr("checked", false);
                    $("#chooseItem").empty();
                }

                <%--function page(n, s) {--%>
                    <%--$("#pageNo").val(n);--%>
                    <%--$("#pageSize").val(s);--%>
                    <%--$.ajax({--%>
                        <%--url: "${ctx}/report/viewTransfer?flag=1",--%>
                        <%--dataType: "html",--%>
                        <%--data: $('#searchForm').serialize(),--%>
                        <%--cache: false,--%>
                        <%--success: function (data) { //登录成功后返回的数据--%>
                            <%--$("#userList").empty();--%>
                            <%--$("#userList").html($(data));--%>
                        <%--},--%>
                        <%--error: function () {--%>
                            <%--alert("数据错误！");--%>
                        <%--}--%>
                    <%--});--%>
                    <%--return false;--%>
                <%--}--%>

                function resetPageNo() {
                    $("#pageNo").val(0);
                }
            </script>
            <span class="title">选择移交人员</span>

            <div id="userList">
                <table id="contentTable" class="table table-striped table-bordered table-condensed">
                    <thead>
                    <tr>
                        <th>选择</th>
                        <th>ID</th>
                        <th>员工号</th>
                        <th>姓名</th>
                        <th>手机号</th>
                        <th>所属公司</th>
                        <th>所属部门</th>
                        <th>职位</th>
                    </tr>
                    </thead>
                    <tbody>

                    <c:if test="${page.list.size()>0}">
                        <c:forEach items="${page.list}" var="user" varStatus="vs">
                            <tr>
                                <td id="radioBtn"><input type="radio" value="${user.id}"></td>
                                <td>${vs.count}</td>
                                <td>${user.no}</td>
                                <td>${user.name}</td>
                                <td>${user.mobile}</td>
                                <td>${user.company.name}</td>
                                <td>${user.office.name}</td>
                                <td>${user.position.name}</td>
                            </tr>
                        </c:forEach>
                    </c:if>
                    </tbody>
                </table>
                <span id="chooseItem"></span>
                <c:if test="${page.list.size()=='0'}">
                    <span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
                </c:if>
                <c:if test="${page.list.size()>0}">
                    <div class="pagination">${page}</div>
                </c:if>
            </div>
            <li class="btns">
                <label style="width:auto;"><input id="btnConfirm" class="btn btn-primary" type="button" value="确定"/>&nbsp;&nbsp;
                    <input id="btnClose" class="btn btn-primary" type="button" value="关闭"/></label>
            </li>
        </div>
    </div>
</body>
</html>