/**
 *
 */
package com.ejweb.modules.front.upload.util;

import com.ejweb.conf.GConstants;
import com.ejweb.modules.upload.bean.UploadFileBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.List;

/**
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年8月8日
 */
public class UploadUtils {

    /**
     * 更加表单名称获取上传的文件实体
     * 
     * @author renmb
     * @time  2016年8月8日
     * @param uploadFiles  上传的文件列表
     * @param inputName    
     * @return
     */
    public UploadFileBean getUploadFileByInputName(List<UploadFileBean> uploadFiles, String inputName){
        if(StringUtils.isBlank(inputName) || uploadFiles == null || uploadFiles.size() == 0)
            return null;
        for(int i=0,len=uploadFiles.size();i<len;i++){// 以文件名称匹配
            // 获取同MD5或者同名的文件对象
            if(uploadFiles.get(i) != null && inputName.equalsIgnoreCase(uploadFiles.get(i).getInputName())){
                return uploadFiles.get(i);
            }
        }
        return null;
    }
    /**
     * 获取上传文件的文件路径
     * 
     * @author renmb
     * @time  2016年8月8日
     * @param uploadFiles
     * @param inputName
     * @return
     */
    public String getUploadFilePathByInputName(List<UploadFileBean> uploadFiles, String inputName){
        if(StringUtils.isBlank(inputName) || uploadFiles == null || uploadFiles.size() == 0)
            return null;
        for(int i=0,len=uploadFiles.size();i<len;i++){// 以文件名称匹配
            
            // 获取同MD5或者同名的文件对象
            if(uploadFiles.get(i) != null && inputName.equalsIgnoreCase(uploadFiles.get(i).getInputName())){
                
                return uploadFiles.get(i).getPath();
            }
        }
        return null;
    }
    /**
     * 将文件复制到其它备份磁盘
     *
     * author renmb
     * @time  2017年05月18日
     * @param file
     */
    public static void copyToMultiplePaths (final File file){

        final String dirs = GConstants.getValue("file.upload.dirs");
        if(StringUtils.isNotEmpty(dirs)){
            try {
                Thread thread = new Thread(new Runnable(){
                    @Override
                    public void run() {
                        String basePath = file.getAbsolutePath().replace(GConstants.FILE_UPLOAD_DIR, "");
                        String[] paths = dirs.split(";");
                        for (String path:paths){
                            InputStream input = null;
                            OutputStream output = null;
                            try{
                                File newFilePath = new File(path, basePath);
                                if(!newFilePath.getParentFile().exists()){// 如果文件夹不存在则创建
                                    newFilePath.getParentFile().mkdirs();
                                }
//                                LOG.debug("UploadService copyToMultiplePaths: "+file.getAbsolutePath()+" TO "+newFilePath.getAbsolutePath());
                                input = new FileInputStream(file);
                                output = new FileOutputStream(newFilePath);
                                IOUtils.copy(input, output);
                            } catch (Exception e){
                                IOUtils.closeQuietly(input);
                                IOUtils.closeQuietly(output);
                            }
                        }
                    }
                });
                thread.start();
            } catch (Exception e){

                e.printStackTrace();
            }
        }
    }
}
