/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.core.web;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

import com.ckfinder.connector.configuration.Configuration;
import com.ckfinder.connector.data.AccessControlLevel;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ejweb.conf.GConstants;
import com.ejweb.core.utils.FileUtils;
import com.ejweb.modules.sys.security.SystemAuthorizingRealm.Principal;
import com.ejweb.modules.sys.utils.UserUtils;
import org.mozilla.javascript.tools.shell.Global;

/**
 * CKFinder配置
 * @author ThinkGem
 * @version 2014-06-25
 */
public class CKFinderConfig extends Configuration {

    public CKFinderConfig(ServletConfig servletConfig) {
        super(servletConfig);
    }

    @Override
    protected Configuration createConfigurationInstance() {
        Principal principal = (Principal) UserUtils.getPrincipal();
        if (principal == null){
            return new CKFinderConfig(this.servletConf);
        }
        boolean isView = true;//UserUtils.getSubject().isPermitted("cms:ckfinder:view");
        boolean isUpload = true;//UserUtils.getSubject().isPermitted("cms:ckfinder:upload");
        boolean isEdit = true;//UserUtils.getSubject().isPermitted("cms:ckfinder:edit");
        AccessControlLevel alc = this.getAccessConrolLevels().get(0);
        alc.setFolderView(isView);
        alc.setFolderCreate(isEdit);
        alc.setFolderRename(isEdit);
        alc.setFolderDelete(isEdit);
        alc.setFileView(isView);
        alc.setFileUpload(isUpload);
        alc.setFileRename(isEdit);
        alc.setFileDelete(isEdit);
//        for (AccessControlLevel a : this.getAccessConrolLevels()){
//            System.out.println(a.getRole()+", "+a.getResourceType()+", "+a.getFolder()
//                    +", "+a.isFolderView()+", "+a.isFolderCreate()+", "+a.isFolderRename()+", "+a.isFolderDelete()
//                    +", "+a.isFileView()+", "+a.isFileUpload()+", "+a.isFileRename()+", "+a.isFileDelete());
//        }
        AccessControlUtil.getInstance(this).loadACLConfig();
        try {
//            Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
//            this.baseURL = ServletContextFactory.getServletContext().getContextPath()+"/userfiles/"+principal+"/";
//            this.baseURL = GConstants.getBaseUrl(Servlets.getRequest());// 图片前缀//FileUtils.path(Servlets.getRequest().getContextPath() + GConstants.USERFILES_BASE_URL + principal + "/");
//            this.baseDir = GConstants.getUserfilesBaseDir();// 文件地址根目录//FileUtils.path(GConstants.getUserfilesBaseDir() + Global.USERFILES_BASE_URL + principal + "/");
            this.baseURL = GConstants.getBaseUrl(Servlets.getRequest()) + GConstants.USERFILES_BASE_URL + "/"+principal + "/";
            this.baseDir = GConstants.getUserfilesBaseDir() + GConstants.USERFILES_BASE_URL +"/"+ principal + "/";

//            System.out.println("==================================================================");
//            System.out.println("       CKFinderConfig.createConfigurationInstance.baseURL:"+baseURL+"                                        ");
//            System.out.println("       CKFinderConfig.createConfigurationInstance.baseDir:"+baseDir+"                                        ");
//            System.out.println("==================================================================");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new CKFinderConfig(this.servletConf);
    }

    @Override  
    public boolean checkAuthentication(final HttpServletRequest request) {
        return UserUtils.getPrincipal()!=null;
    }

}
