/*
 * Decompiled with CFR 0.152.
 */
package org.geo.split.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static List<String> readLines(String path, String name) {
        File file = null;
        try {
            file = new File(path, name);
            return IOUtils.readLines(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<String> readLines(String path, String name, String encoding) throws IOException {
        File file = new File(path, name);
        return IOUtils.readLines(new FileInputStream(file), encoding);
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        if (encoding == null) {
            return IOUtils.readLines(input);
        }
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static boolean write(String data, String name, String encoding) {
        try {
            return IOUtils.write(data.getBytes(encoding), name, false);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean write(String data, String name) {
        return IOUtils.write(data.getBytes(), name, false);
    }

    public static boolean write(StringBuffer data, String encoding, String name) {
        try {
            return IOUtils.write(data.toString().getBytes(encoding), name, false);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean write(StringBuffer data, String name) {
        return IOUtils.write(data.toString().getBytes(), name, false);
    }

    public static boolean write(byte[] buffer, String name) {
        return IOUtils.write(buffer, name, false);
    }

    public static boolean append(String data, String name, String encoding) {
        try {
            return IOUtils.write(data.getBytes(encoding), name, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean append(String data, String name) {
        return IOUtils.write(data.getBytes(), name, true);
    }

    public static boolean append(StringBuffer data, String name, String encoding) {
        try {
            return IOUtils.write(data.toString().getBytes(encoding), name, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean append(StringBuffer data, String name) {
        return IOUtils.write(data.toString().getBytes(), name, true);
    }

    public static boolean append(byte[] buffer, String name) {
        return IOUtils.write(buffer, name, true);
    }

    public static boolean write(byte[] buffer, String name, boolean append) {
        OutputStream out = null;
        File file = null;
        try {
            try {
                file = new File(name);
                File pfile = new File(file.getParent());
                if (!pfile.exists()) {
                    pfile.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new FileOutputStream(file, append);
                out = new BufferedOutputStream(out);
                out.write(buffer);
                out.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static String read(String filePath, String fileName) {
        return IOUtils.read(filePath, fileName, null);
    }

    public static String read(String filePath, String fileName, String encoding) {
        StringBuffer content;
        block17: {
            File file = new File(filePath, fileName);
            InputStreamReader reader = null;
            content = null;
            BufferedReader buffer = null;
            if (file.canRead() && file.exists()) {
                try {
                    try {
                        reader = encoding == null || encoding.isEmpty() ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                        buffer = new BufferedReader(reader);
                        String line = "";
                        line = buffer.readLine();
                        content = new StringBuffer();
                        while (line != null) {
                            content.append(String.valueOf(line) + LINE_SEPARATOR);
                            line = buffer.readLine();
                        }
                    }
                    catch (IOException io) {
                        io.getStackTrace();
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                return null;
            }
        }
        return content.toString();
    }

    public static byte[] getBytes(File file) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(file);
            return IOUtils.getBytes(ins);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getBytes(InputStream ins) {
        ByteArrayOutputStream buffer;
        block17: {
            ins = new BufferedInputStream(ins);
            buffer = null;
            byte[] temp = null;
            try {
                try {
                    buffer = new ByteArrayOutputStream();
                    temp = new byte[4096];
                    int state = ins.read(temp);
                    while (state != -1) {
                        if (state == 4096) {
                            buffer.write(temp);
                        } else {
                            buffer.write(temp, 0, state);
                        }
                        state = ins.read(temp);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (ins != null) {
                            ins.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ins != null) {
                        ins.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buffer.toByteArray();
    }

    public static String getContent(File file, String encoding) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(file);
            return IOUtils.getContent(ins, encoding);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContent(File file) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(file);
            return IOUtils.getContent(ins, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContent(InputStream ins, String encoding) {
        ByteArrayOutputStream buffer;
        block20: {
            ins = new BufferedInputStream(ins);
            buffer = null;
            byte[] temp = null;
            try {
                try {
                    buffer = new ByteArrayOutputStream();
                    temp = new byte[4096];
                    int state = ins.read(temp);
                    while (state != -1) {
                        if (state == 4096) {
                            buffer.write(temp);
                        } else {
                            buffer.write(temp, 0, state);
                        }
                        state = ins.read(temp);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (ins != null) {
                            ins.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {}
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ins != null) {
                        ins.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (encoding == null || encoding.isEmpty()) {
                return buffer.toString();
            }
            return buffer.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

