package com.ejweb.modules.report.dao;

import com.ejweb.core.persistence.CrudDao;
import com.ejweb.core.persistence.annotation.MyBatisDao;
import com.ejweb.modules.report.entity.ReportAttachmentEntity;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.entity.ReportExchangeHistory;
import com.ejweb.modules.sys.entity.Office;
import com.ejweb.modules.sys.entity.Position;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.workbench.Bean.WorkbenchBean;
import com.ejweb.modules.workbench.entity.ReportNotice;

import java.util.HashMap;
import java.util.List;

/**
 * 举报DAO接口
 *
 * @author lixy
 * @version 2017-09-06
 */
@MyBatisDao
public interface ReportDao extends CrudDao<ReportEntity> {
    /**
     * 查询用户角色
     *
     * @param user
     * @return
     */
    public String findRole(User user);

    /**
     * 查询附件
     *
     * @param reportAttachmentEntity
     * @return
     */
    public List<ReportAttachmentEntity> getAttachmentInfo(ReportAttachmentEntity reportAttachmentEntity);

    /**
     * 新增举报
     *
     * @param reportEntity
     * @return
     */
    public int addReport(ReportEntity reportEntity);

    /**
     * 新增附件
     *
     * @param reportAttachmentEntity
     * @return
     */
    public int addReportAttachment(ReportAttachmentEntity reportAttachmentEntity);

    /**
     * 举报信息补充
     *
     * @param reportEntity
     * @return
     */
    public int addTrack(ReportEntity reportEntity);

    /**
     * 更新举报状态
     *
     * @param reportEntity
     * @return
     */
    public int updateReportStatus(ReportEntity reportEntity);

    /**
     * 查询用户
     *
     * @param user
     * @return
     */
    public List<User> findUser(User user);

    /**
     * 查询公司列表
     *
     * @return
     */
    public List<Office> getCompanyList();

    /**
     * 查询部门列表
     *
     * @return
     */
    public List<Office> getOfficeList(Office office);

    /**
     * 查询职位列表
     *
     * @return
     */
    public List<Position> getPositionList();

    /**
     * 根据reportId查询消息表中是否已存在该条记录
     *
     * @param reportEntity
     * @return
     */
    public ReportNotice findReportNotice(ReportEntity reportEntity);

    /**
     * 新增消息
     *
     * @param reportNotice
     * @return
     */
    public int addReportNotice(ReportNotice reportNotice);

    /**
     * 更新消息表
     *
     * @param reportNotice
     * @return
     */
    public int updateReportNotice(ReportNotice reportNotice);

    /**
     * 新增消息
     *
     * @param reportExchangeHistory
     * @return
     */
    public int addRecord(ReportExchangeHistory reportExchangeHistory);

    /**
     * 查询管理员ID
     *
     * @return
     */
    public List<String> findAdmin(Office office);

    /**
     * 举报状态数据
     */
    public List<HashMap> getReportStatus(WorkbenchBean benchBean) throws Exception;

    /**
     * 举报结果数据
     */
    public List<HashMap> getReportResult(WorkbenchBean benchBean) throws Exception;

    /**
     * 总体
     */
    public List<HashMap> getTotal(WorkbenchBean benchBean) throws Exception;

    /**
     * 举报类型
     */
    public List<HashMap> getReportType(WorkbenchBean benchBean) throws Exception;

    /**
     * 举报列表
     */
    public List<ReportEntity> getRepList(WorkbenchBean benchBean) throws Exception;

    /**
     * 工作转交 查询举报记录
     *
     * @param reportEntity
     * @return
     */
    public List<ReportEntity> getChooseReportList(ReportEntity reportEntity);

    /**
     * 区域列表查询
     *
     * @param reportEntity
     * @return
     */
    public List<ReportEntity> findQyList(ReportEntity reportEntity);

    /**
     * 工作转交 更改转交人
     *
     * @param reportEntity
     * @return
     */
    public int updateExchangeUser(ReportEntity reportEntity);

    /**
     * 查询移交后人员
     *
     * @return
     */
    public String findExchangeUser(String id);

    /**
     * 记录发邮件
     *
     * @return
     */
    public int updateIsSendEmail(String reportId);

    /**
     * 更新处理结论
     *
     * @param reportEntity
     * @return
     */
    public int updateConclusion(ReportEntity reportEntity);

    /**
     * 重新跟踪
     *
     * @param reportEntity
     * @return
     */
    public int againUpdateConclusion(ReportEntity reportEntity);

    /**
     * 转为线索
     *
     * @param reportEntity
     * @return
     */
    public int cluesUpdateConclusion(ReportEntity reportEntity);

    /**
     * 总数
     */
    public int getTotalNum(WorkbenchBean bean);

    /**
     * 删除举报信息
     *
     * @param reportEntity
     * @return
     */
    public int deleteConclusion(ReportEntity reportEntity);

    /**
     * 删除举报信息
     *
     * @param reportEntity
     * @return
     */
    public int deleteNotice(ReportEntity reportEntity);

    /**
     * 查询有效用户
     * @return
     */
    public  List<User> findAllUserList();

    /**
     * 查询移交给那位用户
     * @return
     */
    public String selectExchangeAfterUser(String report);


    /**
     * 查询数据列表，检验基础资料是否使用
     * @param entity
     * @return
     */
    public List<ReportEntity> findListByCheck(ReportEntity entity);


    /**
     * 跟据当前时间查询已到期的举报信息,将过期信息状态设置无效
     * @param entity
     * @return
     */
    int updateReportByClueTime(ReportEntity entity);
}
