/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.core.web;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ckfinder.connector.ConnectorServlet;
import com.ejweb.conf.GConstants;
import com.ejweb.core.utils.FileManipulation;
import com.ejweb.core.utils.FileUtils;
import com.ejweb.modules.sys.security.SystemAuthorizingRealm.Principal;
import com.ejweb.modules.sys.utils.UserUtils;

/**
 * CKFinderConnectorServlet
 * @author ThinkGem
 * @version 2014-06-25
 */
public class CKFinderConnectorServlet extends ConnectorServlet {
    
    private static final long serialVersionUID = 1L;
    
    @Override
    protected void doGet(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        prepareGetResponse(request, response, false);
        super.doGet(request, response);
    }
    
    @Override
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        prepareGetResponse(request, response, true);
        super.doPost(request, response);
    }
    
    private void prepareGetResponse(final HttpServletRequest request,
            final HttpServletResponse response, final boolean post) throws ServletException {
        
        try {
            Principal principal = (Principal) UserUtils.getPrincipal();
            if (principal == null){
                return;
            }
            String command = request.getParameter("command");
            String type    = request.getParameter("type");
            if ("Init".equals(command)){// 初始化时，如果startupPath文件夹不存在，则自动创建startupPath文件夹
                String startupPath = request.getParameter("startupPath");// 当前文件夹可指定为模块名
                if (startupPath!=null){
                    String[] ss = startupPath.split(":");
                    if (ss.length==2){
                        String realPath = GConstants.getUserfilesBaseDir() + GConstants.USERFILES_BASE_URL
                                + "/"+principal + "/" + ss[0] + ss[1];
//                        FileUtils.createDirectory(FileUtils.path(realPath));
                        
//                        String realPath = GConstants.getUserfilesBaseDir() + "/" + ss[0] + ss[1];
                        realPath= FileManipulation.validateFile(realPath);
                        File fileRealPath = new File(FileManipulation.validateFile(realPath));
                        if(fileRealPath.exists() == false){
                            fileRealPath.mkdirs();
                        }
                    }
                }
            } else if ("QuickUpload".equals(command) && type != null){// 快捷上传，自动创建当前文件夹，并上传到该路径
                String currentFolder = request.getParameter("currentFolder");// 当前文件夹可指定为模块名
//                String realPath = GConstants.getUserfilesBaseDir() + GConstants.USERFILES_BASE_URL
//                        + principal + "/" + type + (currentFolder != null ? currentFolder : "");
//                FileUtils.createDirectory(FileUtils.path(realPath));
                
                String realPath = GConstants.getUserfilesBaseDir() + "/" + type + (currentFolder != null ? currentFolder : "");
                // 验证文件安全
                realPath= FileManipulation.validateFile(realPath);
                File fileRealPath = new File(FileManipulation.validateFile(realPath));
                if(fileRealPath.exists() == false){
                    fileRealPath.mkdirs();
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
        }
    }
    
}
