/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ltpa;

import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class LtpaToken {
    private byte[] creation;
    private Date creationDate;
    private byte[] digest;
    private byte[] expires;
    private Date expiresDate;
    private byte[] hash;
    private byte[] header;
    private String tokenStr;
    private byte[] rawToken;
    private byte[] user;

    public LtpaToken() {
        this.init();
    }

    public LtpaToken(String token) {
        this.init();
        this.tokenStr = token;
        this.rawToken = BASE64Util.decodeAsBytes(token);
        this.user = new byte[this.rawToken.length - 40];
        int i = 0;
        while (i < 4) {
            this.header[i] = this.rawToken[i];
            ++i;
        }
        i = 4;
        while (i < 12) {
            this.creation[i - 4] = this.rawToken[i];
            ++i;
        }
        i = 12;
        while (i < 20) {
            this.expires[i - 12] = this.rawToken[i];
            ++i;
        }
        i = 20;
        while (i < this.rawToken.length - 20) {
            this.user[i - 20] = this.rawToken[i];
            ++i;
        }
        i = this.rawToken.length - 20;
        while (i < this.rawToken.length) {
            this.digest[i - (this.rawToken.length - 20)] = this.rawToken[i];
            ++i;
        }
        this.creationDate = new Date(Long.parseLong(new String(this.creation), 16) * 1000L);
        this.expiresDate = new Date(Long.parseLong(new String(this.expires), 16) * 1000L);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getUsername() {
        String userName = null;
        try {
            userName = new String(this.user, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    public String getUsername(String code) {
        String userName = null;
        try {
            userName = new String(this.user, code);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    private void init() {
        this.creation = new byte[8];
        this.digest = new byte[20];
        this.expires = new byte[8];
        this.hash = new byte[20];
        this.header = new byte[4];
    }

    public boolean isValid(String secretKey) {
        boolean validDigest = false;
        boolean validDateRange = false;
        byte[] bytes = null;
        Date now = new Date();
        MessageDigest md = this.getMessageDigest();
        bytes = LMBCSUtil.concatenate(bytes, this.header);
        bytes = LMBCSUtil.concatenate(bytes, this.creation);
        bytes = LMBCSUtil.concatenate(bytes, this.expires);
        bytes = LMBCSUtil.concatenate(bytes, this.user);
        bytes = LMBCSUtil.concatenate(bytes, BASE64Util.decodeAsBytes(secretKey));
        byte[] newDigest = md.digest(bytes);
        validDigest = MessageDigest.isEqual(this.digest, newDigest);
        System.out.println("valid message digest :" + validDigest);
        validDateRange = now.before(this.expiresDate);
        boolean result = validDigest && validDateRange;
        System.out.println("creationDate[" + this.creationDate + "]<now[" + now + "]<expiresDate[" + this.expiresDate + "],validDateRange:" + validDateRange + ",verify result:" + result);
        return result;
    }

    public String toString() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public byte[] getCreation() {
        return this.creation;
    }

    public void setCreation(byte[] creation) {
        this.creation = creation;
    }

    public byte[] getExpires() {
        return this.expires;
    }

    public void setExpires(byte[] expires) {
        this.expires = expires;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public void setUser(byte[] user) {
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public String getTokenStr() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public static String encodeToken(String token) {
        try {
            return URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(token, "UTF-8"), "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Token encode error[UnsupportedEncodingException]!");
            e.printStackTrace();
            return token;
        }
    }

    public static String decodeToken(String token) {
        if (token.indexOf("+") == -1) {
            try {
                String decodeToken1 = URLDecoder.decode(token, "UTF-8");
                if (decodeToken1.indexOf("+") == -1) {
                    String decodeToken2 = URLDecoder.decode(decodeToken1, "UTF-8");
                    if (decodeToken2.indexOf("+") == -1) {
                        return URLDecoder.decode(decodeToken2, "UTF-8");
                    }
                    return decodeToken2;
                }
                return decodeToken1;
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Token decode error[UnsupportedEncodingException]!");
                e.printStackTrace();
            }
        }
        return token;
    }

    public static void main(String[] args) {
        String prime = "%2525252BEE";
        String encode = LtpaToken.encodeToken(prime);
        String decode = LtpaToken.decodeToken(encode);
        System.out.println(encode);
        System.out.println(decode);
        System.out.println(prime.equals(decode));
    }
}

