/**
 *
 */
package com.ejweb.modules.upload.util;

import com.ejweb.modules.upload.bean.UploadFileBean;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年8月8日
 */
public class UploadUtils {

    /**
     * 更加表单名称获取上传的文件实体
     * 
     * @author renmb
     * @time  2016年8月8日
     * @param uploadFiles  上传的文件列表
     * @param inputName    
     * @return
     */
    public UploadFileBean getUploadFileByInputName(List<UploadFileBean> uploadFiles, String inputName){
        if(StringUtils.isBlank(inputName) || uploadFiles == null || uploadFiles.size() == 0)
            return null;
        for(int i=0,len=uploadFiles.size();i<len;i++){// 以文件名称匹配
            // 获取同MD5或者同名的文件对象
            if(uploadFiles.get(i) != null && inputName.equalsIgnoreCase(uploadFiles.get(i).getInputName())){
                return uploadFiles.get(i);
            }
        }
        return null;
    }
    /**
     * 获取上传文件的文件路径
     * 
     * @author renmb
     * @time  2016年8月8日
     * @param uploadFiles
     * @param inputName
     * @return
     */
    public String getUploadFilePathByInputName(List<UploadFileBean> uploadFiles, String inputName){
        if(StringUtils.isBlank(inputName) || uploadFiles == null || uploadFiles.size() == 0)
            return null;
        for(int i=0,len=uploadFiles.size();i<len;i++){// 以文件名称匹配
            
            // 获取同MD5或者同名的文件对象
            if(uploadFiles.get(i) != null && inputName.equalsIgnoreCase(uploadFiles.get(i).getInputName())){
                
                return uploadFiles.get(i).getPath();
            }
        }
        return null;
    }
}
