<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>举报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">

        var requestFlag = true;
        $(document).ready(function () {
            $("#btnExport").click(function () {
                top.$.jBox.confirm("确认要导出数据吗？", "系统提示", function (v, h, f) {
                    if (v == "ok") {
                        $("#searchForm").attr("action", "${ctx}/report/export");
                        $("#searchForm").submit();
                    }
                }, {buttonsFocus: 1});
                top.$('.jbox-body .jbox-icon').css('top', '55px');
            });
            $("#btnSubmit").click(function () {
                $("#searchForm").attr("action", "${ctx}/report");
                $("#searchForm").submit();
            });
            $("#btnAdd").click(function () {
                window.location.href = "${ctx}/report/form";
            });
            $("#btnReset").click(function () {
                var flag = $("#flag").val();
                window.location.href = "${ctx}/report/list?flag=" + flag;
            });
            //序号连续
            var i = 1;
            var pageNo = $("#pageNo").val();
            var pageSize = $("#pageSize").val();
            $(".reportList").each(function () {
                var num = (pageNo - 1) * pageSize + i;
                i += 1;
                $(this).children("td:first-child").html(num);
            });
        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/report");
            $("#searchForm").submit();
            return false;
        }

        function resetPageNo() {
            $("#pageNo").val(0);
        }

        function openDownloadDialog(id) {
            if (requestFlag == true) {
                $.ajax({
                    url: "${ctx}/report/toWord?id=" + id,
                    dataType: "text",
                    traditional: true,//这里设置为true
                    cache: false,
                    beforeSend: function () {
                        requestFlag = false;
                    },
                    success: function (url) { //登录成功后返回的数据
                        window.open(url, "_blank");
                    },
                    error: function () {
                        alert("数据错误！");
                    },
                    complete: function () {
                        requestFlag = true;
                    }
                });
            } else {
                top.$.jBox.tip('正在加载，请稍等', 'warning');
            }
        }

        window.onload = function () {
            var tTD; //用来存储当前更改宽度的Table Cell,避免快速移动鼠标的问题
            var table = document.getElementById("contentTable");
            for (j = 0; j < table.rows[0].cells.length; j++) {
                table.rows[0].cells[j].onmousedown = function () {
//记录单元格
                    tTD = this;
                    if (event.offsetX > tTD.offsetWidth - 10) {
                        tTD.mouseDown = true;
                        tTD.oldX = event.x;
                        tTD.oldWidth = tTD.offsetWidth;
                    }
//记录Table宽度
//table = tTD; while (table.tagName != ‘TABLE') table = table.parentElement;
//tTD.tableWidth = table.offsetWidth;
                };
                table.rows[0].cells[j].onmouseup = function () {
//结束宽度调整
                    if (tTD == undefined) tTD = this;
                    tTD.mouseDown = false;
                    tTD.style.cursor = 'default';
                };
                table.rows[0].cells[j].onmousemove = function () {
//更改鼠标样式
                    if (event.offsetX > this.offsetWidth - 10)
                        this.style.cursor = 'col-resize';
                    else
                        this.style.cursor = 'default';
//取出暂存的Table Cell
                    if (tTD == undefined) tTD = this;
//调整宽度
                    if (tTD.mouseDown != null && tTD.mouseDown == true) {
                        tTD.style.cursor = 'default';
                        if (tTD.oldWidth + (event.x - tTD.oldX) > 0)
                            tTD.width = tTD.oldWidth + (event.x - tTD.oldX);
//调整列宽
                        tTD.style.width = tTD.width;
                        tTD.style.cursor = 'col-resize';
//调整该列中的每个Cell
                        table = tTD;
                        while (table.tagName != 'TABLE') table = table.parentElement;
                        for (j = 0; j < table.rows.length; j++) {
                            table.rows[j].cells[tTD.cellIndex].width = tTD.width;
                        }
//调整整个表
//table.width = tTD.tableWidth + (tTD.offsetWidth – tTD.oldWidth);
//table.style.width = table.width;
                    }
                };
            }

        }

        function del(id) {
            var msg = "您真的确定要删除吗？\n\n请确认！";
            if (confirm(msg) == true) {

                $.ajax({
                    type: "post",
                    url: "${ctx}/report/deleteconclusion",
                    data: {"id": id},
                    dataType: "json",
                });
                location.reload();
                alert("删除成功")
            } else {
                return false;
            }
        }

        function aa() {
            var a = document.getElementById("t_r_content").scrollTop;
            var b = document.getElementById("t_r_content").scrollLeft;
            document.getElementById("cl_freeze").scrollTop = a;
            document.getElementById("t_r_t").scrollLeft = b;
        }

        function overShow() {
            var showDiv = document.getElementById('showDiv');
            showDiv.style.left = event.clientX;
            showDiv.style.top = event.clientY;
            showDiv.style.display = 'block';
            showDiv.innerHTML = '鼠标停留显示内容2';
        }

        function outHide() {
            var showDiv = document.getElementById('showDiv');
            showDiv.style.display = 'none';
            showDiv.innerHTML = '';
        }

        function getRegion(ts_describe){
            console.log(ts_describe);
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        console.log(returnedData);
                        var data1 = returnedData.ctBbtcRegionList;
                        var data2 = returnedData.ctBbtcBusTypeList;
//                            console.log(data1[0].name);
//                            console.log(data2[0].name);
                        var selectNode = $("#supplementArea");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        selectNode.append("<option value=''>请选择</option>");
                        if (data1 != '') {
                            var slsb=document.getElementById("supplementArea");
                            for (var i = 0;i < data1.length;i++){
                                console.log(data1[i].name);
                                slsb.append(new Option(data1[i].name,data1[i].id));
                            }
                        }

                        var selectNode = $("#supplementType");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        selectNode.append("<option value=''>请选择</option>");
                        if (data2 != '') {
                            console.log(data2[0].name);
                            var slsb=document.getElementById("supplementType");
                            for (var i = 0;i < data2.length;i++){
                                slsb.append(new Option(data2[i].name,data2[i].id));
                            }
                        }

                    },error:function(data){
                        alert("系统错误");
                    }
                });
            }else{
                top.$.jBox.tip('请选择被举报集团', 'warning');
            }

        }
        /*
        *联动查询类型下的类别   传多个id
        */
        function getBusCategory(ts_describe){
            console.log(ts_describe);
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcBusCategory/getBusCategoryList?typeId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        console.log(returnedData);
                        var data = returnedData.ctBbtcBusCategoryList;

                        var selectNode = $("#supplementCategory");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        selectNode.append("<option value=''>请选择</option>");
                        if (data != '') {
                            var slsb=document.getElementById("supplementCategory");
                            for (var i = 0;i <= data.length;i++){
                                slsb.append(new Option(data[i].name,data[i].id));
                            }

                        }
                    },error:function(data){
                        alert("系统错误");
                    }
                });
            }else{
                top.$.jBox.tip('请选择业务类型', 'warning');
            }

        }

        function getTransferDepartment(ts_describe){
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        var data2 = returnedData.ctBbtcBusTypeList;

                        //移交部门赋值
                        var selectNode = $("#transferDepartment");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        selectNode.append("<option value=''>请选择</option>");
                        if (data2 != '') {
                            console.log(data2[0].name);
                            var slsb=document.getElementById("transferDepartment");
                            for (var i = 0;i < data2.length;i++){
                                slsb.append(new Option(data2[i].name,data2[i].id));
                            }
                        }
                    },error:function(data){
                        alert("系统错误");
                    }
                });
            }else{
                top.$.jBox.tip('请选择业务类型', 'warning');
            }

        }

        function resetPageNo() {
            $("#pageNo").val(0);
        }

    </script>

    <style type="text/css">
        table {

            table-layout: fixed;
        }

        th {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;

        }

        td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;

        }

        table {
            border-collapse: collapse;
            border-spacing: 0px;

        }

        table td {

            height: 25px;
            border-left: 0px;
        }

        table th {

            white-space: nowrap;
            text-align: center;
            height: 21px;
            border-top: 0px;
            border-left: 0px;
        }

        .t_left {
            width: 30%;
            float: left;
        }

        /*t_r_content和cl_freeze高度相差20px， 高度为外观显示高度，可根据情况调整*/
        .t_r_content {
            width: 100%;
            height: 410px;
            background: #fff;
            overflow: auto;
        }

        .cl_freeze {
            height: 410px;

            width: 101%;
        }

        /* width 调整左边标题列宽度（左侧外观显示宽度）; 指定为width:auto 在Opera下显示有问题; height比 t_r_content 高度小20px*/
        /* width 宽度为 右侧外观显示宽度 实际显示宽度大小为“t_r”宽度加上“cl_freeze”宽度 */
        /* 如果显示不正常，调整 t_r的width 使其和t_left的width之和小于100%；等于100%时会有问题*/
        .t_r {
            width: 70%;
            float: left;
        }

        .t_r table {
            width: 1700px;
        }

        .t_r_title {
            width: 1720px;
        }

        /*宽度比 t_r table 大20px （至少大20，小了滚动条滑到右侧显示有问题）*/
        .t_r_t {

            overflow: hidden;
        }

        .bordertop {
            border-top: 0px;
        }

        #content {
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            width: 200px;
        }
    </style>
</head>
<body>
<ul class="nav nav-tabs">
    <li <c:if test="${flag eq '1'}">class="active"</c:if>><a href="${ctx}/report/list?flag=1">跟踪中举报列表</a></li>
    <li <c:if test="${flag eq '0'}">class="active"</c:if>><a href="${ctx}/report/list?flag=0">未处理举报列表</a></li>
    <li <c:if test="${flag eq '4'}">class="active"</c:if>><a href="${ctx}/report/list?flag=4">线索列表</a></li>
    <li <c:if test="${flag eq null or flag eq ''}">class="active"</c:if>><a href="${ctx}/report/list">举报列表</a></li>

    <%--<li style="float: right;"><input id="btnAdd" class="btn btn-primary" type="button" value="举报录入"/></li>--%>
</ul>
<form:form id="searchForm" modelAttribute="report" action="${ctx}/report/list" method="post"
           class="breadcrumb form-search">
<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
<input id="flag" name="flag" type="hidden" value="${flag}"/>
<ul class="ul-form">
    <li><label>标题：</label><form:input onchange="resetPageNo();" path="supplementTitle" htmlEscape="false"
                                      maxlength="50" class="input-small"/></li>
    <li><label>被举报项目/部门：</label><form:input onchange="resetPageNo();" path="reportProject" htmlEscape="false"
                                            maxlength="50" class="input-small"
                                            style="position:relative;top:-12.5px"/></li>
    <li><label>举报时间：</label><input id="reportTimeFrom" name="reportTimeFrom" onchange="resetPageNo();"
                                   readonly="readonly" type="text"
                                   maxlength="200" class="input-mini Wdate required"
                                   value="${report.reportTimeFrom}"
                                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true,maxDate:'#F{$dp.$D(\'reportTimeTo\')}'});"/>
    </li>
    <li><label>至：</label><input id="reportTimeTo" name="reportTimeTo" onchange="resetPageNo();" readonly="readonly"
                                type="text"
                                maxlength="200" class="input-mini Wdate required" value="${report.reportTimeTo}"
                                onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true,minDate:'#F{$dp.$D(\'reportTimeFrom\')}'});"/>
    </li>

    <li><label>举报人：</label><form:input onchange="resetPageNo();" path="reportPersonName" htmlEscape="false"
                                       maxlength="50" class="input-small"/></li>
    <li><label>举报人电话：</label><form:input onchange="resetPageNo();" path="reportPersonTel" htmlEscape="false"
                                         maxlength="50" class="input-small"/></li>

    <li><label>状态：</label><form:select onchange="resetPageNo();" path="reportStatus" class="input-small">
        <form:option value=" ">请选择</form:option>
        <form:options items="${fns:getDictList('report_status')}" itemLabel="label" itemValue="value"
                      htmlEscape="false"/></form:select></li>
    <li><label>被举报人：</label><form:input onchange="resetPageNo();" path="supplementInformant" htmlEscape="false"
                                        maxlength="50" class="input-small"/></li>

    <li><label>所属集团：</label>
        <form:select id="supplementGroup" path="supplementGroup" class="input-small required" onchange="getRegion(value)">
            <form:option value="">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                          htmlEscape="false"/>
        </form:select>
    </li>

    <li><label>所属区域：</label>
            <%-- <select id="supplementArea" path="supplementArea" class="input-small required" onchange="resetPageNo();">
                 <option value="">请选择</option>
                     &lt;%&ndash;<options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"&ndash;%&gt;
                     &lt;%&ndash;htmlEscape="false"/></select>&ndash;%&gt;
             </select>--%>
        <form:select id="supplementArea"  onchange="resetPageNo();" path="supplementArea" class="input-small" value="${report.supplementArea}">
            <form:option value="">请选择</form:option>
        </form:select>
    </li>
    <li><label>业务类型：</label>
        <form:select id="supplementType"  onchange="getBusCategory(value);" path="supplementType" class="input-small" value="${report.supplementType}">
            <form:option value="">请选择</form:option>
        </form:select>
    </li>

    <li><label>业务类别：</label>
        <form:select onchange="resetPageNo();" path="supplementCategory" class="input-small"  id="supplementCategory" value="${report.supplementCategory}">
            <form:option value="">请选择</form:option>
        </form:select>
    </li>

    <li><label>移交集团：</label>
       <%-- <form:select onchange="resetPageNo();" path="transferGroup" class="input-small"  id="transferGroup" value="${report.transferGroup}">
            <form:option value="">请选择</form:option>
        </form:select>--%>
        <form:select id="transferGroup" path="transferGroup" class="input-small required" onchange="getTransferDepartment(value)">
            <form:option value="">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                          htmlEscape="false"/>
        </form:select>
    </li>
    <li><label>移交部门：</label>
      <%--  <form:select onchange="resetPageNo();" path="transferDepartment" class="input-small"  id="transferDepartment" value="${report.transferDepartment}">
            <form:option value="">请选择</form:option>
        </form:select>--%>
        <form:select id="transferDepartment"  onchange="resetPageNo();" path="transferDepartment" class="input-small" value="${report.transferDepartment}">
            <form:option value="">请选择</form:option>
        </form:select>
    </li>

    <li><label>处理结论：</label><form:select onchange="resetPageNo();" path="dealResult" class="input-small">
        <form:option value=" ">请选择</form:option>
        <form:options items="${fns:getDictList('deal_result')}" itemLabel="label" itemValue="value"
                      htmlEscape="false"/></form:select></li>
    <li><label>举报途径：</label><form:select onchange="resetPageNo();" path="reportSource" class="input-small">
        <form:option value=" ">请选择</form:option>
        <form:options items="${fns:getDictList('report_source')}" itemLabel="label" itemValue="value"
                      htmlEscape="false"/></form:select></li>

        <c:if test="${isAdmin eq '1' || isAdmin eq '2'}">
                <li><label>移交给：</label><form:select onchange="resetPageNo();" path="selectExchangeAfterUser" class="input-small">
                    <form:option value=" ">请选择</form:option>
                    <form:options items="${fns:getTransferName()}" itemLabel="label" itemValue="value"
                                  htmlEscape="false"/></form:select></li></c:if>
    <c:if test="${isAdmin eq '1' || isAdmin eq '2'}">
         <li><label>录入人：</label><form:select onchange="resetPageNo();" path="oaname" class="input-small">
              <form:option value=" ">请选择</form:option>
              <form:options items="${fns:getTransferName()}" itemLabel="label" itemValue="label"
                            htmlEscape="false"/></form:select></li></c:if>


          <li class="clearfix"></li>
          <li class="btns">
                  <%--  <label style="width:auto;">--%>&nbsp;&nbsp;&nbsp;<input id="btnSubmit" class="btn btn-primary"
                                                                        type="submit" value="筛选"/>&nbsp;&nbsp;
        <input id="btnReset" class="btn btn-primary" type="button" value="重置"/>&nbsp;&nbsp;
        <input id="btnExport" class="btn btn-primary" type="button" value="导出"/></label>
    </li>
    <li class="clearfix"></li>
</ul>
</form:form>
<sys:message content="${message}"/>
<div style="width:100%">
    <div class="t_left">
        <div class="cl_freeze" id="cl_freeze">
            <table class=" table-striped table-bordered table-condensed" cellspacing="0" cellpadding="2" border="2">
                <thead>
                <tr>

                    <th style="width:5%">ID</th>

                    <th style="width:15%">标题</th>
                </tr>
                </thead>
                <tbody>
                <c:if test="${page.list.size()>0}">
                <c:forEach items="${page.list}" var="report" varStatus="vs">
                <tr class="reportList">
                    <td align="center" style="width:5%"></td>
                    <td align="left" style="width:15%" title= ${report.supplementTitle}>${report.supplementTitle}</td>

                    </c:forEach>
                    </c:if>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="t_r">
        <div class="t_r_t" id="t_r_t">
            <div class="t_r_content" id="t_r_content" onscroll="aa()">
                <div class="t_r_title">
                    <table id="contentTable" class=" table-striped table-bordered table-condensed" cellspacing="0"
                           cellpadding="2" border="2">
                        <thead>
                        <tr>
                            <th>所属集团</th>
                            <th>所属区域</th>
                            <th>业务类型</th>
                            <th>业务类别</th>
                            <th>被举报项目/部门</th>
                            <th>录入人</th>
                            <th>举报人</th>
                            <th>举报人电话</th>
                            <th>举报途径</th>
                            <th>被举报人</th>
                            <th>举报时间</th>
                            <th>状态</th>
                            <th>处理结论</th>
                            <th><%--<td>移交集团</td><td>移交部门</td>--%>移交部门</th>
                            <th>处理人</th>
                            <c:if test="${isAdmin eq '1'||isAdmin eq '2'}">
                                <th>移交给</th>
                            </c:if>
                            <th>内容</th>
                            <th>举报信息补充内容</th>
                            <th>IP来源</th>
                            <th>IP所属城市</th>
                            <th>邮件发送</th>
                            <th style="width:10%">操作</th>
                        </tr>

                        </thead>
                        <tbody>
                        <c:if test="${page.list.size()>0}">
                            <c:forEach items="${page.list}" var="report" varStatus="vs">
                                <tr>
                                    <td align="center">
                                        <c:if test="${report.supplementGroup eq '3437402691677202102'}">集团本部</c:if>
                                        <c:if test="${report.supplementGroup eq '3510129313047280678'}">区域集团</c:if>
                                        <c:if test="${report.supplementGroup eq '3565898923067676254'}">服务集团</c:if>
                                        <c:if test="${report.supplementGroup eq '3806696792996264972'}">文化集团</c:if>
                                        <c:if test="${report.supplementGroup eq '3770618512934949260'}">文旅集团</c:if>
                                        <c:if test="${report.supplementGroup eq null}">--</c:if>
                                    </td>

                                    <td align="center">${report.supplementArea}</td>

                                    <td align="center">${report.supplementType}</td>
                                    <td align="center">${report.supplementCategory}</td>

                                    <td align="center">${report.reportProject}</td>
                                    <td align="center">${report.oaname}</td>
                                    <td align="center">${report.reportPersonName}</td>
                                    <td align="center">${report.reportPersonTel}</td>
                                    <td align="center"><c:if test="${report.reportSource eq 'web'}">官网</c:if>
                                        <c:if test="${report.reportSource eq 'oa'}">融创OA系统</c:if>
                                        <c:if test="${report.reportSource eq 'supplier'}">供应商系统</c:if>
                                        <c:if test="${report.reportSource eq 'wechat'}">微信公众号</c:if>
                                        <c:if test="${report.reportSource eq 'sunacE'}">融E</c:if>
                                        <c:if test="${report.reportSource eq 'offline'}">线下扫码</c:if>
                                        <c:if test="${report.reportSource eq 'tel'}">电话</c:if>
                                        <c:if test="${report.reportSource eq 'email'}">邮件</c:if>
                                        <c:if test="${report.reportSource eq 'visit'}">来访</c:if>
                                        <c:if test="${report.reportSource eq null}">--</c:if></td>

                                    <td align="center">
                                        <c:if test="${report.supplementInformant eq null}">--</c:if>
                                        <c:if test="${report.supplementInformant ne null}">${report.supplementInformant}</c:if>
                                    </td>
                                    <td align="center">${report.reportTime}</td>
                                    <td align="center">
                                        <c:if test="${report.reportStatus eq '0'}">未处理</c:if>
                                        <c:if test="${report.reportStatus eq '1'}">跟踪中</c:if>
                                        <c:if test="${report.reportStatus eq '2'}">已处理</c:if>
                                        <c:if test="${report.reportStatus eq '3'}">已关闭</c:if>
                                        <c:if test="${report.reportStatus eq '4'}">待处理</c:if>
                                    </td>
                                    <td align="center">
                                        <c:if test="${report.dealResult eq null}">--</c:if>
                                        <c:if test="${report.dealResult eq '1'}">移交客诉</c:if>
                                        <c:if test="${report.dealResult eq '2'}">举报无效</c:if>
                                        <c:if test="${report.dealResult eq '3'}">举报受理</c:if>
                                        <c:if test="${report.dealResult eq '4'}">举报属实</c:if>
                                        <c:if test="${report.dealResult eq '5'}">举报不实</c:if>
                                        <c:if test="${report.dealResult eq '6'}">移交其他部门</c:if>
                                        <c:if test="${report.dealResult eq '7'}">转为线索</c:if>
                                    </td>
                                    <td align="center">
                                        <c:if test="${report.transferGroup eq '3437402691677202102'}">集团本部--${report.transferDepartment}</c:if>
                                        <c:if test="${report.transferGroup eq '3510129313047280678'}">区域集团--${report.transferDepartment}</c:if>
                                        <c:if test="${report.transferGroup eq '3565898923067676254'}">服务集团--${report.transferDepartment}</c:if>
                                        <c:if test="${report.transferGroup eq '3806696792996264972'}">文化集团--${report.transferDepartment}</c:if>
                                        <c:if test="${report.transferGroup eq '3770618512934949260'}">文旅集团--${report.transferDepartment}</c:if>
                                        <c:if test="${report.transferGroup eq null}">--</c:if>
                                        <%--<c:if test="${report.transferDepartment eq null}">--</c:if>
                                        <c:if test="${report.transferDepartment eq '1'}">营销</c:if>
                                        <c:if test="${report.transferDepartment eq '2'}">工程</c:if>
                                        <c:if test="${report.transferDepartment eq '3'}">成本</c:if>
                                        <c:if test="${report.transferDepartment eq '4'}">招采</c:if>
                                        <c:if test="${report.transferDepartment eq '5'}">财务</c:if>
                                        <c:if test="${report.transferDepartment eq '6'}">法务</c:if>
                                        <c:if test="${report.transferDepartment eq '7'}">行政</c:if>
                                        <c:if test="${report.transferDepartment eq '8'}">人力</c:if>
                                        <c:if test="${report.transferDepartment eq '9'}">开发</c:if>
                                        <c:if test="${report.transferDepartment eq '10'}">研发</c:if>
                                        <c:if test="${report.transferDepartment eq '11'}">投资</c:if>
                                        <c:if test="${report.transferDepartment eq '15'}">商业</c:if>
                                        <c:if test="${report.transferDepartment eq '12'}">其他</c:if>
                                        <c:if test="${report.transferDepartment eq '13'}">物业管理</c:if>
                                        <c:if test="${report.transferDepartment eq '14'}">文旅管理</c:if>--%>
                                    </td>
                                    <td align="center">
                                        <c:if test="${report.dealPersonName eq null}">--</c:if>
                                        <c:if test="${report.dealPersonName ne null}">${report.dealPersonName}</c:if>
                                    </td>
                                    <c:if test="${isAdmin eq '1'||isAdmin eq '2'}">
                                        <td align="center">
                                            <c:if test="${report.transferName eq null && report.exchangeType eq null}">--</c:if>
                                            <c:if test="${report.transferName ne null && report.exchangeType ne null}">${report.transferName}</c:if>
                                        </td>
                                    </c:if>

                                    <td align="center" title= ${report.reportContent}>${report.reportContent}</td>
                                    <td align="center"
                                        title= ${report.supplementContent}>${report.supplementContent}</td>
                                    <td align="center">${report.reportIp}</td>
                                    <td align="center">${report.ipCity}</td>
                                    <td align="center">
                                        <c:if test="${report.isSendEmail eq '1'}">是</c:if>
                                        <c:if test="${report.isSendEmail eq null}">否</c:if>
                                    </td>
                                    <td align="center">

                                        <a href="${ctx}/report/view?id=${report.id}">查看</a>
                                        <c:if test="${report.reportStatus eq '1'||report.reportStatus eq '0'}"><a
                                                href="${ctx}/report/track?id=${report.id}">跟踪</a></c:if>
                                        <c:if test="${isAdmin eq '1'}">
                                            <a href="#" onclick="del('${report.id}')">删除</a></c:if>
                                        <a href="#" onclick="openDownloadDialog('${report.id}')">转为文档</a>

                                    </td>
                                </tr>
                            </c:forEach>
                        </c:if>
                        </tbody>
                    </table>
                    <div id="showDiv"
                         style="position: absolute; background-color: white; border: 1px solid black;"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<c:if test="${page.list.size()=='0'}">
<span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
</c:if>
<c:if test="${page.list.size()>0}">
<div class="pagination">${page}</div>
</c:if>

</html>