package com.ejweb.core.security;

import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.digest.DigestUtils;

public class DES3Utils {

//    public static final String ALGORITHM = "DES";
    private static final String Algorithm = "DESede"; // 定义加密算法,可用
                                                      // DES,DESede,Blowfish

    static {

        Security.addProvider(new com.sun.crypto.provider.SunJCE());
    }

    public static String byte2Hex(byte[] arrB) {
        try {
            int iLen = arrB.length;
            StringBuffer sb = new StringBuffer(iLen * 2);// 每个byte用两个字符才能表示，所以字符串的长度是数组长度的两倍
            for (int i = 0; i < iLen; i++) {
                int intTmp = arrB[i];

                while (intTmp < 0) {// 把负数转换为正数
                    intTmp = intTmp + 256;
                }

                if (intTmp < 16) {// 小于0F的数需要在前面补0
                    sb.append("0");
                }
                sb.append(Integer.toString(intTmp, 16));
            }
            return sb.toString();
        } catch (Exception e) {
            // TODO: handle exception
        }
        return null;
    }

    public static byte[] hexStr2ByteArr(String strIn) {
        try {
            byte[] arrB = strIn.getBytes();
            int iLen = arrB.length;
            // 两个字符表示一个字节，所以字节数组长度是字符串长度除以2
            byte[] arrOut = new byte[iLen / 2];
            for (int i = 0; i < iLen; i = i + 2) {
                String strTmp = new String(arrB, i, 2);
                arrOut[i / 2] = (byte) Integer.parseInt(strTmp, 16);
            }
            return arrOut;
        } catch (Exception e) {
            // TODO: handle exception
        }
        return null;
    }

    /**
     * 根据字符串生成密钥字节数组
     * @param key
     * @return
     */
    public static byte[] hex(String key) {
        try {
            String md5   = DigestUtils.md5Hex(key);
            byte[] bkeys = md5.getBytes("UTF-8");
            byte[] enk = new byte[24];
            if(24 > bkeys.length){// 如果temp不够24位，则拷贝temp数组整个长度的内容到key数组中

                System.arraycopy(enk, 0, bkeys, 0, bkeys.length);
            }else{// 如果temp大于24位，则拷贝temp数组24个长度的内容到key数组中

                System.arraycopy(enk, 0, bkeys, 0, 24);
            }
            return enk;
        } catch (Exception e) {
            // TODO: handle exception
//            e.printStackTrace();
        }
        // String key = "test";//关键字
        return null;
    }
    public static String encrypt(String data, String key) {
        try {
            byte[] ened = encrypt(data.getBytes("UTF-8"), key);
            return byte2Hex(ened);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return null;
    }

    public static byte[] encrypt(byte[] data, String key) {
        try {
            // byte[] enk = hex(key);
            // 生成密钥
            SecretKey deskey = new SecretKeySpec(hex(key), Algorithm);
            // 加密
            Cipher c1 = Cipher.getInstance(Algorithm);
            c1.init(Cipher.ENCRYPT_MODE, deskey);
            return c1.doFinal(data);// 在单一方面的加密或解密
        } catch (Exception e) {
            
        }
        return null;
    }

    public static String decrypt(String data, String key) {
        try {
            byte[] ened = hexStr2ByteArr(data);
            return decrypt(ened, key);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return null;
    }

    public static String decrypt(byte[] data, String key) {
        try {
            // 生成密钥
            SecretKey deskey = new SecretKeySpec(hex(key), Algorithm);
            // 解密
            Cipher c1 = Cipher.getInstance(Algorithm);
            c1.init(Cipher.DECRYPT_MODE, deskey);
            byte[] decrypted = c1.doFinal(data);
            return new String(decrypted, "UTF-8");
        } catch (Exception e) {
//            e3.printStackTrace();
        }
        return null;
    }

//    public static void main(String[] args)  {
//
//        byte[] key = new byte[24];
//        System.out.println(key.length);
//        // byte[] ened = encrypt("我是中国人".getBytes(), "123456");
//        // String en = Base64.encode(ened);
//        System.out.println(encrypt("我是中国人", "782790337169117184"));
//        System.out.println(decrypt("9673714901f22508b071ad7813711a29", "782790337169117184"));
//        // System.out.println(decrypt(ened, "123456"));
//    }
}
