package com.ejweb.core.geoip;

import com.alibaba.fastjson.JSON;

/**
 * 
 * 通过IP查询地理信息
 * @team IT Team
 * @author  renmb
 * @version 1.0
 * @time 2016-04-06
 * 
 */
public class Address {
    private String country;
    private String province;
    private String city;
    private String county;
    private String postcode;
    
    public Address(){
        
    }
    public Address(String country, String province, String city, String county, String postcode){
        
        this.country  = country;
        this.province = province;
        this.city     = city;
        this.county   = county;
        this.postcode = postcode;
    }
    public Address(String formated, String postcode) {
        if(formated != null && formated.trim().length() !=0){
            
            String[] regions = formated.trim().split("\\s");
            int length = regions.length;
            this.country = (length > 0 ? regions[0] : null);
            this.province = (length > 1 ? regions[1] : null);
            this.city = (length > 2 ? regions[2] : null);
            this.county = (length > 3 ? regions[3] : null);
        }
        this.postcode = postcode;
    }
    public String getCountry() {
        return country;
    }
    public void setCountry(String country) {
        this.country = country;
    }
    public String getProvince() {
        return province;
    }
    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }
    public void setCity(String city) {
        this.city = city;
    }
    public String getCounty() {
        return county;
    }
    public void setCounty(String county) {
        this.county = county;
    }
    public String getPostcode() {
        return postcode;
    }
    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }
    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
