package com.ejweb.core.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.ejweb.conf.GConstants;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * 
 * 请求接口基本数据
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time 2016-03-10
 *
 */
public class BaseBean {
    @JSONField(deserialize = false, serialize = false)
    public static final String DEL_FLAG_NORMAL = "0";

    // @JSONField(deserialize=false, serialize=false)
    // protected String dbprefix=GConstants.getValue("db.table.prefix", "");//
    // 数据库表前缀

    @JSONField(serialize=false)
    @NotEmpty(message = "appCode不允许为空")
    // @JSONField(name="app_code")
    protected String appCode;

    @JSONField(deserialize = false, serialize = false)
    public String getDbprefix() {
        return GConstants.getValue("db.table.prefix", "");// 数据库表前缀;
    }
    // public void setDbprefix(String dbprefix) {
    // this.dbprefix = dbprefix;
    // }

    @JSONField(deserialize = false, serialize = false)
    public String getDbName() {
        return GConstants.getValue("jdbc.type");
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

}
