<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>问题列表</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
//            addmodel($("#brandId option:selected").val());
/*            if($(".mwd").width()>200){
                $(".mwd").width("200px")
            }*/
            $(".table th, .table td").each(function(){
                var maxwidth = 122;
                if($(this).html().length>maxwidth){
                    $(this).html($(this).html().substring(0,maxwidth));
                    $(this).html($(this).html()+'…');
                }
            })
            $("#btnExport").click(function(){
                top.$.jBox.confirm("确认要导出问题数据吗？","系统提示",function(v,h,f){
                    if(v=="ok"){
                        $("#searchForm").attr("action","${ctx}/ask/exportAsk");
                        $("#searchForm").submit();
                    }
                },{buttonsFocus:1});
                top.$('.jbox-body .jbox-icon').css('top','55px');
            });

            $("#quanxuan").click(function() {
                if (this.checked) {
                    $("input[name='askId']").attr("checked", "checked");
                    var vIds = "";
                    $("input:checked").each(function() {
                        vIds += $(this).attr("value") + ",";
                    });
                    if (vIds.length > 0) {
                        vIds = vIds.substring(0, vIds.length - 1);
                    }
                    console.log(vIds);
                    $("#selectCheckbox").val(vIds);
                } else {
                    $("input[name='askId']").removeAttr("checked");
                }
            });
            $("input[name='askId']").click(function() {
                if (!this.checked) {
                    $("#quanxuan").removeAttr("checked");
                }
            });
            //checkbox选中事件
            $("#contentTable").on("click","tbody input[type='checkbox']",function(){
                var vIds = "";
                $("input:checked").each(function() {
                    vIds += $(this).attr("value") + ",";
                });
                if (vIds.length > 0) {
                    vIds = vIds.substring(0, vIds.length - 1);
                }
                console.log(vIds);
                $("#selectCheckbox").val(vIds);
            });

            $("#companyId").change(function () {
                var id = $(this).val();
                $.ajax({
                    type: "POST",
                    url:"${ctx}/askApi/findByParentId",
                    data:{"parent.id":id},// 你的formid
                    dataType:"json",
                    async: false,
                    error: function(request) {
                        alert("Connection error");
                    },
                    success: function(data) {
                        var list = data.offices;
                        var code = "<option>请选择</option>";
                        for (i = 0; i<list.length; i++) {
                            code = code + "<option value='"+ list[i].id + "'>" + list[i].name+"</option>";
                        }
                        console.log(code);
                        $("#officeId").empty();
                        $("#officeId").append(code);
                        $("#officeLi .select2-chosen").text("请选择");
                    }
                });
            });
        });
        function page(n, s) {
            if (n) $("#pageNo").val(n);
            if (s) $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/ask/list");
            $("#searchForm").submit();
            return false;
        }
        
        function detail(id) {
            $("#askId").val(id);
            $("#searchForm").attr("action", "${ctx}/ask/detail");
            $("#searchForm").submit();
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/ask/list">问题列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="bean" action="${ctx}/ask/list" method="post"
           class="breadcrumb form-search ">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <input id="selectCheckbox" name="askIdStr" type="hidden">
    <input id="askId" name="askId" type="hidden">
    <sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
    <ul class="ul-form">
        <li>
            状态：
            <form:select path="status" htmlEscape="false" class="input-medium">
                <form:option value="3">全部</form:option>
                <form:option value="0">未解决</form:option>
                <form:option value="1">已解决</form:option>
                <form:option value="2">已评价</form:option>
            </form:select>
        </li>
        <li>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <input id="beginDate" name="beginDate" style="width:150px;" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
               value="<fmt:formatDate value="${bean.beginDate}" pattern="yyyy-MM-dd HH:mm:ss"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd 00:00:00',isShowClear:true});"/>
        &nbsp;至&nbsp;
        <input id="endDate" name="endDate" style="width:150px;" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
               value="<fmt:formatDate value="${bean.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd 23:59:59',isShowClear:true});"/>&nbsp;&nbsp;
        </li>
        <li>
            <label>关键词搜索：</label>
            <form:input path="keyword" htmlEscape="false" maxlength="50" placeholder="问题内容/类型"  class="input-medium"/>
        </li>
        <li class="btns">
            &nbsp;&nbsp;
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="搜索" onclick="return page();"/>
            <shiro:hasPermission name="ask:ask:view"><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></shiro:hasPermission>
        </li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th><input type="checkbox" id="quanxuan"></th>
        <th>序号</th>
        <th class="mwd">问题描述</th>
        <th>状态</th>
        <th>提问者</th>
        <th>问题分类</th>
        <th>创建时间</th>
    </thead>
    <tbody>
    <c:if test="${fn:length(page.list) == 0}">
        <tr><td colspan="7" style = "text-align:center; color:red;"><font>暂无数据</font></td></tr>
    </c:if>
    <c:forEach items="${page.list}" var="ask" varStatus="vs">
        <tr>
            <td><input name="askId" class="askClass" type="checkbox" value="${ask.askId}"></td>
            <td>${page.pageSize*(page.pageNo - 1) + vs.count}</td>
            <td class="mwd"><a style="cursor:pointer;" <%--href="${ctx}/ask/detail?askId=${ask.askId}"--%> onclick="detail('${ask.askId}')">
<%--            <c:choose>
                <c:when test="${fn:length(ask.content) > 40}">
                    ${fn:substring(ask.content,0,40)}...
                </c:when>
                <c:otherwise>${ask.content}</c:otherwise>
            </c:choose>--%>
                    ${ask.content}
           </a></td>
            <td>
                <c:if test="${ask.status == 0}"><font color="red">未解决</font></c:if>
                <c:if test="${ask.status == 1}"><font color="green">已解决</font></c:if>
                <c:if test="${ask.status == 2}"><font color="gray">已评价</font></c:if>
            </td>
            <td><c:if test="${not empty ask.office && not empty ask.office.name}">${ask.office.name}&nbsp;|&nbsp;</c:if>${ask.createName}</td>
            <td>${ask.categoryEntity.parent.name}&nbsp;—&nbsp;${ask.categoryEntity.name}</td>
            <td>
                <fmt:formatDate value="${ask.createDate }" pattern="yyyy-MM-dd HH:mm"></fmt:formatDate>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
<font color="red">&nbsp;&nbsp;1.序号列的复选框用于选择性导出，如果不选中，默认导出符合筛选条件的全部数据。</font>
</body>
</html>