/**
 *
 */
package com.ejweb.modules.ueditor.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.baidu.ueditor.core.ActionEnter;
import com.baidu.ueditor.define.ActionMap;
import com.ejweb.conf.GConstants;

/**
 * 百度编辑器文件上传，需要配置
 * /ejweb-manage-3.0/resources/spring-mvc.xml
 * 
 * com.ejweb.core.filter.BaiduCommonsMultipartResolver
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年8月11日
 */
@Controller
@RequestMapping(value="/web/ueditor")
public class UeditorAction {

    @RequestMapping(value="/upload")
    public void upload(HttpServletRequest request, HttpServletResponse response){
        try {  
            request.setCharacterEncoding("utf-8");  
            response.setHeader("Content-Type", "text/html");  
              
            String rootPath = GConstants.FILE_UPLOAD_DIR;//+GConstants.FS+PathFormatUtils.parse(GConstants.PATH_FORMAt);
//            System.out.println("============================================");
//            System.out.println("GConstants.FILE_UPLOAD_DIR rootPath"+rootPath);
//            System.out.println("============================================");
            // 针对配置百度上传附件读取配置文件  
            ActionMap.mapping.put("config", ActionMap.CONFIG);  
            // 上传文件  
            ActionMap.mapping.put("uploadfile", ActionMap.UPLOAD_FILE);  
            ActionEnter actionEnter = new ActionEnter(request, rootPath);  
            response.getWriter().write(actionEnter.exec());
        } catch (Exception e) {  
            e.printStackTrace();
        }
    }
    @RequestMapping(value="/example.html")
    public String example(HttpServletRequest request, HttpServletResponse response){
//        return "ueditor/example";
        
        return "modules/ueditor/example";
    }
    @RequestMapping(value="/uploadimg.html")
    public String uploadimg(HttpServletRequest request, HttpServletResponse response){
//        return "ueditor/example";
        
        return "modules/ueditor/uploadimg";
    }
}
