/*
 * Decompiled with CFR 0.152.
 */
package org.geo.split;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.geo.split.PostfixNode;
import org.geo.split.RegionEntity;
import org.geo.split.RegionLibrary;
import org.geo.split.RegionNode;

public class RegionSplit {
    public static RegionEntity singleton(String key) {
        List<RegionEntity> regions = RegionSplit.accurate(key);
        if (regions == null || regions.size() == 0) {
            regions = RegionSplit.search(key);
        }
        return regions == null || regions.size() == 0 ? null : regions.get(0);
    }

    public static List<RegionEntity> accurate(String key) {
        List<String> items = RegionLibrary.getItems(key);
        if (items == null || items.size() == 0) {
            return null;
        }
        ArrayList<RegionEntity> regions = new ArrayList<RegionEntity>();
        String last = items.get(items.size() - 1);
        RegionNode node = RegionLibrary.get(last);
        if (node == null) {
            return null;
        }
        if (node.getSuffixes().size() == 1) {
            RegionEntity region = RegionLibrary.full(node, node.getSuffixes().get(0));
            region.setLevel(node.getSuffixes().get(0).getLevel());
            region.setParent(node.getSuffixes().get(0).getParent());
            regions.add(region);
            return regions;
        }
        boolean isCountry = items.size() == 1;
        for (PostfixNode suffix : node.getSuffixes()) {
            int times = 0;
            RegionEntity region = RegionLibrary.full(node, suffix);
            region.setLevel(suffix.getLevel());
            region.setParent(suffix.getParent());
            isCountry = isCountry ? suffix.getLevel() == 0 : isCountry;
            String[] nodes = region.getRegion().split("\\s");
            String[] param = last.split("\\s");
            boolean isFullMatch = Integer.parseInt(param[1]) == 1;
            boolean isMatch = false;
            if (nodes[nodes.length - 1].equals(param[0])) {
                times = times + 2 + param[0].length();
                isMatch = true;
            } else if (isFullMatch && nodes[nodes.length - 1].equals(param[0])) {
                times = times + 2 + param[0].length();
                isMatch = true;
            } else {
                if (isFullMatch || !nodes[nodes.length - 1].startsWith(param[0])) continue;
                times = times + 1 + param[0].length();
                isMatch = true;
            }
            HashSet<String> temp = new HashSet<String>();
            String[] stringArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                String reg = stringArray[n2];
                temp.add(reg);
                temp.add(reg.substring(0, 2));
                ++n2;
            }
            int i = 0;
            int len = items.size() - 1;
            while (i < len) {
                block16: {
                    try {
                        param = items.get(i).split("\\s");
                        boolean bl = isFullMatch = Integer.parseInt(param[1]) == 1;
                        if (isFullMatch && temp.contains(param[0])) {
                            times = times + 2 + param[0].length();
                            isMatch = true;
                            break block16;
                        }
                        if (temp.contains(param[0])) {
                            times = times + 1 + param[0].length();
                            isMatch = true;
                            break block16;
                        }
                        isMatch = false;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (!isMatch) continue;
            region.setWeight(times);
            regions.add(region);
        }
        if (isCountry) {
            for (RegionEntity region : regions) {
                String[] param = items.get(0).split("\\s");
                if (!region.getRegion().equals(param[0])) continue;
                regions.clear();
                regions.add(region);
                return regions;
            }
        }
        Collections.sort(regions, new Comparator<RegionEntity>(){

            @Override
            public int compare(RegionEntity a, RegionEntity b) {
                return b.getWeight() - a.getWeight();
            }
        });
        return regions;
    }

    public static List<RegionEntity> accurate1(String key) {
        if (RegionLibrary.isEmtpy(key) || key.length() < 2) {
            return null;
        }
        int start = 0;
        int klen = key.length();
        ArrayList<RegionEntity> regions = new ArrayList<RegionEntity>();
        RegionNode node = RegionLibrary.get(key);
        HashMap<Integer, String> iterms = new HashMap<Integer, String>();
        HashSet<String> terms = new HashSet<String>();
        String last = "";
        while (true) {
            String postfix;
            int maxlen = 2;
            int endIndex = start + maxlen;
            if (start >= klen) break;
            if (endIndex > klen) {
                endIndex = klen;
            }
            if ((node = RegionLibrary.get(postfix = key.substring(start, endIndex))) == null) {
                ++start;
                continue;
            }
            last = node.getRegionPrefix();
            for (PostfixNode suffix : node.getSuffixes()) {
                RegionEntity region = RegionLibrary.full(node, suffix);
                region.setLevel(suffix.getLevel());
                region.setParent(suffix.getParent());
                String reg = String.valueOf(node.getRegionPrefix()) + suffix.getPostfix();
                if (start + reg.length() <= klen && reg.equals(postfix = key.substring(start, start + reg.length()))) {
                    maxlen = reg.length();
                    iterms.put(region.getLevel(), reg);
                    region.setMatch(true);
                    last = reg;
                }
                terms.add(node.getRegionPrefix());
                regions.add(region);
            }
            start += maxlen;
        }
        if (regions.size() <= 1) {
            System.out.println("iterms:" + terms);
            return regions;
        }
        int i = 0;
        int len = regions.size();
        while (i < len) {
            RegionEntity region = (RegionEntity)regions.get(i);
            String[] nodes = region.getRegion().split("\\s");
            int times = 0;
            int j = 0;
            int l = nodes.length;
            while (j < l) {
                if (nodes[l - 1].startsWith(last)) {
                    if (terms.contains(nodes[j]) && terms.contains(nodes[j].subSequence(0, 2))) {
                        terms.remove(nodes[j].subSequence(0, 2));
                        ++times;
                    } else if (region.isMatch() && nodes[j].equals(iterms.get(j))) {
                        ++times;
                    } else if (terms.contains(nodes[j]) || terms.contains(nodes[j].subSequence(0, 2))) {
                        ++times;
                    }
                }
                ++j;
            }
            if (times >= terms.size()) {
                region.setWeight(times);
            } else {
                regions.remove(i);
                len = regions.size();
                --i;
            }
            ++i;
        }
        System.out.println("iterms:" + terms);
        Collections.sort(regions, new Comparator<RegionEntity>(){

            @Override
            public int compare(RegionEntity a, RegionEntity b) {
                return b.getWeight() - a.getWeight();
            }
        });
        return regions;
    }

    public static List<RegionEntity> list(String key) {
        if (RegionLibrary.isEmtpy(key) || key.length() < 2) {
            return null;
        }
        int start = 0;
        int klen = key.length();
        ArrayList<RegionEntity> regions = new ArrayList<RegionEntity>();
        RegionNode node = RegionLibrary.get(key);
        while (true) {
            String postfix;
            int endIndex = start + 2;
            if (start >= klen) break;
            if (endIndex > klen) {
                endIndex = klen;
            }
            if ((node = RegionLibrary.get(postfix = key.substring(start, endIndex))) == null) {
                ++start;
                continue;
            }
            for (PostfixNode suffix : node.getSuffixes()) {
                RegionEntity region = new RegionEntity(String.valueOf(node.getRegionPrefix()) + suffix.getPostfix(), suffix.getPostcode());
                region.setLevel(suffix.getLevel());
                region.setParent(suffix.getParent());
                regions.add(region);
            }
            start = endIndex;
        }
        return regions;
    }

    public static List<RegionEntity> full(String key) {
        if (RegionLibrary.isEmtpy(key) || key.length() < 2) {
            return null;
        }
        int start = 0;
        int klen = key.length();
        ArrayList<RegionEntity> regions = new ArrayList<RegionEntity>();
        RegionNode node = RegionLibrary.get(key);
        while (true) {
            String postfix;
            int endIndex = start + 2;
            if (start >= klen) break;
            if (endIndex > klen) {
                endIndex = klen;
            }
            if ((node = RegionLibrary.get(postfix = key.substring(start, endIndex))) == null) {
                ++start;
                continue;
            }
            for (PostfixNode suffix : node.getSuffixes()) {
                RegionEntity region = RegionLibrary.full(node, suffix);
                region.setLevel(suffix.getLevel());
                region.setParent(suffix.getParent());
                regions.add(region);
            }
            start = endIndex;
        }
        return regions;
    }

    public static List<RegionEntity> search(String key) {
        if (RegionLibrary.isEmtpy(key) || key.length() < 2) {
            return null;
        }
        int start = 0;
        int klen = key.length();
        ArrayList<RegionEntity> regions = new ArrayList<RegionEntity>();
        RegionNode node = null;
        HashSet<String> terms = new HashSet<String>();
        while (true) {
            String postfix;
            int maxlen = 2;
            int endIndex = start + 2;
            if (start >= klen) break;
            if (endIndex > klen) {
                endIndex = klen;
            }
            if ((node = RegionLibrary.get(postfix = key.substring(start, endIndex))) == null) {
                ++start;
                continue;
            }
            for (PostfixNode suffix : node.getSuffixes()) {
                RegionEntity region = RegionLibrary.full(node, suffix);
                regions.add(region);
                String reg = String.valueOf(node.getRegionPrefix()) + suffix.getPostfix();
                if (start + reg.length() <= klen) {
                    postfix = key.substring(start, start + reg.length());
                    if (reg.equals(postfix)) {
                        maxlen = reg.length();
                        terms.add(reg);
                        continue;
                    }
                    terms.add(node.getRegionPrefix());
                    continue;
                }
                terms.add(node.getRegionPrefix());
            }
            start += maxlen;
        }
        int i = 0;
        int len = regions.size();
        while (i < len) {
            RegionEntity region = (RegionEntity)regions.get(i);
            String[] nodes = region.getRegion().split("\\s");
            int times = 0;
            String[] stringArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                String reg = stringArray[n2];
                if (terms.contains(reg) || terms.contains(reg.subSequence(0, 2))) {
                    ++times;
                }
                ++n2;
            }
            region.setWeight(times);
            ++i;
        }
        Collections.sort(regions, new Comparator<RegionEntity>(){

            @Override
            public int compare(RegionEntity a, RegionEntity b) {
                return b.getWeight() - a.getWeight();
            }
        });
        return regions;
    }
}

