/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.web;

import com.alibaba.fastjson.JSONObject;
import com.ejweb.core.base.BaseController;
import com.ejweb.core.persistence.Page;

import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.report.entity.CtBbtcBusCategory;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.entity.CtBbtcRegion;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.service.CtBbtcBusCategoryService;
import com.ejweb.modules.report.service.CtBbtcBusTypeService;
import com.ejweb.modules.report.service.CtBbtcRegionService;
import com.ejweb.modules.report.service.ReportService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * 业务类别Controller
 * @author haoqm
 * @version 2019-07-12
 */
@Controller
@RequestMapping(value = "${adminPath}/report/ctBbtcBusCategory")
public class CtBbtcBusCategoryController extends BaseController {
	/**
	 * 管理基础路径
	 */
	@Value("${adminPath}")
	protected String adminPath;
	@Autowired
	private CtBbtcBusCategoryService ctBbtcBusCategoryService;
	@Autowired
	private CtBbtcBusTypeService ctBbtcBusTypeService;

	@Autowired
	private CtBbtcRegionService ctBbtcRegionService;

	@Autowired
	private   ReportService reportService;
	
	@ModelAttribute
	public CtBbtcBusCategory get(@RequestParam(required=false) String id) {
		CtBbtcBusCategory entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ctBbtcBusCategoryService.get(id);
		}
		if (entity == null){
			entity = new CtBbtcBusCategory();
		}
		return entity;
	}

	/**
	 * 跟据类型type多值查询对应的类别
	 * @param typeId
	 * @param redirectAttributes
	 * @param response
	 */
	@RequestMapping(value = "getBusCategoryList")
	public void getBusCategoryList(String typeId, RedirectAttributes redirectAttributes,HttpServletResponse response){
		if(typeId != null && !"".equals(typeId)){
			JSONObject res = new JSONObject();
			String[] typeIds = typeId.split(",");
			List<CtBbtcBusCategory> ctBbtcBusCategoryList=new ArrayList<CtBbtcBusCategory>();

			/*遍历typeIds  查询多个集合   将集合拼接*/
			for (String  type:typeIds) {
				if(type!= null && !"".equals(type)){
					ctBbtcBusCategoryList.addAll(ctBbtcBusCategoryService.getByTpyeId(type));
				}
			}
			System.out.println("最终集合大小："+ctBbtcBusCategoryList.size()+"===============================");
			res.put("ctBbtcBusCategoryList", ctBbtcBusCategoryList);
			String jsonStr = res.toJSONString();
			try{
				PrintWriter out = response.getWriter();
				out.print(jsonStr);
				out.close();
			}catch (Exception e){
				e.printStackTrace();
			}
		}

	}
	
	@RequiresPermissions("report:ctBbtcBusCategory:view")
	@RequestMapping(value = {"list", ""})
	public String list(CtBbtcBusCategory ctBbtcBusCategory, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<CtBbtcBusCategory> page = ctBbtcBusCategoryService.findPage(new Page<CtBbtcBusCategory>(request, response), ctBbtcBusCategory); 
		model.addAttribute("page", page);

		/*回显查询条件*/
		if(StringUtils.isNotBlank(ctBbtcBusCategory.getSupplementArea())){
			CtBbtcRegion ctBbtcRegion = ctBbtcRegionService.get(ctBbtcBusCategory.getSupplementArea());
			ctBbtcBusCategory.setSupplementArea(ctBbtcRegion.getName());
		}
		if(StringUtils.isNotBlank(ctBbtcBusCategory.getTypeName())){
			CtBbtcBusType ctBbtcBusType = ctBbtcBusTypeService.get(ctBbtcBusCategory.getTypeName());
			ctBbtcBusCategory.setTypeName(ctBbtcBusType.getName());
		}

		model.addAttribute("ctBbtcBusCategory", ctBbtcBusCategory);
		return "modules/report/ctBbtcBusCategoryList";
	}

	@RequiresPermissions("report:ctBbtcBusCategory:view")
	@RequestMapping(value = "form")
	public String form(CtBbtcBusCategory ctBbtcBusCategory, Model model) {
		List<CtBbtcBusType> ctBbtcBusTypeList = ctBbtcBusTypeService.findList(null);
		if(ctBbtcBusCategory.getId() != null){
			CtBbtcBusCategory ctBbtcBusCategory1 = ctBbtcBusCategoryService.get(ctBbtcBusCategory.getId());
			if(ctBbtcBusCategory1 !=null){
				ctBbtcBusCategory.setType(ctBbtcBusCategory1.getType());
				ctBbtcBusCategory.setTypeName(ctBbtcBusCategory1.getTypeName());
				ctBbtcBusCategory.setSupplementArea(ctBbtcBusCategory1.getSupplementArea());
			}
		}
		model.addAttribute("ctBbtcBusTypeList", ctBbtcBusTypeList);
		model.addAttribute("ctBbtcBusCategory", ctBbtcBusCategory);
		return "modules/report/ctBbtcBusCategoryForm";
	}

	@RequiresPermissions("report:ctBbtcBusCategory:edit")
	@RequestMapping(value = "save")
	public String save(CtBbtcBusCategory ctBbtcBusCategory, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ctBbtcBusCategory)){
			return form(ctBbtcBusCategory, model);
		}
		ctBbtcBusCategoryService.save(ctBbtcBusCategory);
		addMessage(redirectAttributes, "保存业务类别成功");
		return "redirect:"+adminPath+"/report/ctBbtcBusCategory/?repage";
	}
	
	@RequiresPermissions("report:ctBbtcBusCategory:edit")
	@RequestMapping(value = "delete")
	public String delete(CtBbtcBusCategory ctBbtcBusCategory, RedirectAttributes redirectAttributes) {

		/*如果信息已在举报中存在  则不删除*/
		if(checkIsExist(ctBbtcBusCategory)){
			addMessage(redirectAttributes, "删除业务类别不成功，举报信息已存在");
			return "redirect:"+adminPath+"/report/ctBbtcBusCategory/?repage";
		}

		ctBbtcBusCategoryService.delete(ctBbtcBusCategory);
		addMessage(redirectAttributes, "删除业务类别成功");
		return "redirect:"+adminPath+"/report/ctBbtcBusCategory/?repage";
	}

	/**
	 * 校验  区域是否在举报信息中出现过
	 * @return true 出现过   false  未出现过
	 */
	public   boolean checkIsExist(CtBbtcBusCategory ctBbtcBusCategory){

		ReportEntity reportEntity=new ReportEntity();

		//如果id不为空    跟据id去查询列表
		if(StringUtils.isNotBlank(ctBbtcBusCategory.getId())){
			reportEntity.setSupplementCategory(ctBbtcBusCategory.getId());
			List<ReportEntity> reportList = reportService.getReportListByCheck(reportEntity);
			if(reportList.size()>0){
				return  true;
			}else{
				return  false;
			}
		}
		return false;
	}

}