/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nlpcn.commons.lang.util.FileIterator;
import org.nlpcn.commons.lang.util.ReflectUtil;

public class IOUtil {
    public static final String UTF8 = "utf-8";
    public static final String GBK = "gbk";
    public static final String TABLE = "\t";
    public static final String LINE = "\n";
    public static final byte[] TABBYTE = "\t".getBytes();
    public static final byte[] LINEBYTE = "\n".getBytes();

    public static InputStream getInputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(String path, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.getReader(new File(path), charEncoding);
    }

    private static BufferedReader getReader(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        return new BufferedReader(new InputStreamReader((InputStream)is, charEncoding));
    }

    public static RandomAccessFile getRandomAccessFile(String path, String charEncoding) throws FileNotFoundException {
        InputStream is = IOUtil.getInputStream(path);
        if (is != null) {
            return new RandomAccessFile(new File(path), "r");
        }
        return null;
    }

    public static void Writer(String path, String charEncoding, String content) {
        block7: {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(path));
                ((OutputStream)fos).write(content.getBytes(charEncoding));
                fos.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                IOUtil.close(fos);
                break block7;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.close(fos);
                }
            }
            IOUtil.close(fos);
        }
    }

    public static BufferedReader getReader(InputStream inputStream, String charEncoding) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(inputStream, charEncoding));
    }

    public static String getContent(String path, String charEncoding) {
        return IOUtil.getContent(new File(path), charEncoding);
    }

    public static String getContent(InputStream is, String charEncoding) {
        BufferedReader reader = null;
        try {
            reader = IOUtil.getReader(is, charEncoding);
            String string = IOUtil.getContent(reader);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String getContent(File file, String charEncoding) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtil.getContent(is, charEncoding);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String getContent(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        while ((temp = reader.readLine()) != null) {
            sb.append(temp);
            sb.append(LINE);
        }
        return sb.toString();
    }

    public static void WriterObj(String path, Serializable hm) throws FileNotFoundException, IOException {
        try (ObjectOutputStream objectOutputStream = null;){
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(path));
            objectOutputStream.writeObject(hm);
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FileIterator instanceFileIterator(String path, String charEncoding) {
        try {
            return new FileIterator(path, charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <K, V> HashMap<K, V> loadMap(String path, String charEncoding, Class<K> key, Class<V> value) throws UnsupportedEncodingException {
        HashMap<Object, Object> hm = null;
        try (FileIterator iteartor = null;){
            iteartor = IOUtil.instanceFileIterator(path, charEncoding);
            hm = new HashMap<Object, Object>();
            String[] split = null;
            while (iteartor.hasNext()) {
                String readLine = iteartor.next();
                split = readLine.split(TABLE);
                hm.put(ReflectUtil.conversion(split[0], key), ReflectUtil.conversion(split[1], value));
            }
        }
        return hm;
    }

    public static <K, V> void writeMap(Map<K, V> hm, String path, String charEncoding) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = hm.entrySet().iterator();
        Map.Entry<K, V> next = null;
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(path);
            while (iterator.hasNext()) {
                next = iterator.next();
                fos.write(next.getKey().toString().getBytes());
                fos.write(TABBYTE);
                fos.write(next.getValue().toString().getBytes());
                fos.write(LINEBYTE);
            }
            fos.flush();
        }
    }

    public static List<String> readFile2List(String path, String charEncoding) throws UnsupportedEncodingException, FileNotFoundException {
        return IOUtil.readFile2List(IOUtil.getReader(path, charEncoding));
    }

    public static List<String> readFile2List(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.readFile2List(IOUtil.getReader(file, charEncoding));
    }

    public static List<String> readFile2List(BufferedReader br) {
        ArrayList<String> all = new ArrayList<String>();
        String temp = null;
        try {
            try {
                while ((temp = br.readLine()) != null) {
                    all.add(temp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return all;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HashMap loadMap = IOUtil.loadMap("/Users/ansj/git/ansj_seg/library/userLibrary/userLibrary.dic", UTF8, null, null);
        System.out.println(loadMap.get("\u6dd8\u5b9d"));
    }
}

