/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleTypeBLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = -2311211431562030662L;
    static int fixedDataSize = 86;
    transient OracleConnection connection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:54:26_PST_2006";

    protected OracleTypeBLOB() {
    }

    public OracleTypeBLOB(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BLOB bLOB = null;
        if (object != null) {
            if (object instanceof BLOB) {
                bLOB = (BLOB)object;
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return bLOB;
    }

    public int getTypeCode() {
        return 2004;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec(this, this.nullOffset, this.ldsOffset, unpickleContext, n, n2, fixedDataSize);
    }

    protected static Object lobUnpickle80rec(OracleType oracleType, int n, int n2, UnpickleContext unpickleContext, int n3, int n4, int n5) throws SQLException {
        switch (n3) {
            case 1: {
                if (unpickleContext.isNull(n)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[n2]);
                if (n4 == 9) {
                    unpickleContext.skipBytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.readPtrBytes();
                unpickleContext.reset();
                return oracleType.toObject(byArray, n4, null);
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) == 1) {
                    unpickleContext.skipPtrBytes();
                    return null;
                }
            }
            case 3: {
                long l = unpickleContext.offset() + n5;
                if (n4 == 9) {
                    unpickleContext.skipTo(l);
                    return null;
                }
                byte[] byArray = unpickleContext.readPtrBytes();
                if ((long)unpickleContext.offset() < l) {
                    unpickleContext.skipTo(l);
                }
                return oracleType.toObject(byArray, n4, null);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n3);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: 
            case 2: {
                return this.connection.createBlob(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }
}

