<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>区域基础资料管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/report/ctBbtcRegion/">区域基础资料列表</a></li>
		<shiro:hasPermission name="report:ctBbtcRegion:edit"><li><a href="${ctx}/report/ctBbtcRegion/form">区域基础资料添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="ctBbtcRegion" action="${ctx}/report/ctBbtcRegion/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>所属集团：</label>
				<form:select onchange="resetPageNo();" path="group" class="input-xlarge required" cssStyle="width: 230px">
					<form:option value="">请选择</form:option>
					<form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
								  htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>区域名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>区域编码</th>
				<th>区域名称</th>
				<th>所属集团</th>
				<shiro:hasPermission name="report:ctBbtcRegion:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ctBbtcRegion">
			<tr>
				<td><a href="${ctx}/report/ctBbtcRegion/form?id=${ctBbtcRegion.id}">
					${ctBbtcRegion.number}
				</a></td>
				<td>
					${ctBbtcRegion.name}
				</td>
				<td>
					${ctBbtcRegion.groupName}
				</td>
				<shiro:hasPermission name="report:ctBbtcRegion:edit"><td>
    				<a href="${ctx}/report/ctBbtcRegion/form?id=${ctBbtcRegion.id}">修改</a>
					<a href="${ctx}/report/ctBbtcRegion/delete?id=${ctBbtcRegion.id}" onclick="return confirmx('确认要删除该区域基础资料吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>