<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>问题列表</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#grandCategoryId").change(function () {
                var id = $(this).val();
                $.ajax({
                    type: "POST",
                    url:"${ctx}/faqApi/findByParentId",
                    data:{"parent.id":id},// 你的formid
                    dataType:"json",
                    async: false,
                    error: function(request) {
                        alert("Connection error");
                    },
                    success: function(data) {
                        var list = data.categoryEntities;
                        var code = "<option>请选择</option>";
                        for (i = 0; i<list.length; i++) {
                            code = code + "<option value='"+ list[i].id + "'>" + list[i].name+"</option>";
                        }
                        console.log(code);
                        $("#categoryId").empty();
                        $("#categoryId").append(code);
                        $("#parentLi .select2-chosen").text("请选择");
                    }
                });
            });
        });
        function page(n, s) {
            if (n) $("#pageNo").val(n);
            if (s) $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/faq/list");
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/faq/list">常见问题列表</a></li>
    <shiro:hasPermission name="faq:faq:edit"><li><a href="${ctx}/faq/form">常见问题添加</a></li></shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="entity" action="${ctx}/faq/list" method="post"
           class="breadcrumb form-search ">
    <form:input path="pageNo" type="hidden"/>
    <form:input path="pageSize" type="hidden"/>
    <sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
    <ul class="ul-form">
        <li>
            一级分类：
            <form:select path="grandCategoryId"  htmlEscape="false" class="input-medium">
                <form:option class="company" value="">请选择</form:option>
                <c:forEach items="${grandParent}" var="grandParent">
                    <form:option class="grandParent" value="${grandParent.id}">${grandParent.name}</form:option>
                </c:forEach>
            </form:select>
        </li>
        <li id="parentLi">
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            二级分类：
            <form:select path="categoryId" htmlEscape="false" class="input-medium">
                <form:option value="">请选择</form:option>
                <c:forEach items="${parent}" var="parent">
                    <form:option value="${parent.id}">${parent.name}</form:option>
                </c:forEach>
            </form:select>
        </li>
        <li>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label>关键词搜索：</label>
            <form:input path="keyword" htmlEscape="false" maxlength="50" placeholder="问题标题/类型"  class="input-medium"/>
        </li>
        <li class="btns">
            &nbsp;&nbsp;
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="搜索" onclick="return page();"/>
        </li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>序号</th>
        <th>问题标题</th>
        <th>问题分类</th>
        <th>创建时间</th>
        <shiro:hasPermission name="faq:faq:edit">
            <th>操作</th>
        </shiro:hasPermission></tr>
    </thead>
    <tbody>
    <c:if test="${fn:length(entity.page.list) == 0}">
        <shiro:hasPermission name="faq:faq:edit">
        <tr><td colspan="5" style = "text-align:center; color:red;"><font>暂无数据</font></td></tr>
        </shiro:hasPermission>
        <shiro:lacksPermission name="faq:faq:edit">
            <tr><td colspan="4" style = "text-align:center; color:red;"><font>暂无数据</font></td></tr>
        </shiro:lacksPermission>
    </c:if>
    <c:forEach items="${entity.page.list}" var="faq" varStatus="vs">
        <tr>
            <td>${entity.page.pageSize*(entity.page.pageNo - 1) + vs.count}</td>
            <td><a href="${faq.href}" target="_blank">${faq.title}</a></td>
            <td>${faq.categoryEntity.parent.name}&nbsp;—&nbsp;${faq.categoryEntity.name}</td>
            <td>
                <fmt:formatDate value="${faq.createDate}" pattern="yyyy-MM-dd HH:mm"></fmt:formatDate>
            </td>
            <shiro:hasPermission name="faq:faq:view">
                <td>
                    <%--<a href="${ctx}/faq/detail?faqId=${faq.faqId}">查看</a>--%>
                        <%--<a href="${faq.href}" target="_blank">查看</a>--%>
                    <shiro:hasPermission name="faq:faq:edit">
                        <a href="${ctx}/faq/form?faqId=${faq.faqId}">修改</a>
                        <a href="${ctx}/faq/delete?faqId=${faq.faqId}" onclick="return confirmx('确认要删除该问题吗？', this.href)">删除</a>
                    </shiro:hasPermission>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<sys:message content="${message}" />
<div class="pagination">${entity.page}</div>
</body>
</html>