package com.ejweb.modules.report.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.core.utils.IdGen;
import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.front.report.entity.IP2Regions;
import com.ejweb.modules.front.report.utils.IpUtils;
import com.ejweb.modules.report.dao.CtBbtcBusCategoryDao;
import com.ejweb.modules.report.dao.CtBbtcBusTypeDao;
import com.ejweb.modules.report.dao.CtBbtcRegionDao;
import com.ejweb.modules.report.dao.ReportDao;
import com.ejweb.modules.report.entity.*;
import com.ejweb.modules.sys.dao.RoleDao;
import com.ejweb.modules.sys.entity.Office;
import com.ejweb.modules.sys.entity.Position;
import com.ejweb.modules.sys.entity.Role;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.sys.utils.UserUtils;
import com.ejweb.modules.workbench.entity.ReportNotice;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 举报Service
 *
 * @author lixy
 * @version 2017-09-06
 */
@Service
@Transactional(readOnly = true)
public class ReportService extends CrudService<ReportDao, ReportEntity> {

    @Autowired
    private ReportDao reportDao;

    @Autowired
    private RoleDao roleDao;

    @Autowired
    private CtBbtcBusTypeDao  ctBbtcBusTypeDao;

    @Autowired
    private CtBbtcBusCategoryDao ctBbtcBusCategoryDao;

    @Autowired
    private CtBbtcRegionDao ctBbtcRegionDao;

    protected static Logger logger = LoggerFactory.getLogger(ReportService.class);

    /**
     * 查询附件
     *
     * @param reportAttachmentEntity
     * @return
     */
    public List<ReportAttachmentEntity> getAttachmentInfo(ReportAttachmentEntity reportAttachmentEntity) {
        return reportDao.getAttachmentInfo(reportAttachmentEntity);
    }

    /**
     * 查询用户角色
     *
     * @param user
     * @return
     */
    public String findRole(User user) {
        return reportDao.findRole(user);
    }

    /**
     * 新增举报
     *
     * @param reportEntity
     */
    @Transactional(readOnly = false)
    public void saveReport(ReportEntity reportEntity, HttpServletRequest request) {
        //保存举报信息
        reportEntity.preInsert();
        //保存填写人信息
        User user = UserUtils.getUser();
        String oaname = user.getName();
        reportEntity.setOaname(oaname);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String reportTime = sdf.format(reportEntity.getCreateDate());
        reportEntity.setReportTime(reportTime);
        reportEntity.setReportStatus("0");
        reportEntity.setExchangeBeforeUser(reportEntity.getCreateBy().getId());
        if (!this.checkRole(user).equals("1")) {
            reportEntity.setExchangeAfterUser(reportEntity.getCreateBy().getId());
        }
        String ip = user.getLoginIp();
        int port = request.getRemotePort();//返回发出请求的客户机的端口号。
//        logger.info("port："+port);
//        ip = "183.129.142.154";&ip=" + ip
        String url = "http://pv.sohu.com/cityjson?ie=utf-8";
        String ipResult = IpUtils.getURLContent(url).replace(";", "");
        if (StringUtils.isNotBlank(ipResult)) {

            // String[] ipCity = ipResult.split("=");
            JSONObject json = JSON.parseObject(ipResult.split("=")[1]);
            String city = json.getString("cname");
            reportEntity.setIpCity(city);


        }
        reportEntity.setReportIp(ip);
        dao.addReport(reportEntity);

        if (StringUtils.isNotBlank(reportEntity.getReportAttachment())) {
            String[] reportAttachmentList = new String[]{reportEntity.getReportAttachment()};
            if (reportEntity.getReportAttachment().contains("|")) {
                reportAttachmentList = reportEntity.getReportAttachment().split("\\|");
            }
            for (String path : reportAttachmentList) {
                if (StringUtils.isNotBlank(path)) {
                    //保存举报提交附件信息
                    ReportAttachmentEntity reportAttachmentEntity = new ReportAttachmentEntity();
                    reportAttachmentEntity.setId(IdGen.uuid());
                    reportAttachmentEntity.setReportId(reportEntity.getId());
                    //获取文件名
                    String fileName = this.getFilename(path);
                    if (StringUtils.isNotBlank(fileName)) {
                        reportAttachmentEntity.setAttachmentName(fileName);
                    }
                    int index = path.lastIndexOf("/") + 1;
                    path = path.substring(0, index) + fileName;
                    reportAttachmentEntity.setAttachmentPath(path);
                    File file = new File(reportAttachmentEntity.getAttachmentPath());
                    long length = file.length();
                    reportAttachmentEntity.setAttachmentType("0");
                    reportDao.addReportAttachment(reportAttachmentEntity);
                }
            }
        }
    }

    /**
     * 举报补充
     *
     * @param reportEntity
     */
    @Transactional(readOnly = false)
    public void saveTrack(ReportEntity reportEntity, String transferUser) {
        //保存举报补充信息
        reportEntity.preUpdate();
        User user = UserUtils.getUser();
        System.out.println(transferUser+"===============================");
        if (StringUtils.isNotBlank(transferUser)) {
            reportEntity.setExchangeType("1");
            reportEntity.setExchangeAfterUser(transferUser);
        }

        /*判断处理结论是否为转为线索   记录转为线索时间*/
        if(reportEntity.getDealResult().equals("7")){
            Date transTime =new Date();   /* transTime   转为线索的时间   */
            reportEntity.setTransTime(transTime);
            System.out.println(reportEntity.getSupplementTitle()+"==转为线索时间："+new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(transTime));
        }

        dao.addTrack(reportEntity);

        if (StringUtils.isNotBlank(reportEntity.getSupplementAttachment())) {
            String[] supplementAttachmentList = new String[]{reportEntity.getSupplementAttachment()};
            if (reportEntity.getSupplementAttachment().contains("|")) {
                supplementAttachmentList = reportEntity.getSupplementAttachment().split("\\|");
            }
            for (String path : supplementAttachmentList) {
                if (StringUtils.isNotBlank(path)) {
                    //保存补充提交附件信息
                    ReportAttachmentEntity reportAttachmentEntity = reportAttachmentEntity = new ReportAttachmentEntity();
                    reportAttachmentEntity.setId(IdGen.uuid());
                    reportAttachmentEntity.setReportId(reportEntity.getId());
                    //获取文件名
                    String fileName = this.getFilename(path);
                    if (StringUtils.isNotBlank(fileName)) {
                        reportAttachmentEntity.setAttachmentName(fileName);
                    }
                    int index = path.lastIndexOf("/") + 1;
                    path = path.substring(0, index) + fileName;
                    reportAttachmentEntity.setAttachmentPath(path);
                    File file = new File(reportAttachmentEntity.getAttachmentPath());
                    long length = file.length();
                    reportAttachmentEntity.setAttachmentType("1");
                    reportDao.addReportAttachment(reportAttachmentEntity);
                }
            }
        }

        if (StringUtils.isNotBlank(reportEntity.getDealAttachment())) {
            String[] dealAttachmentList = new String[]{reportEntity.getDealAttachment()};
            if (reportEntity.getDealAttachment().contains("|")) {
                dealAttachmentList = reportEntity.getDealAttachment().split("\\|");
            }
            for (String path : dealAttachmentList) {
                if (StringUtils.isNotBlank(path)) {
                    //保存处理结果附件信息
                    ReportAttachmentEntity reportAttachmentEntity = reportAttachmentEntity = new ReportAttachmentEntity();
                    reportAttachmentEntity.setId(IdGen.uuid());
                    reportAttachmentEntity.setReportId(reportEntity.getId());
                    //获取文件名
                    String fileName = this.getFilename(path);
                    if (StringUtils.isNotBlank(fileName)) {
                        reportAttachmentEntity.setAttachmentName(fileName);
                    }
                    int index = path.lastIndexOf("/") + 1;
                    path = path.substring(0, index) + fileName;
                    reportAttachmentEntity.setAttachmentPath(path);
                    File file = new File(reportAttachmentEntity.getAttachmentPath());
                    long length = file.length();
                    reportAttachmentEntity.setAttachmentType("2");
                    reportDao.addReportAttachment(reportAttachmentEntity);
                }
            }
        }
        reportDao.updateReportStatus(reportEntity);
    }

    public String getFilename(String path) {
        int beginIndex = path.lastIndexOf("/") + 1;
        int endIndex = path.lastIndexOf(".");
        String fileNameUrlCode = path.substring(beginIndex, endIndex);
        String prefixName = path.substring(endIndex, path.length());
        try {
            String utlToName = URLDecoder.decode(fileNameUrlCode, "UTF-8");
            String fileName = utlToName + prefixName;
            return fileName;
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 查询用户
     *
     * @param user
     * @return
     */
    public Page<User> findUserPage(Page<User> page, User user) {
        page.setFuncParam("1");//标记为用户分页
        user.setPage(page);
        page.setList(reportDao.findUser(user));
        return page;
    }

    /**
     * 查询公司列表
     *
     * @return
     */
    public List<Office> getCompanyList() {
        return reportDao.getCompanyList();
    }

    /**
     * 查询部门列表
     *
     * @return
     */
    public List<Office> getOfficeList(Office office) {
        return reportDao.getOfficeList(office);
    }

    /**
     * 查询职位列表
     *
     * @return
     */
    public List<Position> getPositionList() {
        return reportDao.getPositionList();
    }

    /**
     * 管理员移交后发送消息
     *
     * @param reportEntity
     * @return
     */
    @Transactional(readOnly = false)
    public int addNotice(ReportEntity reportEntity, String flag, String ifDone) {
        User user = UserUtils.getUser();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ReportNotice reportNotice = reportDao.findReportNotice(reportEntity);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy年MM月dd日");
        String dateStr = sdf1.format(date);
        if (reportNotice != null) {
            //消息表中已存在该条举报的移交信息,更新该记录
            if (StringUtils.isNotBlank(user.getId())) {
                reportNotice.setUpdateBy(user.getId());
            }
            reportNotice.setUpdateDate(date);
            String sendTime = sdf.format(date);
            reportNotice.setSendTime(sendTime);
            reportNotice.setSendFromId(user.getId());
            reportNotice.setSendToId(reportEntity.getExchangeAfterUser());
            reportNotice.setStatus("0");
            if (flag.equals("answer")) {
                //当前只有杨杨是系统管理员，处理后消息发给杨杨，以后如果新增了系统管理员需修改
                //findAdmin（）方法获取所有系统管理员
//                reportNotice.setSendToId("8434980248282724540228");
                reportNotice.setSendToId("8434980248282724540228");
                reportNotice.setTitle("“" + reportEntity.getSupplementTitle() + "”已由" + user.getName() + "于" + dateStr + "处理完成");
            }
            if (flag.equals("meanWhile")) {
                reportNotice.setTitle("“" + reportEntity.getSupplementTitle() + "”已由" + user.getName() + "于" + dateStr + "处理完成");
                //没点完成，title为请处理
                if (StringUtils.isBlank(ifDone)) {
                    reportNotice.setTitle("请处理-“" + reportEntity.getSupplementTitle() + "”");
                }
            }
            reportDao.updateReportNotice(reportNotice);
//            if (updateCheckRole(reportEntity.getExchangeBeforeUser()).equals("辅助管理员")){
//                reportNotice.setSendToId(reportEntity.getExchangeBeforeUser());
//                reportDao.updateReportNotice(reportNotice);
//            }
            return 1;
        } else {
            //消息表中不存在该条举报的信息，新增记录
            reportNotice = new ReportNotice();
            reportNotice.setId(IdGen.uuid());
            reportNotice.setReportId(reportEntity.getId());
            reportNotice.setCreateDate(date);
            reportNotice.setUpdateDate(date);
            String sendTime = sdf.format(date);
            reportNotice.setSendTime(sendTime);
            reportNotice.setSendFromId(user.getId());
            reportNotice.setStatus("0");
            reportNotice.setCreateBy(user.getId());
            reportNotice.setUpdateBy(user.getId());
            if (flag.equals("answer")) {
                return 0;
            } else if (flag.equals("meanWhile")) {
                reportNotice.setSendToId(reportEntity.getExchangeAfterUser());
                reportNotice.setTitle("“" + reportEntity.getSupplementTitle() + "”已由" + user.getName() + "于" + dateStr + "处理完成");
                //没点完成，title为请处理
                if (StringUtils.isBlank(ifDone)) {
                    reportNotice.setTitle("请处理-“" + reportEntity.getSupplementTitle() + "”");
                }
            } else {
                //管理员转交或移交，消息标题为“请处理xxx”
                String title = reportEntity.getSupplementTitle();
                if (StringUtils.isBlank(reportEntity.getSupplementTitle())) {
                    title = reportEntity.getReportProject();
                }
                reportNotice.setTitle("请处理-“" + title + "”");
                reportNotice.setSendToId(reportEntity.getExchangeAfterUser());
            }
            reportDao.addReportNotice(reportNotice);
            return 1;
        }
    }

    /**
     * 新增移交/转交记录
     *
     * @param reportEntity
     * @return
     */
    @Transactional(readOnly = false)
    public void addRecord(ReportEntity reportEntity, String exchangeType) {
        ReportExchangeHistory reportExchangeHistory = new ReportExchangeHistory();
        reportExchangeHistory.setId(IdGen.uuid());
        reportExchangeHistory.setReportId(reportEntity.getId());
        reportExchangeHistory.setOldUserId(reportEntity.getExchangeBeforeUser());
        reportExchangeHistory.setNewUserId(reportEntity.getExchangeAfterUser());
        reportExchangeHistory.setExchangeType(exchangeType);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        reportExchangeHistory.setExchangeTime(sdf.format(date));
        reportDao.addRecord(reportExchangeHistory);
    }

    public List<ReportEntity> getReportListByCheck(ReportEntity reportEntity) {
        List<ReportEntity> reportList = dao.findListByCheck(reportEntity);
        return reportList;
    }


    /**
     * 查询集团举报列表
     *
     * @param reportEntity
     * @return
     */
    public List<ReportEntity> getReportList(ReportEntity reportEntity) {
        List<ReportEntity> reportList = dao.findList(reportEntity);
        String exchangeAfterUser = "";
        for (ReportEntity report : reportList) {
            exchangeAfterUser = reportDao.selectExchangeAfterUser(report.getExchangeAfterUser());
            report.setTransferName(exchangeAfterUser);

            /*封装转换集团信息*/
           /* String supplementGroup = report.getSupplementGroup();*/
         /*   if(StringUtils.isNoneBlank(supplementGroup)){
               if("3437402691677202102".equals(supplementGroup)){
                   report.setSupplementGroup("集团本部");
               }else if("3510129313047280678".equals(supplementGroup)){
                   report.setSupplementGroup("区域集团");
               }else if("3565898923067676254".equals(supplementGroup)){
                   report.setSupplementGroup("服务集团");
               }else if("3806696792996264972".equals(supplementGroup)){
                   report.setSupplementGroup("文化集团");
               }else if("3770618512934949260".equals(supplementGroup)){
                   report.setSupplementGroup("文旅集团");
               }

            }else{
                report.setSupplementGroup("--");
            }*/


            /*封装拼接移交部门信息*/
            if(StringUtils.isNotBlank(report.getTransferGroup()) && StringUtils.isNotBlank(report.getTransferArea()) && StringUtils.isNotBlank(report.getTransferDepartment())){
                report.setTransferDepartment(report.getTransferGroup()+"--"+report.getTransferArea()+"--"+report.getTransferDepartment());
            }else{
                report.setTransferDepartment("--");
            }

           /* String transferGroup = report.getTransferGroup();
            if(StringUtils.isNoneBlank(transferGroup)){
                if("3437402691677202102".equals(transferGroup)){
                    report.setTransferDepartment("集团本部--"+report.getTransferDepartment());
                }else if("3510129313047280678".equals(transferGroup)){
                    report.setTransferDepartment("区域集团--"+report.getTransferDepartment());
                }else if("3565898923067676254".equals(transferGroup)){
                    report.setTransferDepartment("服务集团--"+report.getTransferDepartment());
                }else if("3806696792996264972".equals(transferGroup)){
                    report.setTransferDepartment("文化集团--"+report.getTransferDepartment());
                }else if("3770618512934949260".equals(transferGroup)){
                    report.setTransferDepartment("文旅集团--"+report.getTransferDepartment());
                }

            }else{
                report.setTransferDepartment("--");
            }*/

            /*封装类型  类别数据*/
            String  SupplementTypeStr="";
            String  SupplementCategoryStr="";
            /*遍历集合*/

            if(StringUtils.isNoneBlank(report.getSupplementType())){
                String[] getSupplementTypeStr = report.getSupplementType().split(",");
                for (String str:getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = ctBbtcBusTypeDao.get(str);
                    if(ctBbtcBusType!=null){
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    }else{
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                report.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if(StringUtils.isNoneBlank(report.getSupplementCategory())){
                String[] getSupplementCategory = report.getSupplementCategory().split(",");
                for (String str:getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryDao.get(str);
                    if(ctBbtcBusCategory!=null){
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    }else{
                        SupplementCategoryStr = SupplementCategoryStr + "--";
                    }
                }
                report.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }





         /*   //移交部门
            String TransferDepartment = report.getTransferDepartment();
            if (StringUtils.isNoneBlank(report.getTransferDepartment())) {
                if (TransferDepartment.equals("1")) {
                    TransferDepartment = "营销";
                } else if (TransferDepartment.equals("2")) {
                    TransferDepartment = "工程";
                } else if (TransferDepartment.equals("3")) {
                    TransferDepartment = "成本";
                } else if (TransferDepartment.equals("4")) {
                    TransferDepartment = "招采";
                } else if (TransferDepartment.equals("5")) {
                    TransferDepartment = "财务";
                } else if (TransferDepartment.equals("6")) {
                    TransferDepartment = "法务";
                } else if (TransferDepartment.equals("7")) {
                    TransferDepartment = "行政";
                } else if (TransferDepartment.equals("8")) {
                    TransferDepartment = "人力";
                } else if (TransferDepartment.equals("9")) {
                    TransferDepartment = "开发";
                } else if (TransferDepartment.equals("10")) {
                    TransferDepartment = "研发";
                } else if (TransferDepartment.equals("11")) {
                    TransferDepartment = "投资";
                }   else if (TransferDepartment.equals("15")) {
                    TransferDepartment = "商业";
                } else if (TransferDepartment.equals("12")) {
                    TransferDepartment = "其他";
                } else if (TransferDepartment.equals("13")) {
                    TransferDepartment = "物业管理";
                } else if (TransferDepartment.equals("14")) {
                    TransferDepartment = "文旅管理";
                }
            } else {
                TransferDepartment = "";
            }
            report.setTransferDepartment(TransferDepartment);*/

            //举报途径
            String reportSource = report.getReportSource();
            if (StringUtils.isNotBlank(reportSource)) {
                if (reportSource.equals("oa")) {
                    reportSource = "融创OA系统";
                } else if (reportSource.equals("supplier")) {
                    reportSource = "供应商系统";
                } else if (reportSource.equals("wechat")) {
                    reportSource = "微信公众号";
                } else if (reportSource.equals("sunacE")) {
                    reportSource = "融E";
                } else if (reportSource.equals("offline")) {
                    reportSource = "线下扫码";
                } else if (reportSource.equals("tel")) {
                    reportSource = "电话";
                } else if (reportSource.equals("email")) {
                    reportSource = "邮件";
                } else if (reportSource.equals("visit")) {
                    reportSource = "来访";
                }
            } else {
                reportSource = "";
            }
            report.setReportSource(reportSource);

            //状态
            String reportStatus = report.getReportStatus();
            if (StringUtils.isNotBlank(reportStatus)) {
                if (reportStatus.equals("0")) {
                    reportStatus = "未处理";
                } else if (reportStatus.equals("1")) {
                    reportStatus = "跟踪中";
                } else if (reportStatus.equals("2")) {
                    reportStatus = "已处理";
                } else if (reportStatus.equals("3")) {
                    reportStatus = "已关闭";
                }
            } else {
                reportStatus = "";
            }
            report.setReportStatus(reportStatus);
            String dealResult = report.getDealResult();
            if (StringUtils.isNotBlank(dealResult)) {
                if (dealResult.equals("1")) {
                    dealResult = "移交客诉";
                } else if (dealResult.equals("2")) {
                    dealResult = "举报无效";
                } else if (dealResult.equals("3")) {
                    dealResult = "举报受理";
                } else if (dealResult.equals("4")) {
                    dealResult = "举报属实";
                } else if (dealResult.equals("5")) {
                    dealResult = "举报不实";
                } else if (dealResult.equals("6")) {
                    dealResult = "移交其他部门";
                } else if (dealResult.equals("7")) {
                    dealResult = "转为线索";
                }

            } else {
                dealResult = "--";
            }


            report.setDealResult(dealResult);

          /*  String supplementArea = report.getSupplementArea();
            if (StringUtils.isNotBlank(supplementArea)) {
                if (supplementArea.equals("North China")) {
                    supplementArea = "华北区域公司";
                } else if (supplementArea.equals("BeiJing")) {
                    supplementArea = "北京区域公司";
                } else if (supplementArea.equals("ShangHai")) {
                    supplementArea = "上海区域公司";
                } else if (supplementArea.equals("SouthWest")) {
                    supplementArea = "西南区域公司";
                } else if (supplementArea.equals("SouthEast")) {
                    supplementArea = "东南区域公司";
                } else if (supplementArea.equals("Central China")) {
                    supplementArea = "华中区域公司";
                } else if (supplementArea.equals("GuangShen")) {
                    supplementArea = "广深区域公司";
                } else if (supplementArea.equals("Hainan")) {
                    supplementArea = "海南区域公司";
                } else if (supplementArea.equals("Group")) {
                    supplementArea = "集团本部";
                }
            } else {
                supplementArea = "--";
            }
            report.setSupplementArea(supplementArea);*/

            report.setSupplementInformant(report.getSupplementInformant() == null ? "--" : report.getSupplementInformant());
            report.setDealPersonName(report.getDealPersonName() == null ? "--" : report.getDealPersonName());
            User user = UserUtils.getUser();
            if (this.checkRole(user).equals("1")) {
                if (StringUtils.isBlank(report.getTransferName()) || StringUtils.isBlank(report.getExchangeType())) {
                    report.setTransferName("--");
                } else if (StringUtils.isNotBlank(report.getTransferName()) && StringUtils.isNotBlank(report.getExchangeType())) {
                    report.setTransferName(report.getTransferName());
                }
            } else {
                report.setTransferName("");
            }

            report.setReportIp(report.getReportIp() == null ? "--" : report.getReportIp());
            report.setIpCity(report.getIpCity() == null ? "--" : report.getIpCity());
            String isSendEmail = report.getIsSendEmail();
            if (StringUtils.isNotBlank(isSendEmail)) {
                if (isSendEmail.equals("1")) {
                    isSendEmail = "是";
                }
            } else {
                isSendEmail = "否";
            }
            report.setIsSendEmail(isSendEmail);
        }

        return reportList;
    }

    /**
     * 查询区域举报列表
     *
     * @param reportEntity
     * @return
     */
    public List<ReportEntity> getReportQyList(ReportEntity reportEntity) {
        List<ReportEntity> reportList = reportDao.findQyList(reportEntity);
        String exchangeAfterUser = "";
        for (ReportEntity report : reportList) {
            exchangeAfterUser = reportDao.selectExchangeAfterUser(report.getExchangeAfterUser());
            report.setTransferName(exchangeAfterUser);

            /*封装转换集团信息*/
          /*  String supplementGroup = report.getSupplementGroup();
            if(StringUtils.isNoneBlank(supplementGroup)){
                if("3437402691677202102".equals(supplementGroup)){
                    report.setSupplementGroup("集团本部");
                }else if("3510129313047280678".equals(supplementGroup)){
                    report.setSupplementGroup("区域集团");
                }else if("3565898923067676254".equals(supplementGroup)){
                    report.setSupplementGroup("服务集团");
                }else if("3806696792996264972".equals(supplementGroup)){
                    report.setSupplementGroup("文化集团");
                }else if("3770618512934949260".equals(supplementGroup)){
                    report.setSupplementGroup("文旅集团");
                }

            }else{
                report.setSupplementGroup("--");
            }*/

            /*封装拼接移交部门信息*/
            if(StringUtils.isNotBlank(report.getTransferGroup()) && StringUtils.isNotBlank(report.getTransferArea()) && StringUtils.isNotBlank(report.getTransferDepartment())){
                report.setTransferDepartment(report.getTransferGroup()+"--"+report.getTransferArea()+"--"+report.getTransferDepartment());
            }else{
                report.setTransferDepartment("--");
            }


          /*  String transferGroup = report.getTransferGroup();
            if(StringUtils.isNoneBlank(transferGroup)){
                if("3437402691677202102".equals(transferGroup)){
                    report.setTransferDepartment("集团本部--"+report.getTransferDepartment());
                }else if("3510129313047280678".equals(transferGroup)){
                    report.setTransferDepartment("区域集团--"+report.getTransferDepartment());
                }else if("3565898923067676254".equals(transferGroup)){
                    report.setTransferDepartment("服务集团--"+report.getTransferDepartment());
                }else if("3806696792996264972".equals(transferGroup)){
                    report.setTransferDepartment("文化集团--"+report.getTransferDepartment());
                }else if("3770618512934949260".equals(transferGroup)){
                    report.setTransferDepartment("文旅集团--"+report.getTransferDepartment());
                }

            }else{
                report.setTransferDepartment("--");
            }*/


            /*封装类型  类别数据*/
            String  SupplementTypeStr="";
            String  SupplementCategoryStr="";
            /*遍历集合*/

            if(StringUtils.isNoneBlank(report.getSupplementType())){
                String[] getSupplementTypeStr = report.getSupplementType().split(",");
                for (String str:getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = ctBbtcBusTypeDao.get(str);
                    if(ctBbtcBusType!=null){
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    }else{
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                report.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if(StringUtils.isNoneBlank(report.getSupplementCategory())){
                String[] getSupplementCategory = report.getSupplementCategory().split(",");
                for (String str:getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryDao.get(str);
                    if(ctBbtcBusCategory!=null){
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    }else{
                        SupplementCategoryStr = SupplementCategoryStr + "--,";
                    }
                }
                report.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }




           /* //移交部门
            String TransferDepartment = report.getTransferDepartment();
            if (StringUtils.isNoneBlank(report.getTransferDepartment())) {
                if (TransferDepartment.equals("1")) {
                    TransferDepartment = "营销";
                } else if (TransferDepartment.equals("2")) {
                    TransferDepartment = "工程";
                } else if (TransferDepartment.equals("3")) {
                    TransferDepartment = "成本";
                } else if (TransferDepartment.equals("4")) {
                    TransferDepartment = "招采";
                } else if (TransferDepartment.equals("5")) {
                    TransferDepartment = "财务";
                } else if (TransferDepartment.equals("6")) {
                    TransferDepartment = "法务";
                } else if (TransferDepartment.equals("7")) {
                    TransferDepartment = "行政";
                } else if (TransferDepartment.equals("8")) {
                    TransferDepartment = "人力";
                } else if (TransferDepartment.equals("9")) {
                    TransferDepartment = "开发";
                } else if (TransferDepartment.equals("10")) {
                    TransferDepartment = "研发";
                } else if (TransferDepartment.equals("11")) {
                    TransferDepartment = "投资";
                }else if (TransferDepartment.equals("15")) {
                    TransferDepartment = "商业";
                } else if (TransferDepartment.equals("12")) {
                    TransferDepartment = "其他";
                } else if (TransferDepartment.equals("13")) {
                    TransferDepartment = "物业管理";
                } else if (TransferDepartment.equals("14")) {
                    TransferDepartment = "文旅管理";
                }
            } else {
                TransferDepartment = "";
            }
            report.setTransferDepartment(TransferDepartment);*/

            //举报途径
            String reportSource = report.getReportSource();
            if (StringUtils.isNotBlank(reportSource)) {
                if (reportSource.equals("oa")) {
                    reportSource = "融创OA系统";
                } else if (reportSource.equals("supplier")) {
                    reportSource = "供应商系统";
                } else if (reportSource.equals("wechat")) {
                    reportSource = "微信公众号";
                } else if (reportSource.equals("sunacE")) {
                    reportSource = "融E";
                } else if (reportSource.equals("offline")) {
                    reportSource = "线下扫码";
                } else if (reportSource.equals("tel")) {
                    reportSource = "电话";
                } else if (reportSource.equals("email")) {
                    reportSource = "邮件";
                } else if (reportSource.equals("visit")) {
                    reportSource = "来访";
                }
            } else {
                reportSource = "";
            }
            report.setReportSource(reportSource);
            //状态
            String reportStatus = report.getReportStatus();
            if (StringUtils.isNotBlank(reportStatus)) {
                if (reportStatus.equals("0")) {
                    reportStatus = "未处理";
                } else if (reportStatus.equals("1")) {
                    reportStatus = "跟踪中";
                } else if (reportStatus.equals("2")) {
                    reportStatus = "已处理";
                } else if (reportStatus.equals("3")) {
                    reportStatus = "已关闭";
                }
            } else {
                reportStatus = "";
            }
            report.setReportStatus(reportStatus);
            String dealResult = report.getDealResult();
            if (StringUtils.isNotBlank(dealResult)) {
                if (dealResult.equals("1")) {
                    dealResult = "移交客诉";
                } else if (dealResult.equals("2")) {
                    dealResult = "举报无效";
                } else if (dealResult.equals("3")) {
                    dealResult = "举报受理";
                } else if (dealResult.equals("4")) {
                    dealResult = "举报属实";
                } else if (dealResult.equals("5")) {
                    dealResult = "举报不实";
                } else if (dealResult.equals("6")) {
                    dealResult = "移交其他部门";
                } else if (dealResult.equals("7")) {
                    dealResult = "转为线索";
                }

            } else {
                dealResult = "--";
            }
            report.setDealResult(dealResult);
           /* String supplementArea = report.getSupplementArea();
            if (StringUtils.isNotBlank(supplementArea)) {
                if (supplementArea.equals("North China")) {
                    supplementArea = "华北区域公司";
                } else if (supplementArea.equals("BeiJing")) {
                    supplementArea = "北京区域公司";
                } else if (supplementArea.equals("ShangHai")) {
                    supplementArea = "上海区域公司";
                } else if (supplementArea.equals("SouthWest")) {
                    supplementArea = "西南区域公司";
                } else if (supplementArea.equals("SouthEast")) {
                    supplementArea = "东南区域公司";
                } else if (supplementArea.equals("Central China")) {
                    supplementArea = "华中区域公司";
                } else if (supplementArea.equals("GuangShen")) {
                    supplementArea = "广深区域公司";
                } else if (supplementArea.equals("Hainan")) {
                    supplementArea = "海南区域公司";
                } else if (supplementArea.equals("Group")) {
                    supplementArea = "集团本部";
                }
            } else {
                supplementArea = "--";
            }
            report.setSupplementArea(supplementArea);*/

            report.setSupplementInformant(report.getSupplementInformant() == null ? "--" : report.getSupplementInformant());
            report.setDealPersonName(report.getDealPersonName() == null ? "--" : report.getDealPersonName());
            User user = UserUtils.getUser();
            if (this.checkRole(user).equals("1")) {
                if (StringUtils.isBlank(report.getTransferName()) || StringUtils.isBlank(report.getExchangeType())) {
                    report.setTransferName("--");
                } else if (StringUtils.isNotBlank(report.getTransferName()) && StringUtils.isNotBlank(report.getExchangeType())) {
                    report.setTransferName(report.getTransferName());
                }
            } else {
                report.setTransferName("");
            }
            report.setReportIp(report.getReportIp() == null ? "--" : report.getReportIp());
            report.setIpCity(report.getIpCity() == null ? "--" : report.getIpCity());
            String isSendEmail = report.getIsSendEmail();
            if (StringUtils.isNotBlank(isSendEmail)) {
                if (isSendEmail.equals("1")) {
                    isSendEmail = "是";
                }
            } else {
                isSendEmail = "否";
            }
            report.setIsSendEmail(isSendEmail);


        }
        return reportList;
    }

    /**
     * 查询举报列表
     *
     * @param reportEntity
     * @return
     */
    public Page<ReportEntity> getChooseReportPage(Page<ReportEntity> page, ReportEntity reportEntity) {
        reportEntity.setPage(page);
        page.setList(reportDao.getChooseReportList(reportEntity));
        return page;
    }

    /**
     * 转交举报
     *
     * @param reportIds
     * @param userId
     * @return
     */
    @Transactional(readOnly = false)
    public void deliverReport(String[] reportIds, String userId) {
        User user = UserUtils.getUser();
        for (String reportId : reportIds) {
            ReportEntity reportEntity = dao.get(reportId);
            reportEntity.setExchangeAfterUser(userId);
            reportEntity.setExchangeType("2");
            reportEntity.setUpdateBy(user);
            reportEntity.setUpdateDate(new Date());
            reportDao.updateExchangeUser(reportEntity);
            this.addNotice(reportEntity, "deliver", null);
            this.addRecord(reportEntity, "2");
        }
    }

    /**
     * 判断当前用户角色 1管理员 2辅助管理员
     *
     * @param user
     * @return
     */
    public String checkRole(User user) {
        String roleNum = "";
        Role roleEntity = new Role();
        roleEntity.setUser(user);
        List<Role> roleList = roleDao.findList(roleEntity);
        if (roleList != null && roleList.size() != 0) {
            for (Role role : roleList) {
                if (role.getName().equals("系统管理员")) {
                    roleNum = "1";
                    break;
                } else if (role.getName().equals("辅助管理员")) {
                    roleNum = "2";
                    break;
                }

            }
        }
        return roleNum;
    }

    /**
     * 判断当前用户角色 1管理员 2辅助管理员
     *
     * @param
     * @return
     */
    public String updateCheckRole(String transferUser) {
        String roleName = "";
        User user = UserUtils.get(transferUser);
        Role roleEntity = new Role();
        roleEntity.setUser(user);
        List<Role> roleList = roleDao.findList(roleEntity);
        if (roleList != null && roleList.size() != 0) {
            for (Role role : roleList) {
                if (role.getName().equals("辅助管理员")) {
                    roleName = "辅助管理员";
                    break;
                }
            }
        }
        return roleName;
    }

    public String findExchangeUser(String id) {
        return reportDao.findExchangeUser(id);
    }

    /**
     * 记录发邮件
     *
     * @param reportId
     * @return
     */
    @Transactional(readOnly = false)
    public int updateIsSendEmail(String reportId) {
        return reportDao.updateIsSendEmail(reportId);
    }

    /**
     * 管理员修改处理结论
     *
     * @return
     */
    @Transactional(readOnly = false)
    public int updateConclusion(ReportEntity reportEntity) {
        return reportDao.updateConclusion(reportEntity);
    }

    /**
     * 删除举报信息
     *
     * @return
     */
    @Transactional(readOnly = false)
    public int deleteConclusion(ReportEntity reportEntity) {
        reportDao.deleteNotice(reportEntity);
        return reportDao.deleteConclusion(reportEntity);
    }

    /**
     * 重新跟踪
     * @param reportEntity
     * @return
     */
    @Transactional(readOnly = false)
    public int againUpdateConclusion(ReportEntity reportEntity) {
        return reportDao.againUpdateConclusion(reportEntity);
    }

    /**
     * 转为线索
     *
     * @param reportEntity
     * @return
     */
    @Transactional(readOnly = false)
    public int cluesUpdateConclusion(ReportEntity reportEntity) {
        return reportDao.cluesUpdateConclusion(reportEntity);
    }

    /**
     * 区域查询列表
     *
     * @param page
     * @param reportEntity
     * @return
     */
    public Page<ReportEntity> findQyList(Page<ReportEntity> page, ReportEntity reportEntity) {
        reportEntity.setPage(page);
     /*
     * *//*查询出区域列表所有集团 id  封装到reportEntity实体内*//*
        List<CtBbtcRegion> allList = ctBbtcRegionDao.findAllList();
        System.out.println("区域总数:=========="+allList.size());
        reportEntity.setRegionList(allList);
        */
        page.setList(reportDao.findQyList(reportEntity));
        return page;
    }


}
