package com.ejweb.modules.workbench.service;

import com.ejweb.core.service.CrudService;
import com.ejweb.core.utils.DateUtils;
import com.ejweb.modules.report.dao.ReportDao;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.workbench.Bean.WorkbenchBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

/**
 * Created by mengxy on 2017/9/11.
 */
@Service
public class WorkbenchService extends CrudService<ReportDao, ReportEntity> {

    @Autowired
    private ReportDao reportDao;

    public WorkbenchBean getWorkbench(WorkbenchBean workbench) throws Exception {
//        WorkbenchBean workbench = new WorkbenchBean();
        if (StringUtils.isBlank(workbench.getStartDate()) && StringUtils.isBlank(workbench.getEndDate())) {
            workbench.setEndDate(DateUtils.getDate());
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c = Calendar.getInstance();
            c.setTime(df.parse(workbench.getEndDate()));
            c.set(Calendar.DATE, c.get(Calendar.DATE) - 30);
            String startDate = df.format(c.getTime());
            workbench.setStartDate(startDate);
        } else if (StringUtils.isNotBlank(workbench.getStartDate()) && StringUtils.isBlank(workbench.getEndDate())) {
            workbench.setEndDate(DateUtils.getDate());
        } else if (StringUtils.isBlank(workbench.getStartDate()) && StringUtils.isNotBlank(workbench.getEndDate())) {
            workbench.setStartDate("2017-09-12");
        }
        workbench.setTotalCount(reportDao.getTotalNum(workbench));
        List<HashMap> results = reportDao.getReportResult(workbench);
        //举报结果
        for (HashMap res : results) {
            if (StringUtils.isNotBlank((String) res.get("DEAL_RESULT"))) {
                if ("1".equals((String) res.get("DEAL_RESULT"))) {
                    //移交客诉
                    workbench.setComplainNum(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("2".equals((String) res.get("DEAL_RESULT"))) {
                    //举报无效
                    workbench.setInvalid(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("3".equals((String) res.get("DEAL_RESULT"))) {
                    //举报受理
                    workbench.setVerified(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("4".equals((String) res.get("DEAL_RESULT"))) {
                    //举报属实
                    workbench.setConfirmed(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("5".equals((String) res.get("DEAL_RESULT"))) {
                    //举报不实
                    workbench.setUnreaListic(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("6".equals((String) res.get("DEAL_RESULT"))) {
                    //移交其他部门
                    workbench.setTransfer(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                } else if ("7".equals((String) res.get("DEAL_RESULT"))) {
                    //转为线索
                    workbench.setClue(Integer.valueOf(String.valueOf(res.get("COUNT(DEAL_RESULT)"))));
                }
            }

        }
        workbench.setRepResultTotal(workbench.getComplainNum() + workbench.getInvalid() + workbench.getVerified() + workbench.getConfirmed() + workbench.getUnreaListic() + workbench.getTransfer());
        workbench.setUnsettled(workbench.getTotalCount() - workbench.getRepResultTotal());
        List<HashMap> statusList = reportDao.getReportStatus(workbench);
        //举报状态
        for (HashMap status : statusList) {
         /*   System.out.println(status.get("report_status")+"==================================");
            System.out.println(status.get("COUNT(report_status)")+"==================================");*/
            if (StringUtils.isNotBlank((String) status.get("REPORT_STATUS"))) {
                if ("1".equals(String.valueOf(status.get("REPORT_STATUS")))) {
                    //处理中
                    workbench.setProcessing(Integer.valueOf(String.valueOf(status.get("COUNT(REPORT_STATUS)"))));
                } else if ("2".equals(String.valueOf(status.get("REPORT_STATUS")))) {
                    //已处理
                    workbench.setProcessed(Integer.valueOf(String.valueOf(status.get("COUNT(REPORT_STATUS)"))));
                } else if ("0".equals(String.valueOf(status.get("REPORT_STATUS")))) {
                    //未处理
                    workbench.setUnProcess(Integer.valueOf(String.valueOf(status.get("COUNT(REPORT_STATUS)"))));
                } else if ("3".equals(String.valueOf(status.get("REPORT_STATUS")))) {
                    //已关闭
                    workbench.setClosed(Integer.valueOf(String.valueOf(status.get("COUNT(REPORT_STATUS)"))));
                }
            }
        }
        workbench.setRepStatusTotal(workbench.getUnProcess() + workbench.getProcessing() + workbench.getProcessed() + workbench.getClosed());

        List<HashMap> types = reportDao.getReportType(workbench);
        for (HashMap type : types) {
            //营销
            Object sale = type.get("sale");
            workbench.setSale(Integer.valueOf(sale.toString()));
            //工程
            Object project = type.get("project");
            workbench.setProject(Integer.valueOf(project.toString()));
            //成本
            Object cost = type.get("cost");
            workbench.setCost(Integer.valueOf(cost.toString()));
            //招采
            Object forMining = type.get("forMining");
            workbench.setForMining(Integer.valueOf(forMining.toString()));
            //财务
            Object finance = type.get("finance");
            workbench.setFinance(Integer.valueOf(finance.toString()));
            //法务
            Object forensic = type.get("forensic");
            workbench.setForensic(Integer.valueOf(forensic.toString()));
            //行政
            Object administration = type.get("administration");
            workbench.setAdministration(Integer.valueOf(administration.toString()));
            //人力
            Object manpower = type.get("manpower");
            workbench.setManpower(Integer.valueOf(manpower.toString()));
            //开发
            Object development = type.get("development");
            workbench.setDevelopment(Integer.valueOf(development.toString()));
            //研发
            Object rAndD = type.get("rAndD");
            workbench.setrAndD(Integer.valueOf(rAndD.toString()));
            //投资
            Object iAndD = type.get("iAndD");
            workbench.setiAndD(Integer.valueOf(iAndD.toString()));
            //其他
            Object Other = type.get("Other");
            workbench.setOther(Integer.valueOf(Other.toString()));
            //物业管理
            Object propertyManagement = type.get("propertyManagement");
            workbench.setPropertyManagement(Integer.valueOf(propertyManagement.toString()));
            //酒店管理
            Object hotelManagement = type.get("hotelManagement");
            workbench.setHotelManagement(Integer.valueOf(hotelManagement.toString()));
            //商业管理
            Object syManagement = type.get("businessManagement");
            workbench.setBusinessManagement(Integer.valueOf(syManagement.toString()));
        }
        List<HashMap> totals = reportDao.getTotal(workbench);
        for (HashMap total : totals) {
            if (StringUtils.isNotBlank((String) total.get("report_source"))) {
                if ("web".equals((String) total.get("report_source"))) {
                    //官网
                    workbench.setWeb(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("oa".contains((String) total.get("report_source"))) {
                    //融创oa
                    workbench.setOa(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("supplier".equals(String.valueOf(total.get("report_source")))) {
                    //供应商
                    workbench.setSupplier(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("wechat".equals(String.valueOf(total.get("report_source")))) {
                    //微信公众号
                    workbench.setWeChat(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("sunacE".equals(String.valueOf(total.get("report_source")))) {
                    //融E
                    workbench.setSunacE(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("offline".equals(String.valueOf(total.get("report_source")))) {
                    //线下扫码
                    workbench.setOffline(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("tel".equals(String.valueOf(total.get("report_source")))) {
                    //电话
                    workbench.setPhone(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("email".equals((String) total.get("report_source"))) {
                    //邮件
                    workbench.setEmail(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                } else if ("visit".equals((String) total.get("report_source"))) {
                    //来访
                    workbench.setVisit(Integer.valueOf(String.valueOf(total.get("COUNT(report_source)"))));
                }
            }
        }
        workbench.setTotal(workbench.getWeb() + workbench.getOa() + workbench.getSupplier() + workbench.getWeChat() +
                workbench.getSunacE() + workbench.getOffline() + workbench.getPhone() + workbench.getEmail() + workbench.getVisit());
        return workbench;
    }

    public List<ReportEntity> getRepList(WorkbenchBean benchBean) throws Exception {
        List<ReportEntity> repList = reportDao.getRepList(benchBean);
        System.out.println("大小:"+repList.size()+"==========================================");
        return  repList;
    }
}
