/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.web;

import com.alibaba.fastjson.JSONObject;
import com.ejweb.core.base.BaseController;
import com.ejweb.core.persistence.Page;

import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.entity.CtBbtcRegion;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.service.CtBbtcBusTypeService;
import com.ejweb.modules.report.service.CtBbtcRegionService;
import com.ejweb.modules.report.service.ReportService;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.List;

/**
 * 区域基础资料Controller
 * @author haoqm
 * @version 2019-07-12
 */
@Controller
@RequestMapping(value = "${adminPath}/report/ctBbtcRegion")
public class CtBbtcRegionController extends BaseController {
	/**
	 * 管理基础路径
	 */
	@Value("${adminPath}")
	protected String adminPath;
	@Autowired
	private CtBbtcRegionService ctBbtcRegionService;
	@Autowired
	private CtBbtcBusTypeService ctBbtcBusTypeService;

	@Autowired
	private   ReportService reportService;
	
	@ModelAttribute
	public CtBbtcRegion get(@RequestParam(required=false) String id) {
		CtBbtcRegion entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ctBbtcRegionService.get(id);
		}
		if (entity == null){
			entity = new CtBbtcRegion();
		}
		return entity;
	}
	
	@RequiresPermissions("report:ctBbtcRegion:view")
	@RequestMapping(value = {"list", ""})
	public String list(CtBbtcRegion ctBbtcRegion, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<CtBbtcRegion> page = ctBbtcRegionService.findPage(new Page<CtBbtcRegion>(request, response), ctBbtcRegion); 
		model.addAttribute("page", page);
		return "modules/report/ctBbtcRegionList";
	}

	@RequiresPermissions("report:ctBbtcRegion:view")
	@RequestMapping(value = "form")
	public String form(CtBbtcRegion ctBbtcRegion, Model model) {
		model.addAttribute("ctBbtcRegion", ctBbtcRegion);
		return "modules/report/ctBbtcRegionForm";
	}

	@RequiresPermissions("report:ctBbtcRegion:edit")
	@RequestMapping(value = "save")
	public String save(CtBbtcRegion ctBbtcRegion, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ctBbtcRegion)){
			return form(ctBbtcRegion, model);
		}
		ctBbtcRegionService.save(ctBbtcRegion);
		addMessage(redirectAttributes, "保存区域基础资料成功");
		return "redirect:"+adminPath+"/report/ctBbtcRegion/?repage";
	}
	
	@RequiresPermissions("report:ctBbtcRegion:edit")
	@RequestMapping(value = "delete")
	public String delete(CtBbtcRegion ctBbtcRegion, RedirectAttributes redirectAttributes) {

		/*如果信息已在举报中存在  则不删除*/
		System.out.println(checkIsExist(ctBbtcRegion)+"========================================");

		if(!checkIsExist(ctBbtcRegion)){
			ctBbtcRegionService.delete(ctBbtcRegion);
			addMessage(redirectAttributes, "删除区域基础资料成功");
			return "redirect:"+adminPath+"/report/ctBbtcRegion/?repage";
		}
		addMessage(redirectAttributes, "删除区域基础资料不成功，举报信息中已存在");
		return "redirect:"+adminPath+"/report/ctBbtcRegion/?repage";
	}

	/**
	 * 校验  区域是否在举报信息中出现过
	 * @return true 出现过   false  未出现过
	 */
	public   boolean checkIsExist(CtBbtcRegion ctBbtcRegion){

		ReportEntity  reportEntity=new ReportEntity();

		//如果id不为空    跟据id去查询列表
		if(StringUtils.isNotBlank(ctBbtcRegion.getId())){
			reportEntity.setSupplementArea(ctBbtcRegion.getId());
			List<ReportEntity> reportList = reportService.getReportListByCheck(reportEntity);
			System.out.println(reportList.size()+"============================");
			if(reportList.size()>0){
				return  true;
			}else{
				return  false;
			}
		}
		return false;
	}

	@RequestMapping(value = "getRegionList")
	public void getRegionList(String groupId, RedirectAttributes redirectAttributes,HttpServletResponse response){
		if(groupId != null && !"".equals(groupId)){
			JSONObject res = new JSONObject();
			List<CtBbtcRegion> ctBbtcRegionList = ctBbtcRegionService.getByGroupId(groupId);
			List<CtBbtcBusType> ctBbtcBusTypeList = ctBbtcBusTypeService.getByGroupId(groupId);

			res.put("ctBbtcRegionList", ctBbtcRegionList);
			res.put("ctBbtcBusTypeList", ctBbtcBusTypeList);
			String jsonStr = res.toJSONString();
			try{
				PrintWriter out = response.getWriter();
				out.print(jsonStr);
				out.close();
			}catch (Exception e){
				e.printStackTrace();
			}
		}



	}


}