/*!40101 set names utf8 */;

/*!40101 set sql_mode=''*/;

/*!40014 set @old_unique_checks=@@unique_checks, unique_checks=0 */;
/*!40014 set @old_foreign_key_checks=@@foreign_key_checks, foreign_key_checks=0 */;
/*!40101 set @old_sql_mode=@@sql_mode, sql_mode='no_auto_value_on_zero' */;
/*!40111 set @old_sql_notes=@@sql_notes, sql_notes=0 */;
create database /*!32312 if not exists*/`jeesite` /*!40100 default character set utf8 collate utf8_bin */;

use `jeesite`;

/*table structure for table `act_ge_bytearray` */

drop table if exists `act_ge_bytearray`;

create table `act_ge_bytearray` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `name_` varchar(255) collate utf8_bin default null,
  `deployment_id_` varchar(64) collate utf8_bin default null,
  `bytes_` longblob,
  `generated_` tinyint(4) default null,
  primary key (`id_`),
  key `act_fk_bytearr_depl` (`deployment_id_`),
  constraint `act_fk_bytearr_depl` foreign key (`deployment_id_`) references `act_re_deployment` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ge_bytearray` */

/*table structure for table `act_ge_property` */

drop table if exists `act_ge_property`;

create table `act_ge_property` (
  `name_` varchar(64) collate utf8_bin not null default '',
  `value_` varchar(300) collate utf8_bin default null,
  `rev_` int(11) default null,
  primary key (`name_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ge_property` */

insert  into `act_ge_property`(`name_`,`value_`,`rev_`) values ('next.dbid','1',1),('schema.history','create(5.15.1)',1),('schema.version','5.15.1',1);

/*table structure for table `act_hi_attachment` */

drop table if exists `act_hi_attachment`;

create table `act_hi_attachment` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `user_id_` varchar(255) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin default null,
  `description_` varchar(4000) collate utf8_bin default null,
  `type_` varchar(255) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `url_` varchar(4000) collate utf8_bin default null,
  `content_id_` varchar(64) collate utf8_bin default null,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_attachment` */

/*table structure for table `act_hi_comment` */

drop table if exists `act_hi_comment`;

create table `act_hi_comment` (
  `id_` varchar(64) collate utf8_bin not null,
  `type_` varchar(255) collate utf8_bin default null,
  `time_` datetime not null,
  `user_id_` varchar(255) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `action_` varchar(255) collate utf8_bin default null,
  `message_` varchar(4000) collate utf8_bin default null,
  `full_msg_` longblob,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_comment` */

/*table structure for table `act_hi_taskinst` */

drop table if exists `act_hi_taskinst`;

create table `act_hi_taskinst` (
  `id_` varchar(64) collate utf8_bin not null,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  `task_def_key_` varchar(255) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin default null,
  `parent_task_id_` varchar(64) collate utf8_bin default null,
  `description_` varchar(4000) collate utf8_bin default null,
  `owner_` varchar(255) collate utf8_bin default null,
  `assignee_` varchar(255) collate utf8_bin default null,
  `start_time_` datetime not null,
  `claim_time_` datetime default null,
  `end_time_` datetime default null,
  `duration_` bigint(20) default null,
  `delete_reason_` varchar(4000) collate utf8_bin default null,
  `priority_` int(11) default null,
  `due_date_` datetime default null,
  `form_key_` varchar(255) collate utf8_bin default null,
  `category_` varchar(255) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_taskinst` */

/*table structure for table `act_id_group` */

drop table if exists `act_id_group`;

create table `act_id_group` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `name_` varchar(255) collate utf8_bin default null,
  `type_` varchar(255) collate utf8_bin default null,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_id_group` */

/*table structure for table `act_id_info` */

drop table if exists `act_id_info`;

create table `act_id_info` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `user_id_` varchar(64) collate utf8_bin default null,
  `type_` varchar(64) collate utf8_bin default null,
  `key_` varchar(255) collate utf8_bin default null,
  `value_` varchar(255) collate utf8_bin default null,
  `password_` longblob,
  `parent_id_` varchar(255) collate utf8_bin default null,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_id_info` */

/*table structure for table `act_id_membership` */

drop table if exists `act_id_membership`;

create table `act_id_membership` (
  `user_id_` varchar(64) collate utf8_bin not null default '',
  `group_id_` varchar(64) collate utf8_bin not null default '',
  primary key (`user_id_`,`group_id_`),
  key `act_fk_memb_group` (`group_id_`),
  constraint `act_fk_memb_user` foreign key (`user_id_`) references `act_id_user` (`id_`),
  constraint `act_fk_memb_group` foreign key (`group_id_`) references `act_id_group` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_id_membership` */

/*table structure for table `act_id_user` */

drop table if exists `act_id_user`;

create table `act_id_user` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `first_` varchar(255) collate utf8_bin default null,
  `last_` varchar(255) collate utf8_bin default null,
  `email_` varchar(255) collate utf8_bin default null,
  `pwd_` varchar(255) collate utf8_bin default null,
  `picture_id_` varchar(64) collate utf8_bin default null,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_id_user` */

/*table structure for table `act_re_deployment` */

drop table if exists `act_re_deployment`;

create table `act_re_deployment` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `name_` varchar(255) collate utf8_bin default null,
  `category_` varchar(255) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  `deploy_time_` timestamp not null default current_timestamp on update current_timestamp,
  primary key (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_re_deployment` */

/*table structure for table `act_re_model` */

drop table if exists `act_re_model`;

create table `act_re_model` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `name_` varchar(255) collate utf8_bin default null,
  `key_` varchar(255) collate utf8_bin default null,
  `category_` varchar(255) collate utf8_bin default null,
  `create_time_` timestamp null default null,
  `last_update_time_` timestamp null default null,
  `version_` int(11) default null,
  `meta_info_` varchar(4000) collate utf8_bin default null,
  `deployment_id_` varchar(64) collate utf8_bin default null,
  `editor_source_value_id_` varchar(64) collate utf8_bin default null,
  `editor_source_extra_value_id_` varchar(64) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_fk_model_source` (`editor_source_value_id_`),
  key `act_fk_model_source_extra` (`editor_source_extra_value_id_`),
  key `act_fk_model_deployment` (`deployment_id_`),
  constraint `act_fk_model_deployment` foreign key (`deployment_id_`) references `act_re_deployment` (`id_`),
  constraint `act_fk_model_source` foreign key (`editor_source_value_id_`) references `act_ge_bytearray` (`id_`),
  constraint `act_fk_model_source_extra` foreign key (`editor_source_extra_value_id_`) references `act_ge_bytearray` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_re_model` */

/*table structure for table `act_re_procdef` */

drop table if exists `act_re_procdef`;

create table `act_re_procdef` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `category_` varchar(255) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin default null,
  `key_` varchar(255) collate utf8_bin not null,
  `version_` int(11) not null,
  `deployment_id_` varchar(64) collate utf8_bin default null,
  `resource_name_` varchar(4000) collate utf8_bin default null,
  `dgrm_resource_name_` varchar(4000) collate utf8_bin default null,
  `description_` varchar(4000) collate utf8_bin default null,
  `has_start_form_key_` tinyint(4) default null,
  `suspension_state_` int(11) default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  unique key `act_uniq_procdef` (`key_`,`version_`,`tenant_id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_re_procdef` */

/*table structure for table `act_ru_event_subscr` */

drop table if exists `act_ru_event_subscr`;

create table `act_ru_event_subscr` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `event_type_` varchar(255) collate utf8_bin not null,
  `event_name_` varchar(255) collate utf8_bin default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `activity_id_` varchar(64) collate utf8_bin default null,
  `configuration_` varchar(255) collate utf8_bin default null,
  `created_` timestamp not null default current_timestamp,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_idx_event_subscr_config_` (`configuration_`),
  key `act_fk_event_exec` (`execution_id_`),
  constraint `act_fk_event_exec` foreign key (`execution_id_`) references `act_ru_execution` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_event_subscr` */

/*table structure for table `act_ru_execution` */

drop table if exists `act_ru_execution`;

create table `act_ru_execution` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `business_key_` varchar(255) collate utf8_bin default null,
  `parent_id_` varchar(64) collate utf8_bin default null,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  `super_exec_` varchar(64) collate utf8_bin default null,
  `act_id_` varchar(255) collate utf8_bin default null,
  `is_active_` tinyint(4) default null,
  `is_concurrent_` tinyint(4) default null,
  `is_scope_` tinyint(4) default null,
  `is_event_scope_` tinyint(4) default null,
  `suspension_state_` int(11) default null,
  `cached_ent_state_` int(11) default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_idx_exec_buskey` (`business_key_`),
  key `act_fk_exe_procinst` (`proc_inst_id_`),
  key `act_fk_exe_parent` (`parent_id_`),
  key `act_fk_exe_super` (`super_exec_`),
  key `act_fk_exe_procdef` (`proc_def_id_`),
  constraint `act_fk_exe_procdef` foreign key (`proc_def_id_`) references `act_re_procdef` (`id_`),
  constraint `act_fk_exe_parent` foreign key (`parent_id_`) references `act_ru_execution` (`id_`),
  constraint `act_fk_exe_procinst` foreign key (`proc_inst_id_`) references `act_ru_execution` (`id_`) on delete cascade on update cascade,
  constraint `act_fk_exe_super` foreign key (`super_exec_`) references `act_ru_execution` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_execution` */

/*table structure for table `act_ru_identitylink` */

drop table if exists `act_ru_identitylink`;

create table `act_ru_identitylink` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `group_id_` varchar(255) collate utf8_bin default null,
  `type_` varchar(255) collate utf8_bin default null,
  `user_id_` varchar(255) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  primary key (`id_`),
  key `act_idx_ident_lnk_user` (`user_id_`),
  key `act_idx_ident_lnk_group` (`group_id_`),
  key `act_idx_athrz_procedef` (`proc_def_id_`),
  key `act_fk_tskass_task` (`task_id_`),
  key `act_fk_idl_procinst` (`proc_inst_id_`),
  constraint `act_fk_idl_procinst` foreign key (`proc_inst_id_`) references `act_ru_execution` (`id_`),
  constraint `act_fk_athrz_procedef` foreign key (`proc_def_id_`) references `act_re_procdef` (`id_`),
  constraint `act_fk_tskass_task` foreign key (`task_id_`) references `act_ru_task` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_identitylink` */

/*table structure for table `act_ru_job` */

drop table if exists `act_ru_job`;

create table `act_ru_job` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `type_` varchar(255) collate utf8_bin not null,
  `lock_exp_time_` timestamp null default null,
  `lock_owner_` varchar(255) collate utf8_bin default null,
  `exclusive_` tinyint(1) default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `process_instance_id_` varchar(64) collate utf8_bin default null,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  `retries_` int(11) default null,
  `exception_stack_id_` varchar(64) collate utf8_bin default null,
  `exception_msg_` varchar(4000) collate utf8_bin default null,
  `duedate_` timestamp null default null,
  `repeat_` varchar(255) collate utf8_bin default null,
  `handler_type_` varchar(255) collate utf8_bin default null,
  `handler_cfg_` varchar(4000) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_fk_job_exception` (`exception_stack_id_`),
  constraint `act_fk_job_exception` foreign key (`exception_stack_id_`) references `act_ge_bytearray` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_job` */

/*table structure for table `act_ru_task` */

drop table if exists `act_ru_task`;

create table `act_ru_task` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `rev_` int(11) default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `proc_def_id_` varchar(64) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin default null,
  `parent_task_id_` varchar(64) collate utf8_bin default null,
  `description_` varchar(4000) collate utf8_bin default null,
  `task_def_key_` varchar(255) collate utf8_bin default null,
  `owner_` varchar(255) collate utf8_bin default null,
  `assignee_` varchar(255) collate utf8_bin default null,
  `delegation_` varchar(64) collate utf8_bin default null,
  `priority_` int(11) default null,
  `create_time_` timestamp not null default current_timestamp on update current_timestamp,
  `due_date_` datetime default null,
  `category_` varchar(255) collate utf8_bin default null,
  `suspension_state_` int(11) default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_idx_task_create` (`create_time_`),
  key `act_fk_task_exe` (`execution_id_`),
  key `act_fk_task_procinst` (`proc_inst_id_`),
  key `act_fk_task_procdef` (`proc_def_id_`),
  constraint `act_fk_task_procdef` foreign key (`proc_def_id_`) references `act_re_procdef` (`id_`),
  constraint `act_fk_task_exe` foreign key (`execution_id_`) references `act_ru_execution` (`id_`),
  constraint `act_fk_task_procinst` foreign key (`proc_inst_id_`) references `act_ru_execution` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_task` */

/*table structure for table `act_ru_variable` */

drop table if exists `act_ru_variable`;

create table `act_ru_variable` (
  `id_` varchar(64) collate utf8_bin not null,
  `rev_` int(11) default null,
  `type_` varchar(255) collate utf8_bin not null,
  `name_` varchar(255) collate utf8_bin not null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `bytearray_id_` varchar(64) collate utf8_bin default null,
  `double_` double default null,
  `long_` bigint(20) default null,
  `text_` varchar(4000) collate utf8_bin default null,
  `text2_` varchar(4000) collate utf8_bin default null,
  primary key (`id_`),
  key `act_idx_variable_task_id` (`task_id_`),
  key `act_fk_var_exe` (`execution_id_`),
  key `act_fk_var_procinst` (`proc_inst_id_`),
  key `act_fk_var_bytearray` (`bytearray_id_`),
  constraint `act_fk_var_bytearray` foreign key (`bytearray_id_`) references `act_ge_bytearray` (`id_`),
  constraint `act_fk_var_exe` foreign key (`execution_id_`) references `act_ru_execution` (`id_`),
  constraint `act_fk_var_procinst` foreign key (`proc_inst_id_`) references `act_ru_execution` (`id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_ru_variable` */

/*table structure for table `act_hi_actinst` */

drop table if exists `act_hi_actinst`;

create table `act_hi_actinst` (
  `id_` varchar(64) collate utf8_bin not null,
  `proc_def_id_` varchar(64) collate utf8_bin not null,
  `proc_inst_id_` varchar(64) collate utf8_bin not null,
  `execution_id_` varchar(64) collate utf8_bin not null,
  `act_id_` varchar(255) collate utf8_bin not null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `call_proc_inst_id_` varchar(64) collate utf8_bin default null,
  `act_name_` varchar(255) collate utf8_bin default null,
  `act_type_` varchar(255) collate utf8_bin not null,
  `assignee_` varchar(255) collate utf8_bin default null,
  `start_time_` datetime not null,
  `end_time_` datetime default null,
  `duration_` bigint(20) default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  key `act_idx_hi_act_inst_start` (`start_time_`),
  key `act_idx_hi_act_inst_end` (`end_time_`),
  key `act_idx_hi_act_inst_procinst` (`proc_inst_id_`,`act_id_`),
  key `act_idx_hi_act_inst_exec` (`execution_id_`,`act_id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_actinst` */

/*table structure for table `act_hi_detail` */

drop table if exists `act_hi_detail`;

create table `act_hi_detail` (
  `id_` varchar(64) collate utf8_bin not null,
  `type_` varchar(255) collate utf8_bin not null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `act_inst_id_` varchar(64) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin not null,
  `var_type_` varchar(255) collate utf8_bin default null,
  `rev_` int(11) default null,
  `time_` datetime not null,
  `bytearray_id_` varchar(64) collate utf8_bin default null,
  `double_` double default null,
  `long_` bigint(20) default null,
  `text_` varchar(4000) collate utf8_bin default null,
  `text2_` varchar(4000) collate utf8_bin default null,
  primary key (`id_`),
  key `act_idx_hi_detail_proc_inst` (`proc_inst_id_`),
  key `act_idx_hi_detail_act_inst` (`act_inst_id_`),
  key `act_idx_hi_detail_time` (`time_`),
  key `act_idx_hi_detail_name` (`name_`),
  key `act_idx_hi_detail_task_id` (`task_id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_detail` */

/*table structure for table `act_hi_identitylink` */

drop table if exists `act_hi_identitylink`;

create table `act_hi_identitylink` (
  `id_` varchar(64) collate utf8_bin not null default '',
  `group_id_` varchar(255) collate utf8_bin default null,
  `type_` varchar(255) collate utf8_bin default null,
  `user_id_` varchar(255) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  primary key (`id_`),
  key `act_idx_hi_ident_lnk_user` (`user_id_`),
  key `act_idx_hi_ident_lnk_task` (`task_id_`),
  key `act_idx_hi_ident_lnk_procinst` (`proc_inst_id_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_identitylink` */

/*table structure for table `act_hi_procinst` */

drop table if exists `act_hi_procinst`;

create table `act_hi_procinst` (
  `id_` varchar(64) collate utf8_bin not null,
  `proc_inst_id_` varchar(64) collate utf8_bin not null,
  `business_key_` varchar(255) collate utf8_bin default null,
  `proc_def_id_` varchar(64) collate utf8_bin not null,
  `start_time_` datetime not null,
  `end_time_` datetime default null,
  `duration_` bigint(20) default null,
  `start_user_id_` varchar(255) collate utf8_bin default null,
  `start_act_id_` varchar(255) collate utf8_bin default null,
  `end_act_id_` varchar(255) collate utf8_bin default null,
  `super_process_instance_id_` varchar(64) collate utf8_bin default null,
  `delete_reason_` varchar(4000) collate utf8_bin default null,
  `tenant_id_` varchar(255) collate utf8_bin default '',
  primary key (`id_`),
  unique key `proc_inst_id_` (`proc_inst_id_`),
  key `act_idx_hi_pro_inst_end` (`end_time_`),
  key `act_idx_hi_pro_i_buskey` (`business_key_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_procinst` */

/*table structure for table `act_hi_varinst` */

drop table if exists `act_hi_varinst`;

create table `act_hi_varinst` (
  `id_` varchar(64) collate utf8_bin not null,
  `proc_inst_id_` varchar(64) collate utf8_bin default null,
  `execution_id_` varchar(64) collate utf8_bin default null,
  `task_id_` varchar(64) collate utf8_bin default null,
  `name_` varchar(255) collate utf8_bin not null,
  `var_type_` varchar(100) collate utf8_bin default null,
  `rev_` int(11) default null,
  `bytearray_id_` varchar(64) collate utf8_bin default null,
  `double_` double default null,
  `long_` bigint(20) default null,
  `text_` varchar(4000) collate utf8_bin default null,
  `text2_` varchar(4000) collate utf8_bin default null,
  `create_time_` datetime default null,
  `last_updated_time_` datetime default null,
  primary key (`id_`),
  key `act_idx_hi_procvar_proc_inst` (`proc_inst_id_`),
  key `act_idx_hi_procvar_name_type` (`name_`,`var_type_`)
) engine=innodb default charset=utf8 collate=utf8_bin;

/*data for the table `act_hi_varinst` */

/*table structure for table `cms_article` */

drop table if exists `cms_article`;

create table `cms_article` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `category_id` varchar(64) collate utf8_bin not null comment '栏目编号',
  `title` varchar(255) collate utf8_bin not null comment '标题',
  `link` varchar(255) collate utf8_bin default null comment '文章链接',
  `color` varchar(50) collate utf8_bin default null comment '标题颜色',
  `image` varchar(255) collate utf8_bin default null comment '文章图片',
  `keywords` varchar(255) collate utf8_bin default null comment '关键字',
  `description` varchar(255) collate utf8_bin default null comment '描述、摘要',
  `weight` int(11) default '0' comment '权重，越大越靠前',
  `weight_date` datetime default null comment '权重期限',
  `hits` int(11) default '0' comment '点击数',
  `posid` varchar(10) collate utf8_bin default null comment '推荐位，多选',
  `custom_content_view` varchar(255) collate utf8_bin default null comment '自定义内容视图',
  `view_config` text collate utf8_bin comment '视图配置',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_article_create_by` (`create_by`),
  key `cms_article_title` (`title`),
  key `cms_article_keywords` (`keywords`),
  key `cms_article_del_flag` (`del_flag`),
  key `cms_article_weight` (`weight`),
  key `cms_article_update_date` (`update_date`),
  key `cms_article_category_id` (`category_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='文章表';

/*data for the table `cms_article` */

insert  into `cms_article`(`id`,`category_id`,`title`,`link`,`color`,`image`,`keywords`,`description`,`weight`,`weight_date`,`hits`,`posid`,`custom_content_view`,`view_config`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','3','文章标题标题标题标题',null,'green',null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','4','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','5','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','5','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','5','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('14','7','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('15','7','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('16','7','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('17','7','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('18','8','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('19','8','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','3','文章标题标题标题标题',null,'red',null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('20','8','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('21','8','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('22','9','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('23','9','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('24','9','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('25','9','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('26','9','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('27','11','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('28','11','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('29','11','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','3','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('30','11','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('31','11','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('32','12','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('33','12','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('34','12','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('35','12','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('36','12','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('37','13','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('38','13','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('39','13','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','3','文章标题标题标题标题',null,'green',null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('40','13','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('41','14','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('42','14','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('43','14','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('44','14','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('45','14','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('46','15','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('47','15','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('48','15','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('49','16','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','3','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('50','17','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('51','17','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('52','26','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('53','26','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','3','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','4','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('8','4','文章标题标题标题标题',null,'blue',null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('9','4','文章标题标题标题标题',null,null,null,'关键字1,关键字2',null,0,null,0,null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `cms_article_data` */

drop table if exists `cms_article_data`;

create table `cms_article_data` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `content` text collate utf8_bin comment '文章内容',
  `copyfrom` varchar(255) collate utf8_bin default null comment '文章来源',
  `relation` varchar(255) collate utf8_bin default null comment '相关文章',
  `allow_comment` char(1) collate utf8_bin default null comment '是否允许评论',
  primary key (`id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='文章详表';

/*data for the table `cms_article_data` */

insert  into `cms_article_data`(`id`,`content`,`copyfrom`,`relation`,`allow_comment`) values ('1','文章内容内容内容内容','来源','1,2,3','1'),('10','文章内容内容内容内容','来源','1,2,3','1'),('11','文章内容内容内容内容','来源','1,2,3','1'),('12','文章内容内容内容内容','来源','1,2,3','1'),('13','文章内容内容内容内容','来源','1,2,3','1'),('14','文章内容内容内容内容','来源','1,2,3','1'),('15','文章内容内容内容内容','来源','1,2,3','1'),('16','文章内容内容内容内容','来源','1,2,3','1'),('17','文章内容内容内容内容','来源','1,2,3','1'),('18','文章内容内容内容内容','来源','1,2,3','1'),('19','文章内容内容内容内容','来源','1,2,3','1'),('2','文章内容内容内容内容','来源','1,2,3','1'),('20','文章内容内容内容内容','来源','1,2,3','1'),('21','文章内容内容内容内容','来源','1,2,3','1'),('22','文章内容内容内容内容','来源','1,2,3','1'),('23','文章内容内容内容内容','来源','1,2,3','1'),('24','文章内容内容内容内容','来源','1,2,3','1'),('25','文章内容内容内容内容','来源','1,2,3','1'),('26','文章内容内容内容内容','来源','1,2,3','1'),('27','文章内容内容内容内容','来源','1,2,3','1'),('28','文章内容内容内容内容','来源','1,2,3','1'),('29','文章内容内容内容内容','来源','1,2,3','1'),('3','文章内容内容内容内容','来源','1,2,3','1'),('30','文章内容内容内容内容','来源','1,2,3','1'),('31','文章内容内容内容内容','来源','1,2,3','1'),('32','文章内容内容内容内容','来源','1,2,3','1'),('33','文章内容内容内容内容','来源','1,2,3','1'),('34','文章内容内容内容内容','来源','1,2,3','1'),('35','文章内容内容内容内容','来源','1,2,3','1'),('36','文章内容内容内容内容','来源','1,2,3','1'),('37','文章内容内容内容内容','来源','1,2,3','1'),('38','文章内容内容内容内容','来源','1,2,3','1'),('39','文章内容内容内容内容','来源','1,2,3','1'),('4','文章内容内容内容内容','来源','1,2,3','1'),('40','文章内容内容内容内容','来源','1,2,3','1'),('41','文章内容内容内容内容','来源','1,2,3','1'),('42','文章内容内容内容内容','来源','1,2,3','1'),('43','文章内容内容内容内容','来源','1,2,3','1'),('44','文章内容内容内容内容','来源','1,2,3','1'),('45','文章内容内容内容内容','来源','1,2,3','1'),('46','文章内容内容内容内容','来源','1,2,3','1'),('47','文章内容内容内容内容','来源','1,2,3','1'),('48','文章内容内容内容内容','来源','1,2,3','1'),('49','文章内容内容内容内容','来源','1,2,3','1'),('5','文章内容内容内容内容','来源','1,2,3','1'),('50','文章内容内容内容内容','来源','1,2,3','1'),('51','文章内容内容内容内容','来源','1,2,3','1'),('52','文章内容内容内容内容','来源','1,2,3','1'),('53','文章内容内容内容内容','来源','1,2,3','1'),('6','文章内容内容内容内容','来源','1,2,3','1'),('7','文章内容内容内容内容','来源','1,2,3','1'),('8','文章内容内容内容内容','来源','1,2,3','1'),('9','文章内容内容内容内容','来源','1,2,3','1');

/*table structure for table `cms_category` */

drop table if exists `cms_category`;

create table `cms_category` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `site_id` varchar(64) collate utf8_bin default '1' comment '站点编号',
  `office_id` varchar(64) collate utf8_bin default null comment '归属机构',
  `module` varchar(20) collate utf8_bin default null comment '栏目模块',
  `name` varchar(100) collate utf8_bin not null comment '栏目名称',
  `image` varchar(255) collate utf8_bin default null comment '栏目图片',
  `href` varchar(255) collate utf8_bin default null comment '链接',
  `target` varchar(20) collate utf8_bin default null comment '目标',
  `description` varchar(255) collate utf8_bin default null comment '描述',
  `keywords` varchar(255) collate utf8_bin default null comment '关键字',
  `sort` int(11) default '30' comment '排序（升序）',
  `in_menu` char(1) collate utf8_bin default '1' comment '是否在导航中显示',
  `in_list` char(1) collate utf8_bin default '1' comment '是否在分类页中显示列表',
  `show_modes` char(1) collate utf8_bin default '0' comment '展现方式',
  `allow_comment` char(1) collate utf8_bin default null comment '是否允许评论',
  `is_audit` char(1) collate utf8_bin default null comment '是否需要审核',
  `custom_list_view` varchar(255) collate utf8_bin default null comment '自定义列表视图',
  `custom_content_view` varchar(255) collate utf8_bin default null comment '自定义内容视图',
  `view_config` text collate utf8_bin comment '视图配置',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_category_parent_id` (`parent_id`),
  key `cms_category_module` (`module`),
  key `cms_category_name` (`name`),
  key `cms_category_sort` (`sort`),
  key `cms_category_del_flag` (`del_flag`),
  key `cms_category_office_id` (`office_id`),
  key `cms_category_site_id` (`site_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='栏目表';

/*data for the table `cms_category` */

insert  into `cms_category`(`id`,`parent_id`,`parent_ids`,`site_id`,`office_id`,`module`,`name`,`image`,`href`,`target`,`description`,`keywords`,`sort`,`in_menu`,`in_list`,`show_modes`,`allow_comment`,`is_audit`,`custom_list_view`,`custom_content_view`,`view_config`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','0','0,','0','1',null,'顶级栏目',null,null,null,null,null,0,'1','1','0','0','1',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','1','0,1,','1','4','article','软件介绍',null,null,null,null,null,20,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','10','0,1,10,','1','4','article','网络工具',null,null,null,null,null,30,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','10','0,1,10,','1','4','article','浏览工具',null,null,null,null,null,40,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','10','0,1,10,','1','4','article','浏览辅助',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('14','10','0,1,10,','1','4','article','网络优化',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('15','10','0,1,10,','1','4','article','邮件处理',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('16','10','0,1,10,','1','4','article','下载工具',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('17','10','0,1,10,','1','4','article','搜索工具',null,null,null,null,null,50,'1','1','2','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('18','1','0,1,','1','5','link','友情链接',null,null,null,null,null,90,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('19','18','0,1,18,','1','5','link','常用网站',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','0,1,','1','3','article','组织机构',null,null,null,null,null,10,'1','1','0','0','1',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('20','18','0,1,18,','1','5','link','门户网站',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('21','18','0,1,18,','1','5','link','购物网站',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('22','18','0,1,18,','1','5','link','交友社区',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('23','18','0,1,18,','1','5','link','音乐视频',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('24','1','0,1,','1','6',null,'百度一下',null,'http://www.baidu.com','_blank',null,null,90,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('25','1','0,1,','1','6',null,'全文检索',null,'/search',null,null,null,90,'0','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('26','1','0,1,','2','6','article','测试栏目',null,null,null,null,null,90,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('27','1','0,1,','1','6',null,'公共留言',null,'/guestbook',null,null,null,90,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','2','0,1,2,','1','3','article','网站简介',null,null,null,null,null,30,'1','1','0','0','1',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','2','0,1,2,','1','3','article','内部机构',null,null,null,null,null,40,'1','1','0','0','1',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','2','0,1,2,','1','3','article','地方机构',null,null,null,null,null,50,'1','1','0','0','1',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','1','0,1,','1','3','article','质量检验',null,null,null,null,null,20,'1','1','1','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','6','0,1,6,','1','3','article','产品质量',null,null,null,null,null,30,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('8','6','0,1,6,','1','3','article','技术质量',null,null,null,null,null,40,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('9','6','0,1,6,','1','3','article','工程质量',null,null,null,null,null,50,'1','1','0','1','0',null,null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `cms_comment` */

drop table if exists `cms_comment`;

create table `cms_comment` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `category_id` varchar(64) collate utf8_bin not null comment '栏目编号',
  `content_id` varchar(64) collate utf8_bin not null comment '栏目内容的编号',
  `title` varchar(255) collate utf8_bin default null comment '栏目内容的标题',
  `content` varchar(255) collate utf8_bin default null comment '评论内容',
  `name` varchar(100) collate utf8_bin default null comment '评论姓名',
  `ip` varchar(100) collate utf8_bin default null comment '评论ip',
  `create_date` datetime not null comment '评论时间',
  `audit_user_id` varchar(64) collate utf8_bin default null comment '审核人',
  `audit_date` datetime default null comment '审核时间',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_comment_category_id` (`category_id`),
  key `cms_comment_content_id` (`content_id`),
  key `cms_comment_status` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='评论表';

/*data for the table `cms_comment` */

/*table structure for table `cms_guestbook` */

drop table if exists `cms_guestbook`;

create table `cms_guestbook` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `type` char(1) collate utf8_bin not null comment '留言分类',
  `content` varchar(255) collate utf8_bin not null comment '留言内容',
  `name` varchar(100) collate utf8_bin not null comment '姓名',
  `email` varchar(100) collate utf8_bin not null comment '邮箱',
  `phone` varchar(100) collate utf8_bin not null comment '电话',
  `workunit` varchar(100) collate utf8_bin not null comment '单位',
  `ip` varchar(100) collate utf8_bin not null comment 'ip',
  `create_date` datetime not null comment '留言时间',
  `re_user_id` varchar(64) collate utf8_bin default null comment '回复人',
  `re_date` datetime default null comment '回复时间',
  `re_content` varchar(100) collate utf8_bin default null comment '回复内容',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_guestbook_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='留言板';

/*data for the table `cms_guestbook` */

/*table structure for table `cms_link` */

drop table if exists `cms_link`;

create table `cms_link` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `category_id` varchar(64) collate utf8_bin not null comment '栏目编号',
  `title` varchar(255) collate utf8_bin not null comment '链接名称',
  `color` varchar(50) collate utf8_bin default null comment '标题颜色',
  `image` varchar(255) collate utf8_bin default null comment '链接图片',
  `href` varchar(255) collate utf8_bin default null comment '链接地址',
  `weight` int(11) default '0' comment '权重，越大越靠前',
  `weight_date` datetime default null comment '权重期限',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_link_category_id` (`category_id`),
  key `cms_link_title` (`title`),
  key `cms_link_del_flag` (`del_flag`),
  key `cms_link_weight` (`weight`),
  key `cms_link_create_by` (`create_by`),
  key `cms_link_update_date` (`update_date`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='友情链接';

/*data for the table `cms_link` */

insert  into `cms_link`(`id`,`category_id`,`title`,`color`,`image`,`href`,`weight`,`weight_date`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','19','jeesite',null,null,'http://thinkgem.github.com/jeesite',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','22','58同城',null,null,'http://www.58.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','23','视频大全',null,null,'http://v.360.cn/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','23','凤凰网',null,null,'http://www.ifeng.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','19','thinkgem',null,null,'http://thinkgem.iteye.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','19','百度一下',null,null,'http://www.baidu.com',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','19','谷歌搜索',null,null,'http://www.google.com',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','20','新浪网',null,null,'http://www.sina.com.cn',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','20','腾讯网',null,null,'http://www.qq.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','21','淘宝网',null,null,'http://www.taobao.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('8','21','新华网',null,null,'http://www.xinhuanet.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('9','22','赶集网',null,null,'http://www.ganji.com/',0,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `cms_site` */

drop table if exists `cms_site`;

create table `cms_site` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `name` varchar(100) collate utf8_bin not null comment '站点名称',
  `title` varchar(100) collate utf8_bin not null comment '站点标题',
  `logo` varchar(255) collate utf8_bin default null comment '站点logo',
  `domain` varchar(255) collate utf8_bin default null comment '站点域名',
  `description` varchar(255) collate utf8_bin default null comment '描述',
  `keywords` varchar(255) collate utf8_bin default null comment '关键字',
  `theme` varchar(255) collate utf8_bin default 'default' comment '主题',
  `copyright` text collate utf8_bin comment '版权信息',
  `custom_index_view` varchar(255) collate utf8_bin default null comment '自定义站点首页视图',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `cms_site_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='站点表';

/*data for the table `cms_site` */

insert  into `cms_site`(`id`,`name`,`title`,`logo`,`domain`,`description`,`keywords`,`theme`,`copyright`,`custom_index_view`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','默认站点','jeesite web',null,null,'jeesite','jeesite','basic','copyright &copy; 2012-2013 <a href=\'http://thinkgem.iteye.com\' target=\'_blank\'>thinkgem</a> - powered by <a href=\'https://github.com/thinkgem/jeesite\' target=\'_blank\'>jeesite</a> v1.0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','子站点测试','jeesite subsite',null,null,'jeesite subsite','jeesite subsite','basic','copyright &copy; 2012-2013 <a href=\'http://thinkgem.iteye.com\' target=\'_blank\'>thinkgem</a> - powered by <a href=\'https://github.com/thinkgem/jeesite\' target=\'_blank\'>jeesite</a> v1.0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `gen_scheme` */

drop table if exists `gen_scheme`;

create table `gen_scheme` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `name` varchar(200) collate utf8_bin default null comment '名称',
  `category` varchar(2000) collate utf8_bin default null comment '分类',
  `package_name` varchar(500) collate utf8_bin default null comment '生成包路径',
  `module_name` varchar(30) collate utf8_bin default null comment '生成模块名',
  `sub_module_name` varchar(30) collate utf8_bin default null comment '生成子模块名',
  `function_name` varchar(500) collate utf8_bin default null comment '生成功能名',
  `function_name_simple` varchar(100) collate utf8_bin default null comment '生成功能名（简写）',
  `function_author` varchar(100) collate utf8_bin default null comment '生成功能作者',
  `gen_table_id` varchar(200) collate utf8_bin default null comment '生成表编号',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记（0：正常；1：删除）',
  primary key (`id`),
  key `gen_scheme_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='生成方案';

/*data for the table `gen_scheme` */

insert  into `gen_scheme`(`id`,`name`,`category`,`package_name`,`module_name`,`sub_module_name`,`function_name`,`function_name_simple`,`function_author`,`gen_table_id`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('35a13dc260284a728a270db3f382664b','树结构','treetable','com.thinkgem.jeesite.modules','test',null,'树结构生成','树结构','thinkgem','f6e4dafaa72f4c509636484715f33a96','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('9c9de9db6da743bb899036c6546061ac','单表','curd','com.thinkgem.jeesite.modules','test',null,'单表生成','单表','thinkgem','aef6f1fc948f4c9ab1c1b780bc471cc2','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('e6d905fd236b46d1af581dd32bdfb3b0','主子表','curd_many','com.thinkgem.jeesite.modules','test',null,'主子表生成','主子表','thinkgem','43d6d5acffa14c258340ce6765e46c6f','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0');

/*table structure for table `gen_table` */

drop table if exists `gen_table`;

create table `gen_table` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `name` varchar(200) collate utf8_bin default null comment '名称',
  `comments` varchar(500) collate utf8_bin default null comment '描述',
  `class_name` varchar(100) collate utf8_bin default null comment '实体类名称',
  `parent_table` varchar(200) collate utf8_bin default null comment '关联父表',
  `parent_table_fk` varchar(100) collate utf8_bin default null comment '关联父表外键',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记（0：正常；1：删除）',
  primary key (`id`),
  key `gen_table_name` (`name`),
  key `gen_table_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='业务表';

/*data for the table `gen_table` */

insert  into `gen_table`(`id`,`name`,`comments`,`class_name`,`parent_table`,`parent_table_fk`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('43d6d5acffa14c258340ce6765e46c6f','test_data_main','业务数据表','testdatamain',null,null,'1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('6e05c389f3c6415ea34e55e9dfb28934','test_data_child','业务数据子表','testdatachild','test_data_main','test_data_main_id','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('aef6f1fc948f4c9ab1c1b780bc471cc2','test_data','业务数据表','testdata',null,null,'1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('f6e4dafaa72f4c509636484715f33a96','test_tree','树结构表','testtree',null,null,'1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0');

/*table structure for table `gen_table_column` */

drop table if exists `gen_table_column`;

create table `gen_table_column` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `gen_table_id` varchar(64) collate utf8_bin default null comment '归属表编号',
  `name` varchar(200) collate utf8_bin default null comment '名称',
  `comments` varchar(500) collate utf8_bin default null comment '描述',
  `jdbc_type` varchar(100) collate utf8_bin default null comment '列的数据类型的字节长度',
  `java_type` varchar(500) collate utf8_bin default null comment 'java类型',
  `java_field` varchar(200) collate utf8_bin default null comment 'java字段名',
  `is_pk` char(1) collate utf8_bin default null comment '是否主键',
  `is_null` char(1) collate utf8_bin default null comment '是否可为空',
  `is_insert` char(1) collate utf8_bin default null comment '是否为插入字段',
  `is_edit` char(1) collate utf8_bin default null comment '是否编辑字段',
  `is_list` char(1) collate utf8_bin default null comment '是否列表字段',
  `is_query` char(1) collate utf8_bin default null comment '是否查询字段',
  `query_type` varchar(200) collate utf8_bin default null comment '查询方式（等于、不等于、大于、小于、范围、左like、右like、左右like）',
  `show_type` varchar(200) collate utf8_bin default null comment '字段生成方案（文本框、文本域、下拉框、复选框、单选框、字典选择、人员选择、部门选择、区域选择）',
  `dict_type` varchar(200) collate utf8_bin default null comment '字典类型',
  `settings` varchar(2000) collate utf8_bin default null comment '其它设置（扩展字段json）',
  `sort` decimal(10,0) default null comment '排序（升序）',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记（0：正常；1：删除）',
  primary key (`id`),
  key `gen_table_column_table_id` (`gen_table_id`),
  key `gen_table_column_name` (`name`),
  key `gen_table_column_sort` (`sort`),
  key `gen_table_column_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='业务表字段';

/*data for the table `gen_table_column` */

insert  into `gen_table_column`(`id`,`gen_table_id`,`name`,`comments`,`jdbc_type`,`java_type`,`java_field`,`is_pk`,`is_null`,`is_insert`,`is_edit`,`is_list`,`is_query`,`query_type`,`show_type`,`dict_type`,`settings`,`sort`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('0902a0cb3e8f434280c20e9d771d0658','aef6f1fc948f4c9ab1c1b780bc471cc2','sex','性别','char(1)','string','sex','0','1','1','1','1','1','=','radiobox','sex',null,'6','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('103fc05c88ff40639875c2111881996a','aef6f1fc948f4c9ab1c1b780bc471cc2','create_date','创建时间','timestamp(6)','java.util.date','createdate','0','0','1','0','0','0','=','dateselect',null,null,'9','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('12fa38dd986e41908f7fefa5839d1220','6e05c389f3c6415ea34e55e9dfb28934','create_by','创建者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','createby.id','0','0','1','0','0','0','=','input',null,null,'4','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('195ee9241f954d008fe01625f4adbfef','f6e4dafaa72f4c509636484715f33a96','create_by','创建者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','createby.id','0','0','1','0','0','0','=','input',null,null,'6','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('19c6478b8ff54c60910c2e4fc3d27503','43d6d5acffa14c258340ce6765e46c6f','id','编号','varchar2(64)','string','id','1','0','1','0','0','0','=','input',null,null,'1','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('1ac6562f753d4e599693840651ab2bf7','43d6d5acffa14c258340ce6765e46c6f','in_date','加入日期','date(7)','java.util.date','indate','0','1','1','1','0','0','=','dateselect',null,null,'7','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('1b8eb55f65284fa6b0a5879b6d8ad3ec','aef6f1fc948f4c9ab1c1b780bc471cc2','in_date','加入日期','date(7)','java.util.date','indate','0','1','1','1','0','1','between','dateselect',null,null,'7','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('1d5ca4d114be41e99f8dc42a682ba609','aef6f1fc948f4c9ab1c1b780bc471cc2','user_id','归属用户','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','user.id|name','0','1','1','1','1','1','=','userselect',null,null,'2','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('21756504ffdc487eb167a823f89c0c06','43d6d5acffa14c258340ce6765e46c6f','update_by','更新者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','updateby.id','0','0','1','1','0','0','=','input',null,null,'10','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('24bbdc0a555e4412a106ab1c5f03008e','f6e4dafaa72f4c509636484715f33a96','parent_ids','所有父级编号','varchar2(2000)','string','parentids','0','0','1','1','0','0','like','input',null,null,'3','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('33152ce420904594b3eac796a27f0560','6e05c389f3c6415ea34e55e9dfb28934','id','编号','varchar2(64)','string','id','1','0','1','0','0','0','=','input',null,null,'1','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('35af241859624a01917ab64c3f4f0813','aef6f1fc948f4c9ab1c1b780bc471cc2','del_flag','删除标记（0：正常；1：删除）','char(1)','string','delflag','0','0','1','0','0','0','=','radiobox','del_flag',null,'13','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('398b4a03f06940bfb979ca574e1911e3','aef6f1fc948f4c9ab1c1b780bc471cc2','create_by','创建者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','createby.id','0','0','1','0','0','0','=','input',null,null,'8','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('3a7cf23ae48a4c849ceb03feffc7a524','43d6d5acffa14c258340ce6765e46c6f','area_id','归属区域','nvarchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.area','area.id|name','0','1','1','1','0','0','=','areaselect',null,null,'4','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('3d9c32865bb44e85af73381df0ffbf3d','43d6d5acffa14c258340ce6765e46c6f','update_date','更新时间','timestamp(6)','java.util.date','updatedate','0','0','1','1','1','0','=','dateselect',null,null,'11','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('416c76d2019b4f76a96d8dc3a8faf84c','f6e4dafaa72f4c509636484715f33a96','update_date','更新时间','timestamp(6)','java.util.date','updatedate','0','0','1','1','1','0','=','dateselect',null,null,'9','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('46e6d8283270493687085d29efdecb05','f6e4dafaa72f4c509636484715f33a96','del_flag','删除标记（0：正常；1：删除）','char(1)','string','delflag','0','0','1','0','0','0','=','radiobox','del_flag',null,'11','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('4a0a1fff86ca46519477d66b82e01991','aef6f1fc948f4c9ab1c1b780bc471cc2','name','名称','nvarchar2(100)','string','name','0','1','1','1','1','1','like','input',null,null,'5','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('4c8ef12cb6924b9ba44048ba9913150b','43d6d5acffa14c258340ce6765e46c6f','create_date','创建时间','timestamp(6)','java.util.date','createdate','0','0','1','0','0','0','=','dateselect',null,null,'9','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('53d65a3d306d4fac9e561db9d3c66912','6e05c389f3c6415ea34e55e9dfb28934','del_flag','删除标记（0：正常；1：删除）','char(1)','string','delflag','0','0','1','0','0','0','=','radiobox','del_flag',null,'9','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('56fa71c0bd7e4132931874e548dc9ba5','6e05c389f3c6415ea34e55e9dfb28934','update_by','更新者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','updateby.id','0','0','1','1','0','0','=','input',null,null,'6','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('5a4a1933c9c844fdba99de043dc8205e','aef6f1fc948f4c9ab1c1b780bc471cc2','update_by','更新者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','updateby.id','0','0','1','1','0','0','=','input',null,null,'10','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('5e5c69bd3eaa4dcc9743f361f3771c08','aef6f1fc948f4c9ab1c1b780bc471cc2','id','编号','varchar2(64)','string','id','1','0','1','0','0','0','=','input',null,null,'1','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('633f5a49ec974c099158e7b3e6bfa930','f6e4dafaa72f4c509636484715f33a96','name','名称','nvarchar2(100)','string','name','0','0','1','1','1','1','like','input',null,null,'4','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('652491500f2641ffa7caf95a93e64d34','6e05c389f3c6415ea34e55e9dfb28934','update_date','更新时间','timestamp(6)','java.util.date','updatedate','0','0','1','1','1','0','=','dateselect',null,null,'7','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('6763ff6dc7cd4c668e76cf9b697d3ff6','f6e4dafaa72f4c509636484715f33a96','sort','排序','number(10)','integer','sort','0','0','1','1','1','0','=','input',null,null,'5','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('67d0331f809a48ee825602659f0778e8','43d6d5acffa14c258340ce6765e46c6f','name','名称','nvarchar2(100)','string','name','0','1','1','1','1','1','like','input',null,null,'5','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('68345713bef3445c906f70e68f55de38','6e05c389f3c6415ea34e55e9dfb28934','test_data_main_id','业务主表','varchar2(64)','string','testdatamain.id','0','1','1','1','0','0','=','input',null,null,'2','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('71ea4bc10d274911b405f3165fc1bb1a','aef6f1fc948f4c9ab1c1b780bc471cc2','area_id','归属区域','nvarchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.area','area.id|name','0','1','1','1','1','1','=','areaselect',null,null,'4','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('7f871058d94c4d9a89084be7c9ce806d','6e05c389f3c6415ea34e55e9dfb28934','remarks','备注信息','nvarchar2(255)','string','remarks','0','1','1','1','1','0','=','input',null,null,'8','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('8b48774cfe184913b8b5eb17639cf12d','43d6d5acffa14c258340ce6765e46c6f','create_by','创建者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','createby.id','0','0','1','0','0','0','=','input',null,null,'8','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('8b7cf0525519474ebe1de9e587eb7067','6e05c389f3c6415ea34e55e9dfb28934','create_date','创建时间','timestamp(6)','java.util.date','createdate','0','0','1','0','0','0','=','dateselect',null,null,'5','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('8b9de88df53e485d8ef461c4b1824bc1','43d6d5acffa14c258340ce6765e46c6f','user_id','归属用户','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','user.id|name','0','1','1','1','1','1','=','userselect',null,null,'2','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('8da38dbe5fe54e9bb1f9682c27fbf403','aef6f1fc948f4c9ab1c1b780bc471cc2','remarks','备注信息','nvarchar2(255)','string','remarks','0','1','1','1','1','0','=','textarea',null,null,'12','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('92481c16a0b94b0e8bba16c3c54eb1e4','f6e4dafaa72f4c509636484715f33a96','create_date','创建时间','timestamp(6)','java.util.date','createdate','0','0','1','0','0','0','=','dateselect',null,null,'7','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('9a012c1d2f934dbf996679adb7cc827a','f6e4dafaa72f4c509636484715f33a96','parent_id','父级编号','varchar2(64)','this','parent.id|name','0','0','1','1','0','0','=','treeselect',null,null,'2','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('ad3bf0d4b44b4528a5211a66af88f322','aef6f1fc948f4c9ab1c1b780bc471cc2','office_id','归属部门','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.office','office.id|name','0','1','1','1','1','1','=','officeselect',null,null,'3','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('bb1256a8d1b741f6936d8fed06f45eed','f6e4dafaa72f4c509636484715f33a96','update_by','更新者','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.user','updateby.id','0','0','1','1','0','0','=','input',null,null,'8','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('ca68a2d403f0449cbaa1d54198c6f350','43d6d5acffa14c258340ce6765e46c6f','office_id','归属部门','varchar2(64)','com.thinkgem.jeesite.modules.modules.sys.entity.office','office.id|name','0','1','1','1','0','0','=','officeselect',null,null,'3','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('cb9c0ec3da26432d9cbac05ede0fd1d0','43d6d5acffa14c258340ce6765e46c6f','remarks','备注信息','nvarchar2(255)','string','remarks','0','1','1','1','1','0','=','textarea',null,null,'12','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('cfcfa06ea61749c9b4c4dbc507e0e580','f6e4dafaa72f4c509636484715f33a96','id','编号','varchar2(64)','string','id','1','0','1','0','0','0','=','input',null,null,'1','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('d5c2d932ae904aa8a9f9ef34cd36fb0b','43d6d5acffa14c258340ce6765e46c6f','sex','性别','char(1)','string','sex','0','1','1','1','0','1','=','select','sex',null,'6','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('e64050a2ebf041faa16f12dda5dcf784','6e05c389f3c6415ea34e55e9dfb28934','name','名称','nvarchar2(100)','string','name','0','1','1','1','1','1','like','input',null,null,'3','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('e8d11127952d4aa288bb3901fc83127f','43d6d5acffa14c258340ce6765e46c6f','del_flag','删除标记（0：正常；1：删除）','char(1)','string','delflag','0','0','1','0','0','0','=','radiobox','del_flag',null,'13','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('eb2e5afd13f147a990d30e68e7f64e12','aef6f1fc948f4c9ab1c1b780bc471cc2','update_date','更新时间','timestamp(6)','java.util.date','updatedate','0','0','1','1','1','0','=','dateselect',null,null,'11','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0'),('f5ed8c82bad0413fbfcccefa95931358','f6e4dafaa72f4c509636484715f33a96','remarks','备注信息','nvarchar2(255)','string','remarks','0','1','1','1','1','0','=','textarea',null,null,'10','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05',null,'0');

/*table structure for table `gen_template` */

drop table if exists `gen_template`;

create table `gen_template` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `name` varchar(200) collate utf8_bin default null comment '名称',
  `category` varchar(2000) collate utf8_bin default null comment '分类',
  `file_path` varchar(500) collate utf8_bin default null comment '生成文件路径',
  `file_name` varchar(200) collate utf8_bin default null comment '生成文件名',
  `content` text collate utf8_bin comment '内容',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin default null comment '更新者',
  `update_date` datetime default null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记（0：正常；1：删除）',
  primary key (`id`),
  key `gen_template_del_falg` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='代码模板表';

/*data for the table `gen_template` */

/*table structure for table `oa_leave` */

drop table if exists `oa_leave`;

create table `oa_leave` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `process_instance_id` varchar(64) collate utf8_bin default null comment '流程实例编号',
  `start_time` datetime default null comment '开始时间',
  `end_time` datetime default null comment '结束时间',
  `leave_type` varchar(20) collate utf8_bin default null comment '请假类型',
  `reason` varchar(255) collate utf8_bin default null comment '请假理由',
  `apply_time` datetime default null comment '申请时间',
  `reality_start_time` datetime default null comment '实际开始时间',
  `reality_end_time` datetime default null comment '实际结束时间',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `oa_leave_create_by` (`create_by`),
  key `oa_leave_process_instance_id` (`process_instance_id`),
  key `oa_leave_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='请假流程表';

/*data for the table `oa_leave` */

/*table structure for table `oa_notify` */

drop table if exists `oa_notify`;

create table `oa_notify` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `type` char(1) collate utf8_bin default null comment '类型',
  `title` varchar(200) collate utf8_bin default null comment '标题',
  `content` varchar(2000) collate utf8_bin default null comment '内容',
  `files` varchar(2000) collate utf8_bin default null comment '附件',
  `status` char(1) collate utf8_bin default null comment '状态',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `oa_notify_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='通知通告';

/*data for the table `oa_notify` */

/*table structure for table `oa_notify_record` */

drop table if exists `oa_notify_record`;

create table `oa_notify_record` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `oa_notify_id` varchar(64) collate utf8_bin default null comment '通知通告id',
  `user_id` varchar(64) collate utf8_bin default null comment '接受人',
  `read_flag` char(1) collate utf8_bin default '0' comment '阅读标记',
  `read_date` date default null comment '阅读时间',
  primary key (`id`),
  key `oa_notify_record_notify_id` (`oa_notify_id`),
  key `oa_notify_record_user_id` (`user_id`),
  key `oa_notify_record_read_flag` (`read_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='通知通告发送记录';

/*data for the table `oa_notify_record` */

/*table structure for table `oa_test_audit` */

drop table if exists `oa_test_audit`;

create table `oa_test_audit` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `proc_ins_id` varchar(64) collate utf8_bin default null comment '流程实例id',
  `user_id` varchar(64) collate utf8_bin default null comment '变动用户',
  `office_id` varchar(64) collate utf8_bin default null comment '归属部门',
  `post` varchar(255) collate utf8_bin default null comment '岗位',
  `age` char(1) collate utf8_bin default null comment '性别',
  `edu` varchar(255) collate utf8_bin default null comment '学历',
  `content` varchar(255) collate utf8_bin default null comment '调整原因',
  `olda` varchar(255) collate utf8_bin default null comment '现行标准 薪酬档级',
  `oldb` varchar(255) collate utf8_bin default null comment '现行标准 月工资额',
  `oldc` varchar(255) collate utf8_bin default null comment '现行标准 年薪总额',
  `newa` varchar(255) collate utf8_bin default null comment '调整后标准 薪酬档级',
  `newb` varchar(255) collate utf8_bin default null comment '调整后标准 月工资额',
  `newc` varchar(255) collate utf8_bin default null comment '调整后标准 年薪总额',
  `add_num` varchar(255) collate utf8_bin default null comment '月增资',
  `exe_date` varchar(255) collate utf8_bin default null comment '执行时间',
  `hr_text` varchar(255) collate utf8_bin default null comment '人力资源部门意见',
  `lead_text` varchar(255) collate utf8_bin default null comment '分管领导意见',
  `main_lead_text` varchar(255) collate utf8_bin default null comment '集团主要领导意见',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `oa_test_audit_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='审批流程测试表';

/*data for the table `oa_test_audit` */

/*table structure for table `sys_area` */

drop table if exists `sys_area`;

create table `sys_area` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `name` varchar(100) collate utf8_bin not null comment '名称',
  `sort` decimal(10,0) not null comment '排序',
  `code` varchar(100) collate utf8_bin default null comment '区域编码',
  `type` char(1) collate utf8_bin default null comment '区域类型',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_area_parent_id` (`parent_id`),
  key `sys_area_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='区域表';

/*data for the table `sys_area` */

insert  into `sys_area`(`id`,`parent_id`,`parent_ids`,`name`,`sort`,`code`,`type`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','0','0,','中国','10','100000','1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','0,1,','山东省','20','110000','2','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','2','0,1,2,','济南市','30','110101','3','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','3','0,1,2,3,','历城区','40','110102','4','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','3','0,1,2,3,','历下区','50','110104','4','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','3','0,1,2,3,','高新区','60','110105','4','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `sys_dict` */

drop table if exists `sys_dict`;

create table `sys_dict` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `value` varchar(100) collate utf8_bin not null comment '数据值',
  `label` varchar(100) collate utf8_bin not null comment '标签名',
  `type` varchar(100) collate utf8_bin not null comment '类型',
  `description` varchar(100) collate utf8_bin not null comment '描述',
  `sort` decimal(10,0) not null comment '排序（升序）',
  `parent_id` varchar(64) collate utf8_bin default '0' comment '父级编号',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_dict_value` (`value`),
  key `sys_dict_label` (`label`),
  key `sys_dict_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='字典表';

/*data for the table `sys_dict` */

insert  into `sys_dict`(`id`,`value`,`label`,`type`,`description`,`sort`,`parent_id`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','0','正常','del_flag','删除标记','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','yellow','黄色','color','颜色值','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('100','java.util.date','date','gen_java_type','java类型\0\0','50','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('101','com.thinkgem.jeesite.modules.sys.entity.user','user','gen_java_type','java类型\0\0','60','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('102','com.thinkgem.jeesite.modules.sys.entity.office','office','gen_java_type','java类型\0\0','70','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('103','com.thinkgem.jeesite.modules.sys.entity.area','area','gen_java_type','java类型\0\0','80','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('104','custom','custom','gen_java_type','java类型\0\0','90','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('105','1','会议通告\0\0\0\0','oa_notify_type','通知通告类型','10','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('106','2','奖惩通告\0\0\0\0','oa_notify_type','通知通告类型','20','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('107','3','活动通告\0\0\0\0','oa_notify_type','通知通告类型','30','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('108','0','草稿','oa_notify_status','通知通告状态','10','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('109','1','发布','oa_notify_status','通知通告状态','20','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('11','orange','橙色','color','颜色值','50','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('110','0','未读','oa_notify_read','通知通告状态','10','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('111','1','已读','oa_notify_read','通知通告状态','20','0','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('12','default','默认主题','theme','主题方案','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','cerulean','天蓝主题','theme','主题方案','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('14','readable','橙色主题','theme','主题方案','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('15','united','红色主题','theme','主题方案','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('16','flat','flat主题','theme','主题方案','60','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('17','1','国家','sys_area_type','区域类型','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('18','2','省份、直辖市','sys_area_type','区域类型','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('19','3','地市','sys_area_type','区域类型','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','删除','del_flag','删除标记','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('20','4','区县','sys_area_type','区域类型','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('21','1','公司','sys_office_type','机构类型','60','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('22','2','部门','sys_office_type','机构类型','70','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('23','3','小组','sys_office_type','机构类型','80','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('24','4','其它','sys_office_type','机构类型','90','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('25','1','综合部','sys_office_common','快捷通用部门','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('26','2','开发部','sys_office_common','快捷通用部门','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('27','3','人力部','sys_office_common','快捷通用部门','50','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('28','1','一级','sys_office_grade','机构等级','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('29','2','二级','sys_office_grade','机构等级','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','1','显示','show_hide','显示/隐藏','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('30','3','三级','sys_office_grade','机构等级','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('31','4','四级','sys_office_grade','机构等级','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('32','1','所有数据','sys_data_scope','数据范围','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('33','2','所在公司及以下数据','sys_data_scope','数据范围','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('34','3','所在公司数据','sys_data_scope','数据范围','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('35','4','所在部门及以下数据','sys_data_scope','数据范围','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('36','5','所在部门数据','sys_data_scope','数据范围','50','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('37','8','仅本人数据','sys_data_scope','数据范围','90','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('38','9','按明细设置','sys_data_scope','数据范围','100','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('39','1','系统管理','sys_user_type','用户类型','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','0','隐藏','show_hide','显示/隐藏','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('40','2','部门经理','sys_user_type','用户类型','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('41','3','普通用户','sys_user_type','用户类型','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('42','basic','基础主题','cms_theme','站点主题','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('43','blue','蓝色主题','cms_theme','站点主题','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('44','red','红色主题','cms_theme','站点主题','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('45','article','文章模型','cms_module','栏目模型','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('46','picture','图片模型','cms_module','栏目模型','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('47','download','下载模型','cms_module','栏目模型','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('48','link','链接模型','cms_module','栏目模型','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('49','special','专题模型','cms_module','栏目模型','50','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('5','1','是','yes_no','是/否','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('50','0','默认展现方式','cms_show_modes','展现方式','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('51','1','首栏目内容列表','cms_show_modes','展现方式','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('52','2','栏目第一条内容','cms_show_modes','展现方式','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('53','0','发布','cms_del_flag','内容状态','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('54','1','删除','cms_del_flag','内容状态','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('55','2','审核','cms_del_flag','内容状态','15','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('56','1','首页焦点图','cms_posid','推荐位','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('57','2','栏目页文章推荐','cms_posid','推荐位','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('58','1','咨询','cms_guestbook','留言板分类','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('59','2','建议','cms_guestbook','留言板分类','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','0','否','yes_no','是/否','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('60','3','投诉','cms_guestbook','留言板分类','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('61','4','其它','cms_guestbook','留言板分类','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('62','1','公休','oa_leave_type','请假类型','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('63','2','病假','oa_leave_type','请假类型','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('64','3','事假','oa_leave_type','请假类型','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('65','4','调休','oa_leave_type','请假类型','40','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('66','5','婚假','oa_leave_type','请假类型','60','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('67','1','接入日志','sys_log_type','日志类型','30','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('68','2','异常日志','sys_log_type','日志类型','40','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('69','leave','请假流程','act_type','流程类型','10','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('7','red','红色','color','颜色值','10','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('70','test_audit','审批测试流程','act_type','流程类型','20','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('71','1','分类1','act_category','流程分类','10','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('72','2','分类2','act_category','流程分类','20','0','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('73','crud','增删改查','gen_category','代码生成分类','10','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('74','crud_many','增删改查（包含从表）','gen_category','代码生成分类','20','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('75','tree','树结构','gen_category','代码生成分类','30','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('76','=','=','gen_query_type','查询方式','10','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('77','!=','!=','gen_query_type','查询方式','20','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('78','&gt;','&gt;','gen_query_type','查询方式','30','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('79','&lt;','&lt;','gen_query_type','查询方式','40','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('8','green','绿色','color','颜色值','20','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('80','between','between','gen_query_type','查询方式','50','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('81','like','like','gen_query_type','查询方式','60','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('82','left_like','left like','gen_query_type','查询方式','70','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('83','right_like','right like','gen_query_type','查询方式','80','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('84','input','文本框','gen_show_type','字段生成方案','10','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('85','textarea','文本域','gen_show_type','字段生成方案','20','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('86','select','下拉框','gen_show_type','字段生成方案','30','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('87','checkbox','复选框','gen_show_type','字段生成方案','40','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('88','radiobox','单选框','gen_show_type','字段生成方案','50','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('89','dateselect','日期选择','gen_show_type','字段生成方案','60','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('9','blue','蓝色','color','颜色值','30','0','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('90','userselect','人员选择\0','gen_show_type','字段生成方案','70','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('91','officeselect','部门选择','gen_show_type','字段生成方案','80','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('92','areaselect','区域选择','gen_show_type','字段生成方案','90','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('93','string','string','gen_java_type','java类型','10','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('94','long','long','gen_java_type','java类型','20','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('95','dao','仅持久层','gen_category','代码生成分类\0\0\0\0\0\0','40','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('96','1','男','sex','性别','10','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'0'),('97','2','女','sex','性别','20','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'0'),('98','integer','integer','gen_java_type','java类型\0\0','30','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1'),('99','double','double','gen_java_type','java类型\0\0','40','0','1','2013-10-28 08:00:00','1','2013-10-28 08:00:00',null,'1');

/*table structure for table `sys_log` */

drop table if exists `sys_log`;

create table `sys_log` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `type` char(1) collate utf8_bin default '1' comment '日志类型',
  `title` varchar(255) collate utf8_bin default '' comment '日志标题',
  `create_by` varchar(64) collate utf8_bin default null comment '创建者',
  `create_date` datetime default null comment '创建时间',
  `remote_addr` varchar(255) collate utf8_bin default null comment '操作ip地址',
  `user_agent` varchar(255) collate utf8_bin default null comment '用户代理',
  `request_uri` varchar(255) collate utf8_bin default null comment '请求uri',
  `method` varchar(5) collate utf8_bin default null comment '操作方式',
  `params` text collate utf8_bin comment '操作提交的数据',
  `exception` text collate utf8_bin comment '异常信息',
  primary key (`id`),
  key `sys_log_create_by` (`create_by`),
  key `sys_log_request_uri` (`request_uri`),
  key `sys_log_type` (`type`),
  key `sys_log_create_date` (`create_date`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='日志表';

/*data for the table `sys_log` */

/*table structure for table `sys_mdict` */

drop table if exists `sys_mdict`;

create table `sys_mdict` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `name` varchar(100) collate utf8_bin not null comment '名称',
  `sort` decimal(10,0) not null comment '排序',
  `description` varchar(100) collate utf8_bin default null comment '描述',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_mdict_parent_id` (`parent_id`),
  key `sys_mdict_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='多级字典表';

/*data for the table `sys_mdict` */

/*table structure for table `sys_menu` */

drop table if exists `sys_menu`;

create table `sys_menu` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `name` varchar(100) collate utf8_bin not null comment '名称',
  `sort` decimal(10,0) not null comment '排序',
  `href` varchar(2000) collate utf8_bin default null comment '链接',
  `target` varchar(20) collate utf8_bin default null comment '目标',
  `icon` varchar(100) collate utf8_bin default null comment '图标',
  `is_show` char(1) collate utf8_bin not null comment '是否在菜单中显示',
  `permission` varchar(200) collate utf8_bin default null comment '权限标识',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_menu_parent_id` (`parent_id`),
  key `sys_menu_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='菜单表';

/*data for the table `sys_menu` */

insert  into `sys_menu`(`id`,`parent_id`,`parent_ids`,`name`,`sort`,`href`,`target`,`icon`,`is_show`,`permission`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('0b2ebd4d639e4c2b83c2dd0764522f24','ba8092291b40482db8fe7fc006ea3d76','0,1,79,3c92c17886944d0687e73e286cada573,ba8092291b40482db8fe7fc006ea3d76,','编辑','60','','','','0','test:testdata:edit','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('0ca004d6b1bf4bcab9670a5060d82a55','3c92c17886944d0687e73e286cada573','0,1,79,3c92c17886944d0687e73e286cada573,','树结构','90','/test/testtree','','','1','','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('1','0','0,','功能菜单','0',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','3','0,1,2,3,','字典管理','60','/sys/dict/',null,'th-list','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','10','0,1,2,3,10,','查看','30',null,null,null,'0','sys:dict:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','10','0,1,2,3,10,','修改','40',null,null,null,'0','sys:dict:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','2','0,1,2,','机构用户','970',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('14','13','0,1,2,13,','区域管理','50','/sys/area/',null,'th','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('15','14','0,1,2,13,14,','查看','30',null,null,null,'0','sys:area:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('16','14','0,1,2,13,14,','修改','40',null,null,null,'0','sys:area:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('17','13','0,1,2,13,','机构管理','40','/sys/office/',null,'th-large','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('18','17','0,1,2,13,17,','查看','30',null,null,null,'0','sys:office:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('19','17','0,1,2,13,17,','修改','40',null,null,null,'0','sys:office:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','0,1,','系统设置','900',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('20','13','0,1,2,13,','用户管理','30','/sys/user/index',null,'user','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('21','20','0,1,2,13,20,','查看','30',null,null,null,'0','sys:user:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('22','20','0,1,2,13,20,','修改','40',null,null,null,'0','sys:user:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('23','2','0,1,2,','关于帮助','990',null,null,null,'0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('24','23','0,1,2,23','官方首页','30','http://jeesite.com','_blank',null,'0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('25','23','0,1,2,23','项目支持','50','http://jeesite.com/donation.html','_blank',null,'0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('26','23','0,1,2,23','论坛交流','80','http://bbs.jeesite.com','_blank',null,'0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'1'),('27','1','0,1,','我的面板','100',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('28','27','0,1,27,','个人信息','30',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('29','28','0,1,27,28,','个人信息','30','/sys/user/info',null,'user','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','2','0,1,2,','系统设置','980',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('30','28','0,1,27,28,','修改密码','40','/sys/user/modifypwd',null,'lock','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('31','1','0,1,','内容管理','500',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('32','31','0,1,31,','栏目设置','990',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('33','32','0,1,31,32','栏目管理','30','/cms/category/',null,'align-justify','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('34','33','0,1,31,32,33,','查看','30',null,null,null,'0','cms:category:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('35','33','0,1,31,32,33,','修改','40',null,null,null,'0','cms:category:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('36','32','0,1,31,32','站点设置','40','/cms/site/',null,'certificate','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('37','36','0,1,31,32,36,','查看','30',null,null,null,'0','cms:site:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('38','36','0,1,31,32,36,','修改','40',null,null,null,'0','cms:site:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('39','32','0,1,31,32','切换站点','50','/cms/site/select',null,'retweet','1','cms:site:select','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3c92c17886944d0687e73e286cada573','79','0,1,79,','生成示例','120','','','','1','','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('4','3','0,1,2,3,','菜单管理','30','/sys/menu/',null,'list-alt','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('40','31','0,1,31,','内容管理','500',null,null,null,'1','cms:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('41','40','0,1,31,40,','内容发布','30','/cms/',null,'briefcase','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('42','41','0,1,31,40,41,','文章模型','40','/cms/article/',null,'file','0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('43','42','0,1,31,40,41,42,','查看','30',null,null,null,'0','cms:article:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('44','42','0,1,31,40,41,42,','修改','40',null,null,null,'0','cms:article:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('45','42','0,1,31,40,41,42,','审核','50',null,null,null,'0','cms:article:audit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('46','41','0,1,31,40,41,','链接模型','60','/cms/link/',null,'random','0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('47','46','0,1,31,40,41,46,','查看','30',null,null,null,'0','cms:link:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('48','46','0,1,31,40,41,46,','修改','40',null,null,null,'0','cms:link:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4855cf3b25c244fb8500a380db189d97','b1f6d1b86ba24365bae7fd86c5082317','0,1,79,3c92c17886944d0687e73e286cada573,b1f6d1b86ba24365bae7fd86c5082317,','查看','30','','','','0','test:testdatamain:view','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('49','46','0,1,31,40,41,46,','审核','50',null,null,null,'0','cms:link:audit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','4','0,1,2,3,4,','查看','30',null,null,null,'0','sys:menu:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('50','40','0,1,31,40,','评论管理','40','/cms/comment/?status=2',null,'comment','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('51','50','0,1,31,40,50,','查看','30',null,null,null,'0','cms:comment:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('52','50','0,1,31,40,50,','审核','40',null,null,null,'0','cms:comment:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('53','40','0,1,31,40,','公共留言','80','/cms/guestbook/?status=2',null,'glass','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('54','53','0,1,31,40,53,','查看','30',null,null,null,'0','cms:guestbook:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('55','53','0,1,31,40,53,','审核','40',null,null,null,'0','cms:guestbook:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('56','71','0,1,27,71,','文件管理','90','/../static/ckfinder/ckfinder.html',null,'folder-open','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('57','56','0,1,27,40,56,','查看','30',null,null,null,'0','cms:ckfinder:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('58','56','0,1,27,40,56,','上传','40',null,null,null,'0','cms:ckfinder:upload','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('59','56','0,1,27,40,56,','修改','50',null,null,null,'0','cms:ckfinder:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','4','0,1,2,3,4,','修改','40',null,null,null,'0','sys:menu:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('60','31','0,1,31,','统计分析','600',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('61','60','0,1,31,60,','信息量统计','30','/cms/stats/article',null,'tasks','1','cms:stats:article','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('62','1','0,1,','在线办公','200',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('63','62','0,1,62,','个人办公','30',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('64','63','0,1,62,63,','请假办理','300','/oa/leave',null,'leaf','0',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('65','64','0,1,62,63,64,','查看','30',null,null,null,'0','oa:leave:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('66','64','0,1,62,63,64,','修改','40',null,null,null,'0','oa:leave:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('67','2','0,1,2,','日志查询','985',null,null,null,'1',null,'1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('68','67','0,1,2,67,','日志查询','30','/sys/log',null,'pencil','1','sys:log:view','1','2013-06-03 08:00:00','1','2013-06-03 08:00:00',null,'0'),('69','62','0,1,62,','流程管理','300',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','3','0,1,2,3,','角色管理','50','/sys/role/',null,'lock','1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('70','69','0,1,62,69,','流程管理','50','/act/process',null,'road','1','act:process:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('71','27','0,1,27,','文件管理','90',null,null,null,'1',null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('72','69','0,1,62,69,','模型管理','100','/act/model',null,'road','1','act:model:edit','1','2013-09-20 08:00:00','1','2013-09-20 08:00:00',null,'0'),('73','63','0,1,62,63,','我的任务','50','/act/task/todo/',null,'tasks','1',null,'1','2013-09-24 08:00:00','1','2013-09-24 08:00:00',null,'0'),('74','63','0,1,62,63,','审批测试','100','/oa/testaudit',null,null,'1','oa:testaudit:view,oa:testaudit:edit','1','2013-09-24 08:00:00','1','2013-09-24 08:00:00',null,'0'),('75','1','0,1,','在线演示','3000',null,null,null,'1',null,'1','2013-10-08 08:00:00','1','2013-10-08 08:00:00',null,'1'),('79','1','0,1,','代码生成','5000',null,null,null,'1',null,'1','2013-10-16 08:00:00','1','2013-10-16 08:00:00',null,'0'),('8','7','0,1,2,3,7,','查看','30',null,null,null,'0','sys:role:view','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('80','79','0,1,79,','代码生成','50',null,null,null,'1',null,'1','2013-10-16 08:00:00','1','2013-10-16 08:00:00',null,'0'),('81','80','0,1,79,80,','生成方案配置','30','/gen/genscheme',null,null,'1','gen:genscheme:view,gen:genscheme:edit','1','2013-10-16 08:00:00','1','2013-10-16 08:00:00',null,'0'),('82','80','0,1,79,80,','业务表配置','20','/gen/gentable',null,null,'1','gen:gentable:view,gen:gentable:edit,gen:gentablecolumn:view,gen:gentablecolumn:edit','1','2013-10-16 08:00:00','1','2013-10-16 08:00:00',null,'0'),('83','80','0,1,79,80,','代码模板管理','90','/gen/gentemplate',null,null,'1','gen:gentemplate:view,gen:gentemplate:edit','1','2013-10-16 08:00:00','1','2013-10-16 08:00:00',null,'1'),('84','67','0,1,2,67,','连接池监视','40','/../druid',null,null,'1',null,'1','2013-10-18 08:00:00','1','2013-10-18 08:00:00',null,'0'),('85','76','0,1,75,76,','行政区域','80','/../static/map/map-city.html',null,null,'1',null,'1','2013-10-22 08:00:00','1','2013-10-22 08:00:00',null,'0'),('86','75','0,1,75,','组件演示','50',null,null,null,'1',null,'1','2013-10-22 08:00:00','1','2013-10-22 08:00:00',null,'1'),('87','86','0,1,75,86,','组件演示','30','/test/test/form',null,null,'1','test:test:view,test:test:edit','1','2013-10-22 08:00:00','1','2013-10-22 08:00:00',null,'1'),('88','62','0,1,62,','通知通告','20','','','','1','','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('89','88','0,1,62,88,','我的通告','30','/oa/oanotify/self','','','1','','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('9','7','0,1,2,3,7,','修改','40',null,null,null,'0','sys:role:edit','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('90','88','0,1,62,88,','通告管理','50','/oa/oanotify','','','1','oa:oanotify:view,oa:oanotify:edit','1','2013-11-08 08:00:00','1','2013-11-08 08:00:00',null,'0'),('afab2db430e2457f9cf3a11feaa8b869','0ca004d6b1bf4bcab9670a5060d82a55','0,1,79,3c92c17886944d0687e73e286cada573,0ca004d6b1bf4bcab9670a5060d82a55,','编辑','60','','','','0','test:testtree:edit','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('b1f6d1b86ba24365bae7fd86c5082317','3c92c17886944d0687e73e286cada573','0,1,79,3c92c17886944d0687e73e286cada573,','主子表','60','/test/testdatamain','','','1','','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('ba8092291b40482db8fe7fc006ea3d76','3c92c17886944d0687e73e286cada573','0,1,79,3c92c17886944d0687e73e286cada573,','单表','30','/test/testdata','','','1','','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('c2e4d9082a0b4386884a0b203afe2c5c','0ca004d6b1bf4bcab9670a5060d82a55','0,1,79,3c92c17886944d0687e73e286cada573,0ca004d6b1bf4bcab9670a5060d82a55,','查看','30','','','','0','test:testtree:view','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('d15ec45a4c5449c3bbd7a61d5f9dd1d2','b1f6d1b86ba24365bae7fd86c5082317','0,1,79,3c92c17886944d0687e73e286cada573,b1f6d1b86ba24365bae7fd86c5082317,','编辑','60','','','','0','test:testdatamain:edit','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0'),('df7ce823c5b24ff9bada43d992f373e2','ba8092291b40482db8fe7fc006ea3d76','0,1,79,3c92c17886944d0687e73e286cada573,ba8092291b40482db8fe7fc006ea3d76,','查看','30','','','','0','test:testdata:view','1','2013-08-12 13:10:05','1','2013-08-12 13:10:05','','0');

/*table structure for table `sys_office` */

drop table if exists `sys_office`;

create table `sys_office` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `name` varchar(100) collate utf8_bin not null comment '名称',
  `sort` decimal(10,0) not null comment '排序',
  `area_id` varchar(64) collate utf8_bin not null comment '归属区域',
  `code` varchar(100) collate utf8_bin default null comment '区域编码',
  `type` char(1) collate utf8_bin not null comment '机构类型',
  `grade` char(1) collate utf8_bin not null comment '机构等级',
  `address` varchar(255) collate utf8_bin default null comment '联系地址',
  `zip_code` varchar(100) collate utf8_bin default null comment '邮政编码',
  `master` varchar(100) collate utf8_bin default null comment '负责人',
  `phone` varchar(200) collate utf8_bin default null comment '电话',
  `fax` varchar(200) collate utf8_bin default null comment '传真',
  `email` varchar(200) collate utf8_bin default null comment '邮箱',
  `useable` varchar(64) collate utf8_bin default null comment '是否启用',
  `primary_person` varchar(64) collate utf8_bin default null comment '主负责人',
  `deputy_person` varchar(64) collate utf8_bin default null comment '副负责人',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_office_parent_id` (`parent_id`),
  key `sys_office_del_flag` (`del_flag`),
  key `sys_office_type` (`type`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='机构表';

/*data for the table `sys_office` */

insert  into `sys_office`(`id`,`parent_id`,`parent_ids`,`name`,`sort`,`area_id`,`code`,`type`,`grade`,`address`,`zip_code`,`master`,`phone`,`fax`,`email`,`useable`,`primary_person`,`deputy_person`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','0','0,','山东省总公司','10','2','100000','1','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('10','7','0,1,7,','市场部','30','3','200003','2','2',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','7','0,1,7,','技术部','40','3','200004','2','2',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','7','0,1,7,','历城区分公司','0','4','201000','1','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','12','0,1,7,12,','公司领导','10','4','201001','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('14','12','0,1,7,12,','综合部','20','4','201002','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('15','12','0,1,7,12,','市场部','30','4','201003','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('16','12','0,1,7,12,','技术部','40','4','201004','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('17','7','0,1,7,','历下区分公司','40','5','201010','1','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('18','17','0,1,7,17,','公司领导','10','5','201011','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('19','17','0,1,7,17,','综合部','20','5','201012','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','0,1,','公司领导','10','2','100001','2','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('20','17','0,1,7,17,','市场部','30','5','201013','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('21','17','0,1,7,17,','技术部','40','5','201014','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('22','7','0,1,7,','高新区分公司','50','6','201010','1','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('23','22','0,1,7,22,','公司领导','10','6','201011','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('24','22','0,1,7,22,','综合部','20','6','201012','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('25','22','0,1,7,22,','市场部','30','6','201013','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('26','22','0,1,7,22,','技术部','40','6','201014','2','3',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','1','0,1,','综合部','20','2','100002','2','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','1','0,1,','市场部','30','2','100003','2','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','1','0,1,','技术部','40','2','100004','2','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','1','0,1,','研发部','50','2','100005','2','1',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','1','0,1,','济南市分公司','20','3','200000','1','2',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('8','7','0,1,7,','公司领导','10','3','200001','2','2',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('9','7','0,1,7,','综合部','20','3','200002','2','2',null,null,null,null,null,null,'1',null,null,'1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `sys_role` */

drop table if exists `sys_role`;

create table `sys_role` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `office_id` varchar(64) collate utf8_bin default null comment '归属机构',
  `name` varchar(100) collate utf8_bin not null comment '角色名称',
  `enname` varchar(255) collate utf8_bin default null comment '英文名称',
  `role_type` varchar(255) collate utf8_bin default null comment '角色类型',
  `data_scope` char(1) collate utf8_bin default null comment '数据范围',
  `is_sys` varchar(64) collate utf8_bin default null comment '是否系统数据',
  `useable` varchar(64) collate utf8_bin default null comment '是否可用',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_role_del_flag` (`del_flag`),
  key `sys_role_enname` (`enname`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='角色表';

/*data for the table `sys_role` */

insert  into `sys_role`(`id`,`office_id`,`name`,`enname`,`role_type`,`data_scope`,`is_sys`,`useable`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','1','系统管理员','dept','assignment','1',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','公司管理员','hr','assignment','2',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','1','本公司管理员','a','assignment','3',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','1','部门管理员','b','assignment','4',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','1','本部门管理员','c','assignment','5',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','1','普通用户','d','assignment','8',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','7','济南市管理员','e','assignment','9',null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `sys_role_menu` */

drop table if exists `sys_role_menu`;

create table `sys_role_menu` (
  `role_id` varchar(64) collate utf8_bin not null comment '角色编号',
  `menu_id` varchar(64) collate utf8_bin not null comment '菜单编号',
  primary key (`role_id`,`menu_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='角色-菜单';

/*data for the table `sys_role_menu` */

insert  into `sys_role_menu`(`role_id`,`menu_id`) values ('1','1'),('1','10'),('1','11'),('1','12'),('1','13'),('1','14'),('1','15'),('1','16'),('1','17'),('1','18'),('1','19'),('1','2'),('1','20'),('1','21'),('1','22'),('1','23'),('1','24'),('1','25'),('1','26'),('1','27'),('1','28'),('1','29'),('1','3'),('1','30'),('1','31'),('1','32'),('1','33'),('1','34'),('1','35'),('1','36'),('1','37'),('1','38'),('1','39'),('1','4'),('1','40'),('1','41'),('1','42'),('1','43'),('1','44'),('1','45'),('1','46'),('1','47'),('1','48'),('1','49'),('1','5'),('1','50'),('1','51'),('1','52'),('1','53'),('1','54'),('1','55'),('1','56'),('1','57'),('1','58'),('1','59'),('1','6'),('1','60'),('1','61'),('1','62'),('1','63'),('1','64'),('1','65'),('1','66'),('1','67'),('1','68'),('1','69'),('1','7'),('1','70'),('1','71'),('1','72'),('1','73'),('1','74'),('1','75'),('1','76'),('1','77'),('1','78'),('1','79'),('1','8'),('1','80'),('1','81'),('1','82'),('1','83'),('1','84'),('1','85'),('1','86'),('1','87'),('1','88'),('1','89'),('1','9'),('1','90'),('2','1'),('2','10'),('2','11'),('2','12'),('2','13'),('2','14'),('2','15'),('2','16'),('2','17'),('2','18'),('2','19'),('2','2'),('2','20'),('2','21'),('2','22'),('2','23'),('2','24'),('2','25'),('2','26'),('2','27'),('2','28'),('2','29'),('2','3'),('2','30'),('2','31'),('2','32'),('2','33'),('2','34'),('2','35'),('2','36'),('2','37'),('2','38'),('2','39'),('2','4'),('2','40'),('2','41'),('2','42'),('2','43'),('2','44'),('2','45'),('2','46'),('2','47'),('2','48'),('2','49'),('2','5'),('2','50'),('2','51'),('2','52'),('2','53'),('2','54'),('2','55'),('2','56'),('2','57'),('2','58'),('2','59'),('2','6'),('2','60'),('2','61'),('2','62'),('2','63'),('2','64'),('2','65'),('2','66'),('2','67'),('2','68'),('2','69'),('2','7'),('2','70'),('2','71'),('2','72'),('2','73'),('2','74'),('2','75'),('2','76'),('2','77'),('2','78'),('2','79'),('2','8'),('2','80'),('2','81'),('2','82'),('2','83'),('2','84'),('2','85'),('2','86'),('2','87'),('2','88'),('2','89'),('2','9'),('2','90'),('3','1'),('3','10'),('3','11'),('3','12'),('3','13'),('3','14'),('3','15'),('3','16'),('3','17'),('3','18'),('3','19'),('3','2'),('3','20'),('3','21'),('3','22'),('3','23'),('3','24'),('3','25'),('3','26'),('3','27'),('3','28'),('3','29'),('3','3'),('3','30'),('3','31'),('3','32'),('3','33'),('3','34'),('3','35'),('3','36'),('3','37'),('3','38'),('3','39'),('3','4'),('3','40'),('3','41'),('3','42'),('3','43'),('3','44'),('3','45'),('3','46'),('3','47'),('3','48'),('3','49'),('3','5'),('3','50'),('3','51'),('3','52'),('3','53'),('3','54'),('3','55'),('3','56'),('3','57'),('3','58'),('3','59'),('3','6'),('3','60'),('3','61'),('3','62'),('3','63'),('3','64'),('3','65'),('3','66'),('3','67'),('3','68'),('3','69'),('3','7'),('3','70'),('3','71'),('3','72'),('3','73'),('3','74'),('3','75'),('3','76'),('3','77'),('3','78'),('3','79'),('3','8'),('3','80'),('3','81'),('3','82'),('3','83'),('3','84'),('3','85'),('3','86'),('3','87'),('3','88'),('3','89'),('3','9'),('3','90');

/*table structure for table `sys_role_office` */

drop table if exists `sys_role_office`;

create table `sys_role_office` (
  `role_id` varchar(64) collate utf8_bin not null comment '角色编号',
  `office_id` varchar(64) collate utf8_bin not null comment '机构编号',
  primary key (`role_id`,`office_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='角色-机构';

/*data for the table `sys_role_office` */

insert  into `sys_role_office`(`role_id`,`office_id`) values ('7','10'),('7','11'),('7','12'),('7','13'),('7','14'),('7','15'),('7','16'),('7','17'),('7','18'),('7','19'),('7','20'),('7','21'),('7','22'),('7','23'),('7','24'),('7','25'),('7','26'),('7','7'),('7','8'),('7','9');

/*table structure for table `sys_user` */

drop table if exists `sys_user`;

create table `sys_user` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `company_id` varchar(64) collate utf8_bin not null comment '归属公司',
  `office_id` varchar(64) collate utf8_bin not null comment '归属部门',
  `login_name` varchar(100) collate utf8_bin not null comment '登录名',
  `password` varchar(100) collate utf8_bin not null comment '密码',
  `no` varchar(100) collate utf8_bin default null comment '工号',
  `name` varchar(100) collate utf8_bin not null comment '姓名',
  `email` varchar(200) collate utf8_bin default null comment '邮箱',
  `phone` varchar(200) collate utf8_bin default null comment '电话',
  `mobile` varchar(200) collate utf8_bin default null comment '手机',
  `user_type` char(1) collate utf8_bin default null comment '用户类型',
  `photo` varchar(1000) collate utf8_bin default null comment '用户头像',
  `login_ip` varchar(100) collate utf8_bin default null comment '最后登陆ip',
  `login_date` datetime default null comment '最后登陆时间',
  `login_flag` varchar(64) collate utf8_bin default null comment '是否可登录',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `sys_user_office_id` (`office_id`),
  key `sys_user_login_name` (`login_name`),
  key `sys_user_company_id` (`company_id`),
  key `sys_user_update_date` (`update_date`),
  key `sys_user_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='用户表';

/*data for the table `sys_user` */

insert  into `sys_user`(`id`,`company_id`,`office_id`,`login_name`,`password`,`no`,`name`,`email`,`phone`,`mobile`,`user_type`,`photo`,`login_ip`,`login_date`,`login_flag`,`create_by`,`create_date`,`update_by`,`update_date`,`remarks`,`del_flag`) values ('1','1','2','thinkgem','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0001','系统管理员','thinkgem@163.com','8675','8675',null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00','最高管理员','0'),('10','7','11','jn_jsb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0010','济南技术部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('11','12','13','lc_admin','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0011','济南历城领导',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('12','12','18','lx_admin','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0012','济南历下领导',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('13','22','23','gx_admin','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0013','济南高新领导',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('2','1','2','sd_admin','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0002','管理员',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('3','1','3','sd_zhb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0003','综合部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('4','1','4','sd_scb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0004','市场部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('5','1','5','sd_jsb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0005','技术部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('6','1','6','sd_yfb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0006','研发部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('7','7','8','jn_admin','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0007','济南领导',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('8','7','9','jn_zhb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0008','济南综合部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0'),('9','7','10','jn_scb','02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032','0009','济南市场部',null,null,null,null,null,null,null,'1','1','2013-05-27 08:00:00','1','2013-05-27 08:00:00',null,'0');

/*table structure for table `sys_user_role` */

drop table if exists `sys_user_role`;

create table `sys_user_role` (
  `user_id` varchar(64) collate utf8_bin not null comment '用户编号',
  `role_id` varchar(64) collate utf8_bin not null comment '角色编号',
  primary key (`user_id`,`role_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='用户-角色';

/*data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`) values ('1','1'),('1','2'),('10','2'),('11','3'),('12','4'),('13','5'),('14','6'),('2','1'),('3','2'),('4','3'),('5','4'),('6','5'),('7','2'),('7','7'),('8','2'),('9','1');

/*table structure for table `test_data` */

drop table if exists `test_data`;

create table `test_data` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `user_id` varchar(64) collate utf8_bin default null comment '归属用户',
  `office_id` varchar(64) collate utf8_bin default null comment '归属部门',
  `area_id` varchar(64) collate utf8_bin default null comment '归属区域',
  `name` varchar(100) collate utf8_bin default null comment '名称',
  `sex` char(1) collate utf8_bin default null comment '性别',
  `in_date` date default null comment '加入日期',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `test_data_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='业务数据表';

/*data for the table `test_data` */

/*table structure for table `test_data_child` */

drop table if exists `test_data_child`;

create table `test_data_child` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `test_data_main_id` varchar(64) collate utf8_bin default null comment '业务主表id',
  `name` varchar(100) collate utf8_bin default null comment '名称',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `test_data_child_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='业务数据子表';

/*data for the table `test_data_child` */

/*table structure for table `test_data_main` */

drop table if exists `test_data_main`;

create table `test_data_main` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `user_id` varchar(64) collate utf8_bin default null comment '归属用户',
  `office_id` varchar(64) collate utf8_bin default null comment '归属部门',
  `area_id` varchar(64) collate utf8_bin default null comment '归属区域',
  `name` varchar(100) collate utf8_bin default null comment '名称',
  `sex` char(1) collate utf8_bin default null comment '性别',
  `in_date` date default null comment '加入日期',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `test_data_main_del_flag` (`del_flag`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='业务数据表';

/*data for the table `test_data_main` */

/*table structure for table `test_tree` */

drop table if exists `test_tree`;

create table `test_tree` (
  `id` varchar(64) collate utf8_bin not null comment '编号',
  `parent_id` varchar(64) collate utf8_bin not null comment '父级编号',
  `parent_ids` varchar(2000) collate utf8_bin not null comment '所有父级编号',
  `name` varchar(100) collate utf8_bin not null comment '名称',
  `sort` decimal(10,0) not null comment '排序',
  `create_by` varchar(64) collate utf8_bin not null comment '创建者',
  `create_date` datetime not null comment '创建时间',
  `update_by` varchar(64) collate utf8_bin not null comment '更新者',
  `update_date` datetime not null comment '更新时间',
  `remarks` varchar(255) collate utf8_bin default null comment '备注信息',
  `del_flag` char(1) collate utf8_bin not null default '0' comment '删除标记',
  primary key (`id`),
  key `test_tree_del_flag` (`del_flag`),
  key `test_data_parent_id` (`parent_id`)
) engine=innodb default charset=utf8 collate=utf8_bin comment='树结构表';

/*data for the table `test_tree` */

/*!40101 set sql_mode=@old_sql_mode */;
/*!40014 set foreign_key_checks=@old_foreign_key_checks */;
/*!40014 set unique_checks=@old_unique_checks */;
/*!40111 set sql_notes=@old_sql_notes */;
