<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>工作台</title>
    <meta name="decorator" content="default"/>
    <script src="${pageContext.request.contextPath}/assets/jquery/jquery-1.8.3.js"></script>
    <script src="${pageContext.request.contextPath}/assets/highcharts/highcharts.js"></script>
    <script src="${pageContext.request.contextPath}/assets/highcharts/exporting.js"></script>
    <script src="${pageContext.request.contextPath}/assets/highcharts/highcharts-zh_CN.js"></script>
    <script src="${pageContext.request.contextPath}/assets/My97DatePicker/WdatePicker.js"></script>
    <script>
        $(function () {
            var startDate = $("#startDate").val();
            var endDate = $("#endDate").val();
            var start = startDate.substring(5).replace("-", ".");
            var end = endDate.substring(5).replace("-", ".");
            var selectedArea=$("#area").val();
            console.log("区域"+selectedArea);
            console.log("开始"+start);
            console.log("结束"+end);
            $.ajax({
                type: "POST",
                dataType: "JSON",
                data: {"startDate": startDate, "endDate": endDate},
                url: "getHighcharts.action",
                success: function (result) {

                    /*举报状态*/
                    $('#repStatus').highcharts({
                        navigation: {
                            buttonOptions: {
                                enabled: false
                            }
                        },//去掉下载标志
                        credits: {
                            text: '',
                            href: ''
                        },//去掉版权信息
                        chart: {
                            plotBackgroundColor: null,
                            plotBorderWidth: null,
                            plotShadow: false,
                            spacingLeft: 0
                        },
                        title: {//主标题
                            style: {"color": "#333333", "fontSize": "15px"},
                            text: '举报状态(' + start + '-' + end + ')'
                        },
                        subtitle: {//副标题
                            align: 'right',
                            text: '总数&nbsp;:&nbsp;' + result.bench.totalCount + '<br/>未处理&nbsp;:&nbsp;' + result.bench.unProcess + '<br/>跟踪中&nbsp;:&nbsp;' + result.processing + '<br/>已处理&nbsp;:&nbsp;' + result.processed + '<br/>已关闭&nbsp;:&nbsp;' + result.closed,
                            useHTML: true,
                            verticalAlign: 'top',
                            x: -5,
                            y: 80,
                        },
//                        legend : {
//                            align: 'left'
//                        },
                        tooltip: {
                            headerFormat: '{series.name}<br>',
                            pointFormat: '{point.name}: <b>{point.percentage:.1f}%</b>'
                        },
                        plotOptions: {
                            pie: {
                                allowPointSelect: true,
                                cursor: 'pointer',
                                dataLabels: {
                                    enabled: false
                                },
                                showInLegend: true
                            }
                        },
                        series: [{
                            type: 'pie',
                            name: '举报',
                            data: [
                                ['未处理', result.unProcess],
                                ['跟踪中', result.processing],
                                ['已处理', result.processed],
                                ['已关闭', result.closed],
//                                {
//                                    name: 'Chrome',
//                                    y: 12.8,
//                                    sliced: true,
//                                    selected: true
//                                },
                            ]
                        }]
                    });

                    /*各业务条线举报分析*/
                    $('#repType').highcharts({
                        navigation: {
                            buttonOptions: {
                                enabled: false
                            }
                        },
                        credits: {
                            text: '',
                            href: ''
                        },//去掉版权信息
                        chart: {
                            type: 'column'
                        },
                        title: {//主标题
                            style: {"color": "#333333", "fontSize": "15px"},
                            text: '各业务条线举报分析(' + start + '-' + end + ')'
                        },
                        xAxis: [{
                            categories: [
                                '营销',
                                '工程',
                                '成本',
                                '招采',
                                '财务',
                                '法务',
                                '行政',
                                '人力',
                                '开发',
                                '研发',
                                '投资',
                                '其他',
                                '物业管理',
                                '酒店管理',
                                '商业管理'
                            ],
                            labels: {
                                enabled: false
                            },
                            crosshair: true
                        }],
                        yAxis: {
                            min: 0,
                            allowDecimals: false,
                            title: {
                                text: ''
                            }
                        },
                        tooltip: {
                            headerFormat: '<span style="font-size:10px"></span><table>',
                            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                            '<td style="padding:0"><b>{point.y:.0f} </b></td></tr>',
                            footerFormat: '</table>',
                            shared: true,
                            useHTML: true
                        },
                        plotOptions: {
                            column: {
                                pointPadding: 0.2,
                                borderWidth: 0
                            },
                            series: {
                                borderWidth: 0,
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.y:.0f}'
                                }
                            }
                        },
                        series: [{
                            name: '营销',
                            data: [result.sale]
                        }, {
                            name: '工程',
                            data: [result.project]
                        }, {
                            name: '成本',
                            data: [result.cost]
                        }, {
                            name: '招采',
                            data: [result.forMining]
                        }, {
                            name: '财务',
                            data: [result.finance]
                        }, {
                            name: '法务',
                            data: [result.forensic]
                        }, {
                            name: '行政',
                            data: [result.administration]
                        }, {
                            name: '人力',
                            data: [result.manpower]
                        }, {
                            name: '开发',
                            data: [result.development]
                        }, {
                            name: '研发',
                            data: [result.rAndD]
                        }, {
                            name: '投资',
                            data: [result.iAndD]
                        }, {
                            name: '其他',
                            data: [result.Other]
                        }, {
                            name: '物业管理',
                            data: [result.propertyManagement]
                        }, {
                            name: '酒店管理',
                            data: [result.hotelManagement]
                        }, {
                            name: '商业管理',
                            data: [result.businessManagement]
                        }
                        ]
                    });

                    /*举报质量分析*/
                    $('#repResult').highcharts({
                        navigation: {
                            buttonOptions: {
                                enabled: false
                            }
                        },//去掉下载标志
                        credits: {
                            text: '',
                            href: ''
                        },//去掉版权信息
                        chart: {
                            plotBackgroundColor: null,
                            plotBorderWidth: null,
                            plotShadow: false
                        },
                        title: {//主标题
                            style: {"color": "#333333", "fontSize": "15px"},
                            text: '举报质量分析(' + start + '-' + end + ')'
                        },
                        subtitle: {//副标题
                            align: 'right',
                            text: '总数&nbsp;:&nbsp;' + result.resultNum + '<br/>举报无效&nbsp;:&nbsp;' + result.invalid + '<br/>移交客诉&nbsp;:&nbsp;' + result.complainNum + '<br/>举报受理&nbsp;:&nbsp;' + result.verified + '<br/>举报属实&nbsp;:&nbsp;' + result.confirmed + '<br/>举报不实&nbsp;:&nbsp;' + result.unreaListic + '<br/>转为线索&nbsp;:&nbsp;' + result.clue +'<br/>移交其它部门&nbsp;:&nbsp;' + result.transfer,
                            useHTML: true,
                            verticalAlign: 'top',
                            x: -5,
                            y: 80,
                        },
                        tooltip: {
                            headerFormat: '{series.name}<br>',
                            pointFormat: '{point.name}: <b>{point.percentage:.1f}%</b>'
                        },
                        plotOptions: {
                            pie: {
                                allowPointSelect: true,
                                cursor: 'pointer',
                                dataLabels: {
                                    enabled: false
                                },
                                showInLegend: true
                            }
                        },
                        series: [{
                            type: 'pie',
                            name: '举报',
                            data: [
                                ['举报无效', result.invalid],
                                ['移交客诉', result.complainNum],
                                ['举报受理', result.verified],
                                ['举报属实', result.confirmed],
                                ['举报不实', result.unreaListic],
                                ['转为线索', result.clue],
                                ['移交其它部门', result.transfer]
                            ]
                        }]
                    });

                    /*区域举报状态分析图*/
                    $('#repArea').highcharts({
                        navigation: {
                            buttonOptions: {
                                enabled: false
                            }
                        },
                        credits: {
                            text: '',
                            href: ''
                        },//去掉版权信息
                        chart: {
                            type: 'column'
                        },
                        title: {//主标题
                            style: {"color": "#333333", "fontSize": "15px"},
                            text: '区域举报状态分析图(' + start + '-' + end + ')'
                        },
                        xAxis: [{
                            categories: [
                                '营销',
                                '工程',
                                '成本',
                                '招采',
                                '财务',
                                '法务',
                                '行政',
                                '人力',
                                '开发',
                                '研发',
                                '投资',
                                '其他',
                                '物业管理',
                                '酒店管理',
                                '商业管理'
                            ],
                            labels: {
                                enabled: false
                            },
                            crosshair: true
                        }],
                        yAxis: {
                            min: 0,
                            allowDecimals: false,
                            title: {
                                text: ''
                            }
                        },
                        tooltip: {
                            headerFormat: '<span style="font-size:10px"></span><table>',
                            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                            '<td style="padding:0"><b>{point.y:.0f} </b></td></tr>',
                            footerFormat: '</table>',
                            shared: true,
                            useHTML: true
                        },
                        plotOptions: {
                            column: {
                                pointPadding: 0.2,
                                borderWidth: 0
                            },
                            series: {
                                borderWidth: 0,
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.y:.0f}'
                                }
                            }
                        },
                        //修改数据源
                        series: [{
                            name: '营销',
                            data: [result.sale]
                        }, {
                            name: '工程',
                            data: [result.project]
                        }, {
                            name: '成本',
                            data: [result.cost]
                        }, {
                            name: '招采',
                            data: [result.forMining]
                        }, {
                            name: '财务',
                            data: [result.finance]
                        }, {
                            name: '法务',
                            data: [result.forensic]
                        }, {
                            name: '行政',
                            data: [result.administration]
                        }, {
                            name: '人力',
                            data: [result.manpower]
                        }, {
                            name: '开发',
                            data: [result.development]
                        }, {
                            name: '研发',
                            data: [result.rAndD]
                        }, {
                            name: '投资',
                            data: [result.iAndD]
                        }, {
                            name: '其他',
                            data: [result.Other]
                        }, {
                            name: '物业管理',
                            data: [result.propertyManagement]
                        }, {
                            name: '酒店管理',
                            data: [result.hotelManagement]
                        }, {
                            name: '商业管理',
                            data: [result.businessManagement]
                        }
                        ]
                    });

                    /*举报途径分析*/
                    $('#repApproach').highcharts({
                        navigation: {
                            buttonOptions: {
                                enabled: false
                            }
                        },
                        credits: {
                            text: '',
                            href: ''
                        },//去掉版权信息
                        chart: {
                            type: 'column'
                        },
                        title: {//主标题
                            style: {"color": "#333333", "fontSize": "15px"},
                            text: '举报途径分析(' + start + '-' + end + ')'
                        },
                        xAxis: [{
                            categories: [
                                '微信公众号',
                                '官网',
                                '融E',
                                '融创OA系统',
                                '线下扫码',
                                '电话',
                                '供应商系统',
                                '邮件',
                                '来访'
                            ],
                            labels: {
                                enabled: false
                            },
                            crosshair: true
                        }],
                        yAxis: {
                            min: 0,
                            allowDecimals: false,
                            title: {
                                text: ''
                            }
                        },
                        tooltip: {
                            headerFormat: '<span style="font-size:10px"></span><table>',
                            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                            '<td style="padding:0"><b>{point.y:.0f} </b></td></tr>',
                            footerFormat: '</table>',
                            shared: true,
                            useHTML: true
                        },
                        plotOptions: {
                            column: {
                                pointPadding: 0.2,
                                borderWidth: 0
                            },
                            series: {
                                borderWidth: 0,
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.y:.0f}'
                                }
                            }
                        },
                        //修改数据源
                        series: [{
                            name: '微信公众号',
                            data: [result.weChat]
                        }, {
                            name: '官网',
                            data: [result.web]
                        }, {
                            name: '融E',
                            data: [result.sunacE]
                        }, {
                            name: '融创OA系统',
                            data: [result.oa]
                        }, {
                            name: '线下扫码',
                            data: [result.offline]
                        }, {
                            name: '电话',
                            data: [result.phone]
                        }, {
                            name: '供应商系统',
                            data: [result.supplier]
                        }, {
                            name: '邮件',
                            data: [result.email]
                        }, {
                            name: '来访',
                            data: [result.visit]
                        }
                        ]
                    });
                }
            });
            /* $('#total').highcharts({
             });*/
        });
        //选择区域
//        function  selectArea(value){
//            var selAreaTemp=$("#areaTemp").val();
//            $("#area").val(selAreaTemp);
//        }

        function getRegion(ts_describe){
            console.log(ts_describe);
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        var data1 = returnedData.ctBbtcRegionList;
//                            console.log(data1[0].name);
//                            console.log(data2[0].name);
                        var selectNode = $("#area");
                        selectNode.empty();//每次需要将上一次的数据进行清空
                        $("#area").append("<option value=''>请选择</option>");
                        if (data1 != '') {
                            var slsb=document.getElementById("area");
                            for (var i = 0;i < data1.length;i++){
                                slsb.append(new Option(data1[i].name,data1[i].id));
                            }
                        }
                    /* $("#area").prepend("<option value=''>请选择</option>");*/

                    },error:function(data){
                        alert(系统错误);
                    }
                });
            }else{
                top.$.jBox.tip('请选择被举报集团', 'warning');
            }

        }

    </script>
</head>
<body>
<form:form id="searchForm" modelAttribute="workbench" action="${ctx}/workbench/list" method="post"
           class="breadcrumb form-search">
    <%--<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>--%>
    <%--<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>--%>

    <%--处理状态--%>
    <input id="processStatus" name="processStatus" type="hidden" value="${reportStatus}"/>
    <ul class="ul-form">
        <li><label><h3>工作台</h3></label></li>
        <li class="btns" style="float: right">
            <label style="width:auto;">
                <input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>&nbsp;&nbsp;
            </label>
        </li>
        <li style="float: right"><label>至：</label><input id="endDate" name="endDate" readonly="readonly" type="text"
                                                         maxlength="200" class="Wdate" style="width: auto"
                                                         onClick="WdatePicker({lang:'zh-cn',minDate:'#F{$dp.$D(\'startDate\')}'})"
                                                         value="${workbench.endDate}"/></li>
        <li style="float: right"><label>日期：</label><input id="startDate" name="startDate" readonly="readonly"
                                                          type="text"
                                                          maxlength="200" class="Wdate" style="width: auto"
                                                          onClick="WdatePicker({lang:'zh-cn',maxDate:'#F{$dp.$D(\'endDate\')}'})"
                                                          value="${workbench.startDate}"/></li>
        <c:if test="${workbench.userRoleName eq '系统管理员'}">
       <%-- <li style="float: right">
            <label>区域：</label>
            <form:select path="area" htmlEscape="false" class="input-medium">
                <form:option value="">全部区域</form:option>
                <form:option value="North China">华北区域公司</form:option>
                <form:option value="BeiJing">北京区域公司</form:option>
                <form:option value="ShangHai">上海区域公司</form:option>
                <form:option value="SouthWest">西南区域公司</form:option>
                <form:option value="SouthEast">东南区域公司</form:option>
                <form:option value="Central China">华中区域公司</form:option>
                <form:option value="GuangShen">广深区域公司</form:option>
                <form:option value="Hainan">海南区域公司</form:option>
                <form:option value="Group">集团本部</form:option>
                <form:option value="PropertyGroup">物业集团</form:option>
            </form:select>
        </li>--%>
            <li><label>所属集团：</label>
                <form:select id="supplementGroup" path="supplementGroup" class="input-small required" onchange="getRegion(value)">
                    <form:option value="">请选择</form:option>
                    <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                                  htmlEscape="false"/>
                </form:select>
            </li>

            <li><label>所属区域：</label>
                    <%-- <select id="supplementArea" path="supplementArea" class="input-small required" onchange="resetPageNo();">
                         <option value="">请选择</option>
                             &lt;%&ndash;<options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"&ndash;%&gt;
                             &lt;%&ndash;htmlEscape="false"/></select>&ndash;%&gt;
                     </select>--%>
                <form:select id="area"  onchange="resetPageNo();" path="area" class="input-small">
                    <form:option value="">请选择</form:option>
                </form:select>
            </li>
        </c:if>
    </ul>
    </ul>
    <ul class="ul-form">
            <div id="repStatus" style="min-width:40%;height:280px;float:left;background-color:#FFFFFF "
                 class="breadcrumb form-search"></div>
            <div id="repApproach" style="min-width:54%;height:280px;float:right;background-color:#FFFFFF "
                 class="breadcrumb form-search"></div>
        </div>
    </ul>
    <ul class="ul-form">
        <div style="background-color: #FFFFFF">
            <div id="repResult" style="min-width:40%;height:280px;float:left;background-color:#FFFFFF "
                 class="breadcrumb form-search"></div>
            <div id="repType" style="min-width:54%;height:280px;float:right;background-color: #FFFFFF"
                 class="breadcrumb form-search"></div>
        </div>
    </ul>
<%--<ul class="ul-form">--%>
    <%--<div style="background-color: #FFFFFF">--%>
        <%--<div id="repArea" style="min-width:100%;height:280px;float:left;background-color:#FFFFFF "--%>
             <%--class="breadcrumb form-search"></div>--%>
    <%--</div>--%>
<%--</ul>--%>
</form:form>
<ul class="nav nav-tabs">
    <li <c:if test="${workbench.processStatus eq '0'}">class="active"</c:if>><a
            href="${ctx}/workbench/list?processStatus=0&startDate=${workbench.startDate}&endDate=${workbench.endDate}">未处理举报</a>
    </li>
    <li <c:if test="${workbench.processStatus eq '1'}">class="active"</c:if>><a
            href="${ctx}/workbench/list?processStatus=1&startDate=${workbench.startDate}&endDate=${workbench.endDate}">跟踪中举报</a>
    </li>
    <li style="float: right;"><a href="${ctx}/report/list">查看更多</a></li>
</ul>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>ID</th>
        <th>标题</th>
        <th >所属集团</th>
        <th >所属区域</th>
        <th >业务类型</th>
        <th >业务类别</th>
        <th>被举报项目/部门</th>
        <th>被举报人</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:if test="${repList.size()>0}">
        <c:forEach items="${repList}" var="report" varStatus="vs">

            <tr>
                <td>${vs.index + 1}</td>
                <td>${report.supplementTitle}</td>
                <td align="center">
                    <c:if test="${report.supplementGroup eq '3437402691677202102'}">集团本部</c:if>
                    <c:if test="${report.supplementGroup eq '3510129313047280678'}">区域集团</c:if>
                    <c:if test="${report.supplementGroup eq '3565898923067676254'}">服务集团</c:if>
                    <c:if test="${report.supplementGroup eq '3806696792996264972'}">文化集团</c:if>
                    <c:if test="${report.supplementGroup eq '3770618512934949260'}">文旅集团</c:if>
                    <c:if test="${report.supplementGroup eq null}">--</c:if>
                </td>

                <td align="center">${report.supplementArea}</td>

                <td align="center">${report.supplementType}</td>
                <td align="center">${report.supplementCategory}</td>
                <td>${report.reportProject}</td>
                <td>${report.supplementInformant}</td>
                <td>
                    <a href="${ctx}/report/view?id=${report.id}">查看</a>
                </td>
            </tr>
        </c:forEach>
    </c:if>
    </tbody>
</table>
<c:if test="${repList.size()=='0'}">
    <span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
</c:if>
<%--  <c:if test="${page.list.size()>0}">
  <div class="pagination">${page}</div>
  </c:if>--%>
</body>
</html>