<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>常见问题详情</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctx}/faq/list/">常见问题列表</a></li>
	<li class="active"><a href="${ctx}/faq/detail?faqId=${entity.faqId}">常见问题详情</a></li>
</ul><br/>
<form id="inputForm" action="" method="post" class="form-horizontal">
	<div class="control-group">
		<label class="control-label">一级分类:</label>
		<div class="controls">
			${entity.categoryEntity.parent.name}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">二级分类:</label>
		<div class="controls">
			${entity.categoryEntity.name}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">问题标题:</label>
		<div class="controls">
			${entity.title}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">上传的图片:</label>
		<c:if test="${entity.href eq null or entity.href eq ''}">
			无
		</c:if>
		<c:if test="${entity.href ne null and entity.href ne ''}">
			<div class="controls">
				<iframe src="${entity.href}" width="100%" height="91%" frameborder="0"></iframe>
			</div>
		</c:if>
	</div>
</form>
</body>
</html>