package com.ejweb.modules.report.web;

import com.ejweb.conf.GConstants;
import com.ejweb.core.base.BaseController;
import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.report.entity.ReportAttachmentEntity;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.service.ReportService;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;

/**
 * 举报转为文档Controller
 * @author lixy
 * @version 2017-09-21
 */
@Controller
@RequestMapping(value = "${adminPath}/report")
public class ReportToPdfController extends BaseController {
    @Autowired
    private ReportService reportService;

    @ModelAttribute
    public ReportEntity get(@RequestParam(required = false) String id) {
        if (StringUtils.isNotBlank(id)) {
            return reportService.get(id);
        } else {
            return new ReportEntity();
        }
    }

    @RequestMapping(value = "document")
    public void document(ReportEntity reportEntity, String flag, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) throws IOException, DocumentException {
        Document document = new Document(PageSize.A4, 30, 30, 30, 30);
        BaseFont bfChinese = BaseFont.createFont("STSongStd-Light","UniGB-UCS2-H",BaseFont.NOT_EMBEDDED);
        Font title = new Font(bfChinese,16,Font.BOLD);//文字加粗
        Font textfont = new Font(bfChinese,14,Font.NORMAL);//正常文字
        Font urlfont = new Font(bfChinese,12,Font.NORMAL);//路径文字
        //document是创建的文档,FileOutputStream是向文档中输入
        String reportProjectTitle = reportEntity.getReportProject();
        if (reportProjectTitle.contains("/")){
            reportProjectTitle = reportProjectTitle.replace("/","|");
        }
        if (reportProjectTitle.contains("\\")){
            reportProjectTitle = reportProjectTitle.replace("\\","|");
        }
        PdfWriter.getInstance(document, new FileOutputStream(GConstants.FILE_UPLOAD_DIR+"pdf/"+reportProjectTitle+"_"+reportEntity.getId()+".pdf"));
//        PdfWriter.getInstance(document, new FileOutputStream("D:/1.pdf"));
        //打开文档
        document.open();
        Paragraph pt1 = new Paragraph("举报内容",title);
        pt1.setAlignment(0);//设置文字居中 0靠左   1，居中     2，靠右
        document.add(pt1);
        Paragraph blankRow1 = new Paragraph(18f, " ", textfont);
        document.add(blankRow1);
        PdfPTable table1 = new PdfPTable(2);
        table1.setTotalWidth(new float[] { 5, 10});               //设置表头列宽
        PdfPCell reportProject = new PdfPCell(new Paragraph("被举报项目：",textfont));
        reportProject.setBorderWidth(0);
        table1.addCell(reportProject);
        PdfPCell reportProject1 = new PdfPCell(new Paragraph(reportEntity.getReportProject()==null?"":reportEntity.getReportProject(),textfont));
        reportProject1.setBorderWidth(0);
        table1.addCell(reportProject1);
        PdfPCell supplementInformant = new PdfPCell(new Paragraph("被举报人：", textfont));
        supplementInformant.setBorderWidth(0);
        table1.addCell(supplementInformant);
        PdfPCell supplementInformant1 = new PdfPCell(new Paragraph(reportEntity.getSupplementInformant() == null ? "" : reportEntity.getSupplementInformant(), textfont));
        supplementInformant1.setBorderWidth(0);
        table1.addCell(supplementInformant1);
        PdfPCell reportCity = new PdfPCell(new Paragraph("所在城市：",textfont));
        reportCity.setBorderWidth(0);
        table1.addCell(reportCity);
        PdfPCell reportCity1 = new PdfPCell(new Paragraph(reportEntity.getReportCity()==null?"":reportEntity.getReportCity(),textfont));
        reportCity1.setBorderWidth(0);
        table1.addCell(reportCity1);
        PdfPCell reportTime = new PdfPCell(new Paragraph("举报时间：",textfont));
        reportTime.setBorderWidth(0);
        table1.addCell(reportTime);
        PdfPCell reportTime1 = new PdfPCell(new Paragraph(reportEntity.getReportTime()==null?"":reportEntity.getReportTime(),textfont));
        reportTime1.setBorderWidth(0);
        table1.addCell(reportTime1);
        PdfPCell reportContent = new PdfPCell(new Paragraph("内容：",textfont));
        reportContent.setBorderWidth(0);
        table1.addCell(reportContent);
        PdfPCell reportContent1 = new PdfPCell(new Paragraph(reportEntity.getReportContent()==null?"":reportEntity.getReportContent(),textfont));
        reportContent1.setBorderWidth(0);
        table1.addCell(reportContent1);
        PdfPCell reportAttachment = new PdfPCell(new Paragraph("附件：",textfont));
        reportAttachment.setBorderWidth(0);
        table1.addCell(reportAttachment);
        //获取附件列表
        ReportAttachmentEntity reportAttachmentBean = new ReportAttachmentEntity();
        reportAttachmentBean.setReportId(reportEntity.getId());
        reportAttachmentBean.setAttachmentType("0");
        List<ReportAttachmentEntity> list = reportService.getAttachmentInfo(reportAttachmentBean);

        Paragraph paragraphPath1 = new Paragraph();
        if (list != null && list.size() != 0) {
            for (ReportAttachmentEntity reportAttachmentEntity : list) {
                Chunk chunk = new Chunk(reportAttachmentEntity.getAttachmentName(),urlfont);
                paragraphPath1.add(chunk);
                paragraphPath1.add(Chunk.NEWLINE);
            }
        }
        PdfPCell reportAttachment1 = new PdfPCell(paragraphPath1);
        reportAttachment1.setBorderWidth(0);
        table1.addCell(reportAttachment1);
        document.add(table1);

        Paragraph pt2 = new Paragraph("举报人信息",title);
        pt2.setAlignment(0);//设置文字居中 0靠左   1，居中     2，靠右
        document.add(pt2);
        Paragraph blankRow2 = new Paragraph(18f, " ", textfont);
        document.add(blankRow2);
        PdfPTable table2 = new PdfPTable(2);
        table2.setTotalWidth(new float[] { 5, 10});               //设置表头列宽
        PdfPCell reportPersonName = new PdfPCell(new Paragraph("姓名：",textfont));
        reportPersonName.setBorderWidth(0);
        table2.addCell(reportPersonName);
        PdfPCell reportPersonName1 = new PdfPCell(new Paragraph(reportEntity.getReportPersonName()==null?"":reportEntity.getReportPersonName(),textfont));
        reportPersonName1.setBorderWidth(0);
        table2.addCell(reportPersonName1);
        PdfPCell reportPersonTel = new PdfPCell(new Paragraph("手机号：",textfont));
        reportPersonTel.setBorderWidth(0);
        table2.addCell(reportPersonTel);
        PdfPCell reportPersonTel1 = new PdfPCell(new Paragraph(reportEntity.getReportPersonTel()==null?"":reportEntity.getReportPersonTel(),textfont));
        reportPersonTel1.setBorderWidth(0);
        table2.addCell(reportPersonTel1);
        PdfPCell reportPersonEmail = new PdfPCell(new Paragraph("Email：",textfont));
        reportPersonEmail.setBorderWidth(0);
        table2.addCell(reportPersonEmail);
        PdfPCell reportPersonEmail1 = new PdfPCell(new Paragraph(reportEntity.getReportPersonEmail()==null?"":reportEntity.getReportPersonEmail(),textfont));
        reportPersonEmail1.setBorderWidth(0);
        table2.addCell(reportPersonEmail1);
        PdfPCell reportSource = new PdfPCell(new Paragraph("举报途径：",textfont));
        reportSource.setBorderWidth(0);
        table1.addCell(reportSource);
        String report_source = reportEntity.getReportSource();
        if (StringUtils.isNotBlank(report_source)){
            if (report_source.equals("web")){
                report_source = "官网";
            }else if (report_source.equals("oa")){
                report_source = "融创OA系统";
            }else if (report_source.equals("supplier")){
                report_source = "供应商系统";
            }else if (report_source.equals("wechat")){
                report_source = "微信公众号";
            }else if (report_source.equals("sunacE")){
                report_source = "融E";
            }else if (report_source.equals("offline")){
                report_source = "线下扫码";
            }else if (report_source.equals("tel")){
                report_source = "电话";
            }else if (report_source.equals("email")){
                report_source = "邮件";
            }else if (report_source.equals("visit")){
                report_source = "来访";
            }
        }else {
            report_source = "";
        }
        PdfPCell reportSource1 = new PdfPCell(new Paragraph(report_source,textfont));
        reportSource1.setBorderWidth(0);
        table1.addCell(reportSource1);
        document.add(table2);
        if (!reportEntity.getReportStatus().equals("0")) {
            Paragraph pt3 = new Paragraph("举报信息补充", title);
            pt3.setAlignment(0);//设置文字居中 0靠左   1，居中     2，靠右
            document.add(pt3);
            Paragraph blankRow3 = new Paragraph(18f, " ", textfont);
            document.add(blankRow3);
            PdfPTable table3 = new PdfPTable(2);
            table3.setTotalWidth(new float[]{5, 10});               //设置表头列宽
            PdfPCell supplementTitle = new PdfPCell(new Paragraph("标题：", textfont));
            supplementTitle.setBorderWidth(0);
            table3.addCell(supplementTitle);
            PdfPCell supplementTitle1 = new PdfPCell(new Paragraph(reportEntity.getSupplementTitle() == null ? "" : reportEntity.getSupplementTitle(), textfont));
            supplementTitle1.setBorderWidth(0);
            table3.addCell(supplementTitle1);
            PdfPCell supplementCompany = new PdfPCell(new Paragraph("被举报公司：", textfont));
            supplementCompany.setBorderWidth(0);
            table3.addCell(supplementCompany);
            PdfPCell supplementCompany1 = new PdfPCell(new Paragraph(reportEntity.getSupplementCompany() == null ? "" : reportEntity.getSupplementCompany(), textfont));
            supplementCompany1.setBorderWidth(0);
            table3.addCell(supplementCompany1);
            PdfPCell supplementDepartment = new PdfPCell(new Paragraph("被举报部门：", textfont));
            supplementDepartment.setBorderWidth(0);
            table3.addCell(supplementDepartment);
            PdfPCell supplementDepartment1 = new PdfPCell(new Paragraph(reportEntity.getSupplementDepartment() == null ? "" : reportEntity.getSupplementDepartment(), textfont));
            supplementDepartment1.setBorderWidth(0);
            table3.addCell(supplementDepartment1);
            PdfPCell supplementType = new PdfPCell(new Paragraph("业务类型：", textfont));
            supplementType.setBorderWidth(0);
            table3.addCell(supplementType);
            String supplement_type = reportEntity.getSupplementType();
            if (StringUtils.isNotBlank(supplement_type)) {
                if (supplement_type.equals("1")) {
                    supplement_type = "营销";
                } else if (supplement_type.equals("2")) {
                    supplement_type = "工程";
                } else if (supplement_type.equals("3")) {
                    supplement_type = "成本";
                } else if (supplement_type.equals("4")) {
                    supplement_type = "招采";
                } else if (supplement_type.equals("5")) {
                    supplement_type = "人力";
                } else if (supplement_type.equals("6")) {
                    supplement_type = "物业";
                } else if (supplement_type.equals("7")) {
                    supplement_type = "投诉";
                }
            } else {
                supplement_type = "";
            }
            PdfPCell supplementType1 = new PdfPCell(new Paragraph(supplement_type, textfont));
            supplementType1.setBorderWidth(0);
            table3.addCell(supplementType1);
            PdfPCell supplementArea = new PdfPCell(new Paragraph("被举报区域：", textfont));
            supplementArea.setBorderWidth(0);
            table3.addCell(supplementArea);
            String supplement_area = reportEntity.getSupplementArea();
            if (StringUtils.isNotBlank(supplement_area)) {
                if (supplement_area.equals("North China")) {
                    supplement_area = "华北区域公司";
                } else if (supplement_area.equals("BeiJing")) {
                    supplement_area = "北京区域公司";
                } else if (supplement_area.equals("ShangHai")) {
                    supplement_area = "上海区域公司";
                } else if (supplement_area.equals("SouthWest")) {
                    supplement_area = "西南区域公司";
                } else if (supplement_area.equals("SouthEast")) {
                    supplement_area = "东南区域公司";
                } else if (supplement_area.equals("Central China")) {
                    supplement_area = "华中区域公司";
                } else if (supplement_area.equals("GuangShen")) {
                    supplement_area = "广深区域公司";
                } else if (supplement_area.equals("Hainan")) {
                    supplement_area = "海南区域公司";
                } else if (supplement_area.equals("Group")) {
                    supplement_area = "集团本部";
                }
            } else {
                supplement_area = "";
            }
            PdfPCell supplementArea1 = new PdfPCell(new Paragraph(supplement_area, textfont));
            supplementArea1.setBorderWidth(0);
            table3.addCell(supplementArea1);
//            PdfPCell supplementProject = new PdfPCell(new Paragraph("被举报项目：", textfont));
//            supplementProject.setBorderWidth(0);
//            table3.addCell(supplementProject);
//            PdfPCell supplementProject1 = new PdfPCell(new Paragraph(reportEntity.getSupplementProject() == null ? "" : reportEntity.getSupplementProject(), textfont));
//            supplementProject1.setBorderWidth(0);
//            table3.addCell(supplementProject1);
            PdfPCell supplementContent = new PdfPCell(new Paragraph("内容：", textfont));
            supplementContent.setBorderWidth(0);
            table3.addCell(supplementContent);
            PdfPCell supplementContent1 = new PdfPCell(new Paragraph(reportEntity.getSupplementContent() == null ? "" : reportEntity.getSupplementContent(), textfont));
            supplementContent1.setBorderWidth(0);
            table3.addCell(supplementContent1);
            PdfPCell supplementAttachment = new PdfPCell(new Paragraph("附件：", textfont));
            supplementAttachment.setBorderWidth(0);
            table3.addCell(supplementAttachment);

            //获取附件列表
            ReportAttachmentEntity reportAttachmentBean1 = new ReportAttachmentEntity();
            reportAttachmentBean1.setReportId(reportEntity.getId());
            reportAttachmentBean1.setAttachmentType("1");
            List<ReportAttachmentEntity> list1 = reportService.getAttachmentInfo(reportAttachmentBean1);

            Paragraph paragraphPath2 = new Paragraph();
            if (list1 != null && list1.size() != 0) {
                for (ReportAttachmentEntity reportAttachmentEntity : list1) {
                    Chunk chunk = new Chunk(reportAttachmentEntity.getAttachmentName(), urlfont);
                    paragraphPath2.add(chunk);
                    paragraphPath2.add(Chunk.NEWLINE);
                }
            }
            PdfPCell supplementAttachment1 = new PdfPCell(paragraphPath2);
            supplementAttachment1.setBorderWidth(0);
            table3.addCell(supplementAttachment1);
            document.add(table3);
        }
        if (reportEntity.getReportStatus().equals("2")) {
            Paragraph pt3 = new Paragraph("处理结果", title);
            pt3.setAlignment(0);//设置文字居中 0靠左   1，居中     2，靠右
            document.add(pt3);
            Paragraph blankRow3 = new Paragraph(18f, " ", textfont);
            document.add(blankRow3);
            PdfPTable table4 = new PdfPTable(2);
            table4.setTotalWidth(new float[]{5, 10});               //设置表头列宽
            PdfPCell dealPersonName = new PdfPCell(new Paragraph("处理人：", textfont));
            dealPersonName.setBorderWidth(0);
            table4.addCell(dealPersonName);
            PdfPCell dealPersonName1 = new PdfPCell(new Paragraph(reportEntity.getDealPersonName() == null ? "" : reportEntity.getDealPersonName(), textfont));
            dealPersonName1.setBorderWidth(0);
            table4.addCell(dealPersonName1);
            PdfPCell dealAttachment = new PdfPCell(new Paragraph("处理成果文件：", textfont));
            dealAttachment.setBorderWidth(0);
            table4.addCell(dealAttachment);

            //获取附件列表
            ReportAttachmentEntity reportAttachmentBean2 = new ReportAttachmentEntity();
            reportAttachmentBean2.setReportId(reportEntity.getId());
            reportAttachmentBean2.setAttachmentType("2");
            List<ReportAttachmentEntity> list2 = reportService.getAttachmentInfo(reportAttachmentBean2);

            Paragraph paragraphPath2 = new Paragraph();
            if (list2 != null && list2.size() != 0) {
                for (ReportAttachmentEntity reportAttachmentEntity : list2) {
                    Chunk chunk = new Chunk(reportAttachmentEntity.getAttachmentName(), urlfont);
                    paragraphPath2.add(chunk);
                    paragraphPath2.add(Chunk.NEWLINE);
                }
            }
            PdfPCell dealAttachment1 = new PdfPCell(paragraphPath2);
            dealAttachment1.setBorderWidth(0);
            table4.addCell(dealAttachment1);
            PdfPCell dealResult = new PdfPCell(new Paragraph("处理结论：", textfont));
            dealResult.setBorderWidth(0);
            table4.addCell(dealResult);
            String deal_result = reportEntity.getDealResult();
            if (StringUtils.isNotBlank(deal_result)) {
                if (deal_result.equals("1")) {
                    deal_result = "投诉";
                } else if (deal_result.equals("2")) {
                    deal_result = "举报无效";
                } else if (deal_result.equals("3")) {
                    deal_result = "举报属实";
                }
            } else {
                deal_result = "";
            }
            PdfPCell dealResult1 = new PdfPCell(new Paragraph(deal_result, textfont));
            dealResult1.setBorderWidth(0);
            table4.addCell(dealResult1);
            document.add(table4);
        }
        document.close();
        PrintWriter out = response.getWriter();
        response.setContentType("application/json;charset=utf-8");
        out.write(GConstants.FILE_PREFIX_URL+"pdf/"+reportProjectTitle+"_"+reportEntity.getId()+".pdf");
        out.close();
    }
}
