/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.service;

import java.util.List;

import com.ejweb.modules.report.dao.CtBbtcRegionDao;
import com.ejweb.modules.report.entity.CtBbtcRegion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.service.CrudService;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.dao.CtBbtcBusTypeDao;


/**
 * 业务类型Service
 * @author haoqm
 * @version 2019-07-12
 */
@Service
@Transactional(readOnly = true)
public class CtBbtcBusTypeService extends CrudService<CtBbtcBusTypeDao, CtBbtcBusType> {

	@Autowired
	private CtBbtcBusTypeDao ctBbtcBusTypeDao;

	public CtBbtcBusType get(String id) {
		return super.get(id);
	}
	
	public List<CtBbtcBusType> findList(CtBbtcBusType ctBbtcBusType) {
		return super.findList(ctBbtcBusType);
	}
	
	public Page<CtBbtcBusType> findPage(Page<CtBbtcBusType> page, CtBbtcBusType ctBbtcBusType) {
		return super.findPage(page, ctBbtcBusType);
	}
	
	@Transactional(readOnly = false)
	public void save(CtBbtcBusType ctBbtcBusType) {
		super.save(ctBbtcBusType);
	}
	
	@Transactional(readOnly = false)
	public void delete(CtBbtcBusType ctBbtcBusType) {
		super.delete(ctBbtcBusType);
	}

	public List<CtBbtcBusType> getByGroupId(String groupId){
		return this.ctBbtcBusTypeDao.getByGroupId(groupId);
	}

}