/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.entity;

import com.ejweb.modules.sys.entity.Dict;
import org.hibernate.validator.constraints.Length;
import com.ejweb.core.persistence.DataEntity;

/**
 * 区域基础资料Entity
 * @author haoqm
 * @version 2019-07-12
 */
public class CtBbtcRegion extends DataEntity<CtBbtcRegion> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 区域编码
	private String name;		// 区域名称
	private String group;		// 所属集团
	private String groupName;		// 所属集团名称

	public CtBbtcRegion() {
		super();
	}

	public CtBbtcRegion(String id){
		super(id);
	}

	@Length(min=0, max=64, message="区域编码长度必须介于 0 和 64 之间")
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@Length(min=0, max=255, message="区域名称长度必须介于 0 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=64, message="所属集团长度必须介于 0 和 64 之间")
	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	
}