package com.ejweb.core.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.ejweb.conf.GConstants;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;

/**
 * 基本Entity
 * @team IT Team
 * @author  renmb
 * @version 1.0
 * @time 2016-03-10
 *
 */
public abstract class BaseEntity implements Serializable,Cloneable {

    /**
     * 
     */
    private static final long serialVersionUID = 5983695342897355824L;
    @JSONField(serialize=false)
    protected String id;
    
    @JSONField(serialize=false)
    protected String dbprefix;
    
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getDbprefix() {
        return GConstants.getValue("db.table.prefix", "");// 数据库表前缀
    }
    public void setDbprefix(String dbprefix) {
        this.dbprefix = dbprefix;
    }
    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
    /**
     * 获取数据库名称
     */
    @JsonIgnore
    public String getDbName(){
        return GConstants.getValue("jdbc.type");
    }
}
