package com.fos.modules.vipuser.service;

import java.util.ArrayList;
import java.util.List;

import com.fos.modules.myUserPre.bean.MyUserPreBean;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkEntity;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkTasteEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodTasteEntity;
import com.fos.modules.myUserPre.service.MyUserPreService;
import com.fos.modules.vipuser.bean.*;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.modules.vipuser.dao.VipUserDao;
import com.fos.modules.vipuser.entity.VipUserEntity;

@Service
public class VipUserService extends CurdService<VipUserDao, VipUserEntity> {

    @Autowired
    private MyUserPreService myUserPreService;


    //获取所有的nickname
    public List<VipUserEntity> getVipUserList(VipUserBean bean) {
        return dao.getVipUserList(bean);
    }

    ;

    //验证是否存在相同nickname
    public int checkNickName(CheckVipUserBean bean) {
        return dao.checkNickName(bean);
    }

    ;

    //新增vip用户
    public void insertVipUser(CheckVipUserBean bean) {
        dao.insertVipUser(bean);
    }

    ;

    //登陆vip用户
    public void updateVipUser(CheckVipUserBean bean) {
        dao.updateVipUser(bean);
    }

    ;

    //登出vip用户
    public void logoutVipUser(LogoutVipUserBean bean) {
        dao.logoutVipUser(bean);
        dao.logoutOrderVipUser(bean);
        dao.delVipUserSeat(bean);
    }

    ;

    //登出多个vip用户
    public void logoutAllVipUser(List<VipUserEntity> list, String sysName) {
        dao.logoutAllVipUser(list, sysName);
        dao.logoutAllOrderVipUser(list, sysName);
        dao.delAllVipUserSeat(list);
    }

    //查询vip用户信息
    public VipUserEntity getVipUserInfo(VipUserNickBean bean) {
        return dao.getVipUserInfo(bean);
    }
    //查询vip用户信息
    public VipUserEntity getLoginCount(CheckVipUserBean bean) {
        return dao.getLoginCount(bean);
    }
    //查询无座位vip用户信息
    public List<VipUserEntity> getVipUserNoSeat(VipUserNoSeatBean bean) {
        List<VipUserEntity> users = new ArrayList<VipUserEntity>();
        users = dao.getVipUserNoSeat(bean);
        MyUserPreBean preBean = new MyUserPreBean();
        for (VipUserEntity user : users) {
            preBean.setNickName(user.getNickName());
            // 获取该用户前3喜欢的食物
            List<MyUserPreFoodEntity> myUserPreFoodList = myUserPreService.getMyUserPreFood(preBean);
            //获取该用户前3喜欢的食物口味
            List<MyUserPreFoodTasteEntity> myUserPreFoodTasteList = myUserPreService.getMyUserPreFoodTaste(preBean);
            //获取该用户前3喜欢的喝的
            List<MyUserPreDrinkEntity> myUserPreDrinkList = myUserPreService.getMyUserPreDrink(preBean);
            //获取该用户前3喜欢的喝的口味
            List<MyUserPreDrinkTasteEntity> myUserPreDrinkTasteList = myUserPreService.getMyUserPreDrinkTaste(preBean);
            user.setUserPreFoodList(myUserPreFoodList);
            user.setUserPreFoodTasteList(myUserPreFoodTasteList);
            user.setUserPreDrinkList(myUserPreDrinkList);
            user.setUserPreDrinkTasteList(myUserPreDrinkTasteList);
        }
        return users;
    }

    public int getUserId(String name) {
        return dao.getUserId(name);
    }

    public void insertUser(CheckVipUserBean bean) {
        dao.insertUser(bean);
    }

    public List<VipUserEntity> getVipUserBySeatList(LogoutAllVipUserBean bean) {
        return dao.getVipUserBySeatList(bean);
    }

}
