package com.fos.modules.vipuser.dao;

import java.util.List;

import com.fos.core.base.CurdDao;
import com.fos.modules.vipuser.bean.*;
import com.fos.modules.vipuser.entity.VipUserEntity;
import org.apache.ibatis.annotations.Param;

public interface VipUserDao extends CurdDao<VipUserEntity>{

	//获取所有的nickname
	public List<VipUserEntity> getVipUserList(VipUserBean bean);

	//获取相同昵称
	public int checkNickName(CheckVipUserBean bean);

	//新增vip用户
	public void insertVipUser(CheckVipUserBean bean);

	//登陆vip用户
	public void updateVipUser(CheckVipUserBean bean);

	//登出vip用户
	public void logoutVipUser(LogoutVipUserBean bean);

	//登出多个vip用户
	public void logoutAllVipUser(@Param(value = "list")List<VipUserEntity> list,@Param(value = "sysName") String sysName);

	//登出菜单
	public void logoutOrderVipUser(LogoutVipUserBean bean);

	//登出多个菜单
	public void logoutAllOrderVipUser(@Param(value = "list")List<VipUserEntity> list,@Param(value = "sysName") String sysName);

	//清除vip用户座位
	public void delVipUserSeat(LogoutVipUserBean bean);

	//清除多个vip用户座位
	public void delAllVipUserSeat(@Param(value = "list")List<VipUserEntity> list);

	//查询vip用户信息
	public VipUserEntity getVipUserInfo(VipUserNickBean bean);
	//查询vip用户信息
	public VipUserEntity getLoginCount(CheckVipUserBean bean);
	//查询vip用户信息
	public List<VipUserEntity> getVipUserNoSeat(VipUserNoSeatBean bean);

	public int getUserId(@Param(value = "name") String name);

	//统计用户
	public void insertUser(CheckVipUserBean bean);

	public List<VipUserEntity> getVipUserBySeatList(LogoutAllVipUserBean bean);
}
