package com.fos.modules.vipuser.api;

import java.util.List;

import com.fos.modules.tableView.service.Table2UserService;
import com.fos.modules.vipuser.bean.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.vipuser.entity.VipUserEntity;
import com.fos.modules.vipuser.service.VipUserService;

@Controller
@RequestMapping(value = "/api/vipuser")
public class VipUserController {

    @Autowired
    private VipUserService vipUserService;

    @Autowired
    private Table2UserService userService;

    @ResponseBody
    @RequestMapping(value = "/getVipUserList")
    public ResponseBean getVipUserList(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        VipUserBean bean = requestBean.getObjectBean(VipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            List<VipUserEntity> entities = vipUserService.getVipUserList(bean);
            if (entities.size() == 0) {
                responseBean.setMessage("No such user");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            } else {
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(entities);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/checkNickName")
    public ResponseBean checkNickName(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        CheckVipUserBean bean = requestBean.getObjectBean(CheckVipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            bean.setNickname(bean.getNickname().replaceAll(" ", ""));
            int num = vipUserService.checkNickName(bean);
            if (num == 0) {
            	//bean.setLoginCount(1);
                vipUserService.insertVipUser(bean);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            } else {
                responseBean.setMessage("User name in use");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/loginVipUser")
    public ResponseBean loginVipUser(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        CheckVipUserBean bean = requestBean.getObjectBean(CheckVipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            VipUserNickBean nickBean = new VipUserNickBean();
            nickBean.setNickName(bean.getNickname());
            VipUserEntity vipUserInfo = vipUserService.getVipUserInfo(nickBean);
            if (vipUserInfo.getStatus() == 1) {
                responseBean.setMessage("User is Logged in");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            } else {
            	
            	//int loginCount=vipUserInfo.getLoginCount()+1;
            	//bean.setLoginCount(loginCount);
                vipUserService.updateVipUser(bean);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/logoutVipUser")
    public ResponseBean logoutVipUser(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        LogoutVipUserBean bean = requestBean.getObjectBean(LogoutVipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            vipUserService.logoutVipUser(bean);

            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/getVipUserInfo")
    public ResponseBean getVipUserInfo(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        VipUserNickBean bean = requestBean.getObjectBean(VipUserNickBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            VipUserEntity entity = vipUserService.getVipUserInfo(bean);
            if (entity != null) {
                responseBean.setData(entity);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            } else {
                responseBean.setMessage("No passanger info yet");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/getVipUserNoSeat")
    public ResponseBean getVipUserNoSeat(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        VipUserNoSeatBean bean = requestBean.getObjectBean(VipUserNoSeatBean.class);
        String message = vipUserService.validate(bean);
        if (message == null) {
            List<VipUserEntity> userEntities = vipUserService.getVipUserNoSeat(bean);
            if (userEntities.size() > 0) {
                responseBean.setData(userEntities);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            } else {
                responseBean.setMessage("No user info yet");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/enterUser")
    public ResponseBean enterUser(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        CheckVipUserBean bean = requestBean.getObjectBean(CheckVipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            bean.setNickname(bean.getNickname().replaceAll(" ", ""));
            int num = vipUserService.checkNickName(bean);
            if (num == 0) {
            	//bean.setLoginCount(1);
                vipUserService.insertVipUser(bean);
                int userId = vipUserService.getUserId(bean.getNickname());
                bean.setUserId(userId);
                vipUserService.insertUser(bean);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            } else {
            	/*VipUserEntity vipUserEntity = vipUserService.getLoginCount(bean);
            	int loginCount=vipUserEntity.getLoginCount()+1;
            	bean.setLoginCount(loginCount);*/
                vipUserService.updateVipUser(bean);
                int userId = vipUserService.getUserId(bean.getNickname());
                bean.setUserId(userId);
                vipUserService.insertUser(bean);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/logoutAllVipUser")
    public ResponseBean logoutAllVipUser(RequestBean requestBean) {

        ResponseBean responseBean = new ResponseBean();

        LogoutAllVipUserBean bean = requestBean.getObjectBean(LogoutAllVipUserBean.class);

        String message = vipUserService.validate(bean);

        if (message == null) {
            String sysName = bean.getSysName();
            List<VipUserEntity> logUser = vipUserService.getVipUserBySeatList(bean);
            vipUserService.logoutAllVipUser(logUser, sysName);

            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }
}