package com.fos.modules.vipmenu.api;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.vipmenu.bean.VipMenuBean;
import com.fos.modules.vipmenu.entity.VipMenuEntity;
import com.fos.modules.vipmenu.entity.VipMenuPackEntity;
import com.fos.modules.vipmenu.service.VipMenuService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Tony on 7/19/2016.
 */

@Controller
@RequestMapping(value = "/api/vipmenu")
public class VipMenuController {

    @Autowired
    private VipMenuService vipMenuService;

    @ResponseBody
    @RequestMapping(value = "/getFoodMenu")
    public ResponseBean getFoodMenu(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        VipMenuBean bean = requestBean.getObjectBean(VipMenuBean.class);
        String message = vipMenuService.validate(bean);
        if (message == null) {
            Map<String, List<VipMenuEntity>> foods = new HashMap<String, List<VipMenuEntity>>();
            List<VipMenuEntity> foodMenuType = vipMenuService.getFoodMenuType();
            List<VipMenuEntity> entities = vipMenuService.getFoodMenu();
            for (VipMenuEntity type : foodMenuType) {
                List<VipMenuEntity> vipMenuEntities = new ArrayList<VipMenuEntity>();
                for (VipMenuEntity entity : entities) {
                    if (type.getFoodtype().equals(entity.getFoodtype())) {
                        if (StringUtils.isBlank(entity.getImage()) == false) {// 设置图片前缀

                            entity.setImage(GConstants.FILE_PREFIX_URL + entity.getImage());
                        }
                        if (StringUtils.isBlank(entity.getFoodIcon()) == false) {// 设置图片前缀

                            entity.setFoodIcon(GConstants.FILE_PREFIX_URL + entity.getFoodIcon());
                        }
                        vipMenuEntities.add(entity);
                    }
                }
                foods.put(type.getFoodtype(), vipMenuEntities);
            }
            if (entities.size() > 0) {
//                String foodMenuName = entities.get(0).getMenuName();
//                Map<String, Map<String, List<VipMenuEntity>>> foodMenu = new HashMap<String, Map<String, List<VipMenuEntity>>>();
//                foodMenu.put(foodMenuName, foods);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(foods);
                return responseBean;
            } else {
                responseBean.setMessage("No menu item record");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/getFoodMenuPackage")
    public ResponseBean getFoodMenuPackage(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        VipMenuBean bean = requestBean.getObjectBean(VipMenuBean.class);
        String message = vipMenuService.validate(bean);
        if (message == null) {

            List<VipMenuEntity> entities = vipMenuService.getFoodMenuPackage();
            if (entities.size() > 0) {
                VipMenuPackEntity vipMenuPackEntities = new VipMenuPackEntity();
                for (VipMenuEntity entity : entities) {
                    if (!"".equals(entity.getContain()) && entity.getContain() != null) {
                        if (StringUtils.isBlank(entity.getImage()) == false) {// 设置图片前缀
                            entity.setImage(GConstants.FILE_PREFIX_URL + entity.getImage());
                        }
                        if (StringUtils.isBlank(entity.getFoodIcon()) == false) {// 设置图片前缀
                            entity.setFoodIcon(GConstants.FILE_PREFIX_URL + entity.getFoodIcon());
                        }
                        if (entity.getContain().indexOf(",") != -1) {
                            String[] containArr = entity.getContain().split(",");
                            List<VipMenuEntity> menuEntities = vipMenuService.getFoodMenuPacks(containArr);
                            List<String> containFood = new ArrayList<String>();
                            List<String> containDrink = new ArrayList<String>();
                            List<String> containNoodle = new ArrayList<String>();
                            for (VipMenuEntity menuEntity : menuEntities) {
                                if (StringUtils.isBlank(menuEntity.getImage()) == false) {// 设置图片前缀
                                    menuEntity.setImage(GConstants.FILE_PREFIX_URL + menuEntity.getImage());
                                }
                                if (StringUtils.isBlank(menuEntity.getFoodIcon()) == false) {// 设置图片前缀
                                    menuEntity.setFoodIcon(GConstants.FILE_PREFIX_URL + menuEntity.getFoodIcon());
                                }
                                if (menuEntity.getFoodKind() == 0) {
                                    containFood.add(menuEntity.getFoodName());
                                } else if (menuEntity.getFoodKind() == 1) {
                                    containDrink.add(menuEntity.getFoodName());
                                } else if (menuEntity.getFoodKind() == 3) {
                                    containNoodle.add(menuEntity.getFoodName());
                                }
                            }
                            entity.setContainFood(containFood);
                            entity.setContainDrink(containDrink);
                            entity.setContainNoodle(containNoodle);
                            entity.setMenuPackaSet(menuEntities);
                        } else {
                            String[] containArr = new String[1];
                            containArr[0] = entity.getContain();
                            List<VipMenuEntity> menuEntities = vipMenuService.getFoodMenuPacks(containArr);
                            List<String> containFood = new ArrayList<String>();
                            List<String> containDrink = new ArrayList<String>();
                            List<String> containNoodle = new ArrayList<String>();
                            for (VipMenuEntity menuEntity : menuEntities) {
                                if (StringUtils.isBlank(menuEntity.getFoodIcon()) == false) {// 设置图片前缀
                                    menuEntity.setFoodIcon(GConstants.FILE_PREFIX_URL + menuEntity.getFoodIcon());
                                }
                                if (StringUtils.isBlank(menuEntity.getImage()) == false) {// 设置图片前缀
                                    menuEntity.setImage(GConstants.FILE_PREFIX_URL + menuEntity.getImage());
                                }
                                if (menuEntity.getFoodKind() == 0) {
                                    containFood.add(menuEntity.getFoodName());
                                } else if (menuEntity.getFoodKind() == 1) {
                                    containDrink.add(menuEntity.getFoodName());
                                } else if (menuEntity.getFoodKind() == 3) {
                                    containNoodle.add(menuEntity.getFoodName());
                                }
                            }
                            entity.setContainFood(containFood);
                            entity.setContainDrink(containDrink);
                            entity.setContainNoodle(containNoodle);
                            entity.setMenuPackaSet(menuEntities);
                        }
                    }
                }
                vipMenuPackEntities.setMenuPackage(entities);
                responseBean.setData(vipMenuPackEntities);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                return responseBean;
            } else {
                responseBean.setMessage("No menu set record");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }

        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

}
