package com.fos.modules.vipFoodPre.api;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.vipFoodPre.bean.VipFoodPreBean;
import com.fos.modules.vipFoodPre.entity.VipFoodPreEntity;
import com.fos.modules.vipFoodPre.service.VipFoodPreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * Created by Tony on 7/20/2016.
 */
@Controller
@RequestMapping(value = "/api/vipfoodpre")
public class VipFoodPreController {

    @Autowired
    private VipFoodPreService vipFoodPreService;

    @ResponseBody
    @RequestMapping(value = "/getAllFoodPre")
    public ResponseBean getAllFoodPre(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        VipFoodPreBean bean = requestBean.getObjectBean(VipFoodPreBean.class);
        String message = vipFoodPreService.validate(bean);
        if (message == null) {
            List<VipFoodPreEntity> entities = vipFoodPreService.getAllFoodPre(bean);
            if (entities.size() > 0) {
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(entities);
                return responseBean;
            } else {
                responseBean.setMessage("No taste preference yet");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }
}
