package com.fos.modules.userPre.api;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.userPre.bean.UserPreBean;
import com.fos.modules.userPre.entity.UserPreDrinkEntity;
import com.fos.modules.userPre.entity.UserPreDrinkTasteEntity;
import com.fos.modules.userPre.entity.UserPreEntity;
import com.fos.modules.userPre.entity.UserPreFoodEntity;
import com.fos.modules.userPre.entity.UserPreFoodTasteEntity;
import com.fos.modules.userPre.service.UserPreService;

@Controller
@RequestMapping(value = "/api/UserPreController")
public class UserPreController {

	@Autowired
	private UserPreService userPreService;
	
	
	@ResponseBody
	@RequestMapping(value = "/getUserPreFood")
	public ResponseBean getUserPreFood(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		UserPreBean userPreBean = requestBean.getObjectBean(UserPreBean.class);
		String message = userPreService.validate(userPreBean);
		if (message == null) {
			UserPreEntity userPreEntity = new UserPreEntity();
			// 获取该用户前3喜欢的食物
			List<UserPreFoodEntity> userPreFoodList = userPreService.getUserPreFood(userPreBean);
			//获取该用户前3喜欢的食物口味
			List<UserPreFoodTasteEntity> userPreFoodTasteList = userPreService.getUserPreFoodTaste(userPreBean);
			//获取该用户前3喜欢的喝的
			List<UserPreDrinkEntity> userPreDrinkList = userPreService.getUserPreDrink(userPreBean);
			//获取该用户前3喜欢的喝的口味
			List<UserPreDrinkTasteEntity> userPreDrinkTasteList = userPreService.getUserPreDrinkTaste(userPreBean);
			//将所有内容放入一个实体中，传给前端
			userPreEntity.setUserPreFoodList(userPreFoodList);
			userPreEntity.setUserPreFoodTasteList(userPreFoodTasteList);
			userPreEntity.setUserPreDrinkList(userPreDrinkList);
			userPreEntity.setUserPreFoodTasteList(userPreFoodTasteList);
			if(userPreEntity!=null){
				responseBean.setMessage(message);
				responseBean.setData(userPreEntity);
				responseBean.setStatus(GConstants.STATUS_CODE_2000);
				return responseBean;
			}
			responseBean.setMessage("Empty User Preferences");
			responseBean.setData(userPreEntity);
			responseBean.setStatus(GConstants.STATUS_CODE_4001);
			return responseBean;
		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}
	
}
